/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class OCVSWrapper {
    private static final Pattern _quotePattern = Pattern.compile("^'(.*)'$");
    static final int OPTION_EXPANSION_MODE = 0;
    private final String _wildcard;
    private final int _option;
    private final String _value;
    private Pattern _pattern;

    OCVSWrapper(String wildcard, int option, String value) {
        this._wildcard = wildcard;
        this._option = option;
        this._value = value;
    }

    static final OCVSWrapper parseWrapperSpec(String wrapperSpec) throws ParseException {
        String[] result = wrapperSpec.split("\\s");
        if (result.length < 3) {
            throw new ParseException(wrapperSpec, -1);
        }
        String wildcard = result[0];
        int option = -1;
        String value = result[2];
        if (result[1].equals("-k")) {
            option = 0;
        }
        if (option == -1) {
            throw new ParseException(wrapperSpec, -1);
        }
        Matcher matcher = _quotePattern.matcher(value);
        if (matcher.matches()) {
            value = matcher.group(1);
        }
        return new OCVSWrapper(wildcard, option, value);
    }

    public String getWildcard() {
        return this._wildcard;
    }

    public int getOption() {
        return this._option;
    }

    public String getValue() {
        return this._value;
    }

    public boolean matches(String filename) {
        if (this._pattern == null) {
            this._pattern = Pattern.compile(this.wildcard2Regexp(this._wildcard));
        }
        return this._pattern.matcher(filename).matches();
    }

    private String wildcard2Regexp(String wildcard) {
        StringBuffer regexp = new StringBuffer("^");
        char[] chars = wildcard.toCharArray();
        int n = chars.length;
        int i = 0;
        while (i < n) {
            char c = chars[i];
            if (Character.isLetterOrDigit(c)) {
                regexp.append(c);
            } else if (c == '\\') {
                regexp.append('\\');
                if (++i < n) {
                    regexp.append(chars[i]);
                }
            } else if (c == '*' || c == '?') {
                regexp.append('.').append(c);
            } else {
                regexp.append('\\').append(c);
            }
            ++i;
        }
        regexp.append("$");
        return regexp.toString();
    }
}

