/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.boot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeStarter;
import oracle.ide.Version;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.CommandException;
import oracle.javatools.util.CommandModel;
import oracle.javatools.util.CommandParser;
import oracle.javatools.util.FormatBundle;
import oracle.jdevimpl.deploy.boot.xml.BuildScript;
import oracle.jdevimpl.deploy.boot.xml.BuildScriptIO;
import oracle.jdevimpl.deploy.boot.xml.DefaultSection;
import oracle.jdevimpl.deploy.boot.xml.DeployTask;
import oracle.jdevimpl.deploy.boot.xml.NameValueList;
import oracle.jdevimpl.deploy.boot.xml.Parameter;
import oracle.jdevimpl.deploy.boot.xml.Variable;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXException;

public class DeployStarter
extends IdeStarter {
    private String[] arguments_;
    private FormatBundle bundle;
    private BuildScript buildScript_;
    private BuildScriptIO buildScriptIO_;
    private static final Object[][] options_ = new Object[][]{{"buildfile", URL.class}, {"buildfileschema", null}, {"profile", String.class}, {"workspace", String.class}, {"project", String.class}, {"outputfile", String.class}, {"quiet", null}, {"basedir", String.class}, {"nocompile", null}, {"clean", null}, {"nodatasources", null}, {"updatewebxmlejbrefs", null}, {"forcerewrite", null}, {"define", String.class}, {"statuslogfile", String.class}};
    private static final String PARAM_VARIABLES = "define";

    private void $init$() {
        this.bundle = new FormatBundle(DeployStarter.class);
        this.buildScript_ = null;
        this.buildScriptIO_ = null;
    }

    public void startIde(String command, String[] arguments, IdeCore core) {
        try {
            core.useInvokeLaterForAddinsLoadedEvenThoughHeadless();
            this.startIdeImpl(command, arguments, core);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.exit(1);
        }
    }

    private void startIdeImpl(String command, String[] arguments, IdeCore core) {
        this.arguments_ = arguments;
        if (this.arguments_.length == 0) {
            this.printUsage();
            this.exit(1);
        }
        CommandParser parser = this.createParser();
        CommandModel cmdModel = null;
        try {
            cmdModel = parser.parse(this.arguments_);
            this.doBasicChecks(cmdModel);
            this.createBuildScript(cmdModel);
        }
        catch (CommandException e) {
            this.printErrorAndExit(e.getMessage() + "\n");
        }
        IdeArgs ideArgs = core.getIdeArgs();
        ideArgs.setCreateUI(false);
        System.setProperty("oracle.deployment.commandline", "true");
        Ide.startup((IdeCore)core);
    }

    private CommandParser createParser() {
        CommandParser parser = new CommandParser();
        int i = 0;
        while (i < options_.length) {
            if (options_[i][1] != null) {
                parser.defineOption((String)options_[i][0], (Class)options_[i][1]);
            } else {
                parser.defineOption((String)options_[i][0]);
            }
            ++i;
        }
        parser.defineSynonym("workspace", "application");
        parser.defineRequirement(new String[]{"buildfileschema", "buildfile", "workspace"});
        parser.defineRequirementPresent("workspace", "profile");
        parser.defineRequirementAbsent("buildfile", "workspace");
        parser.defineRequirementAbsent("nocompile", "clean");
        return parser;
    }

    public String[] getArguments() {
        return this.arguments_;
    }

    private void printUsage() {
        this.printCopyright();
        System.out.println(this.bundle.get("deploy.usage.message"));
    }

    private void printCopyright() {
        System.out.println(this.bundle.get("deploy.copyright.message", new Object[]{Version.NAME_SHORT, Version.VER, Version.BUILD_NUM}));
        System.out.println();
    }

    private void doBasicChecks(CommandModel cmdModel) {
        block3: {
            String path;
            if (cmdModel.isPresent("buildfileschema")) {
                this.printBuildFileSchema();
                this.exit(1);
            }
            if ((path = (String)cmdModel.getValue("workspace")) != null) break block3;
            URL url = (URL)cmdModel.getValue("buildfile");
            if (url == null) {
                this.printUsage();
                this.exit(1);
            } else {
                this.ensureFileExists(url, "deploy.arguments.buildfilenotfound");
            }
        }
    }

    public BuildScript getBuildScript() {
        return this.buildScript_;
    }

    public void ensureFileExists(URL url, String message) {
        if (!URLFileSystem.exists((URL)url)) {
            this.printErrorAndExit(this.bundle.get(message, new Object[]{url.toExternalForm()}));
        }
    }

    public FormatBundle getBundle() {
        return this.bundle;
    }

    public void exit(int status) {
        System.exit(status);
    }

    public void printError(String string) {
        System.err.println(string);
    }

    public void printErrorAndExit(String string) {
        this.printError(string);
        this.exit(1);
    }

    private void printBuildFileSchema() {
        InputStream in = this.getClass().getResourceAsStream("ojdeploy-build.xsd");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        char[] c = new char[256];
        try {
            try {
                String s;
                while ((s = reader.readLine()) != null) {
                    System.out.println(s);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    private void createBuildScript(CommandModel cmdModel) {
        URL buildScriptUrl = (URL)cmdModel.getValue("buildfile");
        this.buildScriptIO_ = new BuildScriptIO();
        if (buildScriptUrl != null) {
            try {
                this.buildScript_ = this.buildScriptIO_.load(buildScriptUrl);
                DefaultSection ds = this.buildScript_.getDefaultSection();
                this.addCommandLineVariables(cmdModel, ds);
                this.addCommandLineParameters(cmdModel, ds);
            }
            catch (IOException e) {
                this.printErrorAndExit(this.bundle.get("deploy.build.readerror", new Object[]{e.getMessage()}));
            }
            catch (XMLParseException e) {
                this.printErrorAndExit(this.bundle.get("deploy.build.xmlerror", new Object[]{e.getMessage()}));
            }
            catch (SAXException e) {
                this.printErrorAndExit(this.bundle.get("deploy.build.xmlerror", new Object[]{e.getMessage()}));
            }
        } else {
            this.buildScript_ = this.buildScriptIO_.create();
            DeployTask task = this.buildScript_.createDeployTask();
            this.addCommandLineVariables(cmdModel, task);
            this.addCommandLineParameters(cmdModel, task);
            this.buildScript_.getDeployTasks().add((Object)task);
        }
        try {
            if (cmdModel.isAbsent("quiet")) {
                System.out.println("----build file----");
                this.buildScriptIO_.save(System.out);
                System.out.println("------------------");
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void addCommandLineVariables(CommandModel cmdModel, NameValueList list) {
        String[] variables;
        String varParam = this.getVariableParamName();
        if (cmdModel.isAbsent(this.getVariableParamName())) {
            return;
        }
        String value = (String)cmdModel.getValue(varParam);
        if (value == null || value.trim().length() == 0) {
            return;
        }
        String[] stringArray = variables = value.split(",");
        int n = 0;
        while (n < stringArray.length) {
            String nameValuePair = stringArray[n];
            String[] nameValue = nameValuePair.split("=");
            if (nameValue.length < 2) {
                this.printErrorAndExit(this.bundle.get("deploy.buildfile.defineerror", new Object[]{nameValuePair}));
            }
            Variable v = list.createVariable();
            v.setName(nameValue[0]);
            v.setValue(nameValue[1]);
            list.getVariables().add((Object)v);
            ++n;
        }
    }

    private void addCommandLineParameters(CommandModel cmdModel, NameValueList list) {
        int i = 0;
        while (i < options_.length) {
            String optionName = (String)options_[i][0];
            if (!this.getVariableParamName().equals(optionName) && cmdModel.isPresent(optionName)) {
                Parameter p = null;
                for (Object o : list.getParameters()) {
                    Parameter parm = (Parameter)o;
                    if (!optionName.equals(parm.getName())) continue;
                    parm.setValue(null);
                    p = parm;
                    break;
                }
                if (p == null) {
                    p = list.createParameter();
                    p.setName(optionName);
                }
                if (options_[i][1] != null) {
                    Object o = cmdModel.getValue(optionName);
                    p.setValue(this.convertToString(o));
                }
                list.getParameters().add((Object)p);
            }
            ++i;
        }
    }

    private String convertToString(Object o) {
        if (o instanceof URL) {
            return ((URL)o).getPath();
        }
        return o.toString();
    }

    private String getVariableParamName() {
        return PARAM_VARIABLES;
    }

    public DeployStarter() {
        this.$init$();
    }
}

