/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import oracle.classloader.CodeSourceAccessor;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;

public class ClassPathAccessor
extends CodeSourceAccessor {
    private StringBuffer buffer;
    private boolean started;
    private final boolean prependInitialSeparator;

    ClassPathAccessor(StringBuffer buffer, boolean includeManifestSources) {
        super(includeManifestSources);
        char lastChar;
        this.buffer = buffer;
        boolean prependInitialSep = false;
        int length = buffer.length();
        if (length > 0 && (lastChar = buffer.charAt(length - 1)) != File.pathSeparatorChar) {
            prependInitialSep = true;
        }
        this.prependInitialSeparator = prependInitialSep;
    }

    public boolean visit(SharedCodeSource codeSource, PolicyClassLoader subscriber) {
        File sourceFile = codeSource.getFile();
        if (sourceFile != null) {
            if (this.started || this.prependInitialSeparator) {
                this.buffer.append(File.pathSeparatorChar);
            }
            this.started = true;
            this.buffer.append(sourceFile.getPath());
        }
        return true;
    }
}

