/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import oracle.classloader.EventDispatcher;
import oracle.classloader.LoaderReference;
import oracle.classloader.PolicyClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosedLoaderReference
extends WeakReference<PolicyClassLoader> {
    private static ReferenceQueue<PolicyClassLoader> QUEUE = new ReferenceQueue();
    private String name;
    private String identity;
    private StackTraceElement[] creationStack;

    public ClosedLoaderReference(PolicyClassLoader loader) {
        super(loader, QUEUE);
        this.name = loader.getUniqueName();
        this.identity = loader.getIdentityHashCode();
        this.creationStack = loader.getCreationStack();
    }

    public static ClosedLoaderReference poll() {
        LoaderReference.lockAndExpungeStaleReferences();
        ClosedLoaderReference result = (ClosedLoaderReference)QUEUE.poll();
        if (result != null) {
            EventDispatcher.loaderCollected(result.name, result.identity);
        }
        return result;
    }

    public boolean wasCleared() {
        return this.get() == null;
    }

    public String getName() {
        return this.name;
    }

    public StackTraceElement[] getCreationStack() {
        return this.creationStack;
    }

    public String toString() {
        return this.name + " (ID #" + this.identity + ")";
    }
}

