/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceList;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;

public abstract class CodeSourceSearchPolicy {
    public static final CodeSourceSearchPolicy DEFAULT = ClassLoadEnvironment.getDefaultCodeSourceSearchPolicy();

    public RecoverableByteBuffer findResourceBytes(String resourcePath, SharedCodeSourceList codeSources, RecoverableByteBuffer buffer) {
        String packagePath = CodeSourceSearchPolicy.packagePath(resourcePath);
        SharedCodeSourceList.Entry entry = this.firstEntry(resourcePath, packagePath, codeSources);
        while (entry != null) {
            block4: {
                SharedCodeSource source = entry.getSource();
                try {
                    RecoverableByteBuffer buf = source.getResourceBytes(resourcePath, buffer);
                    if (buf != null) {
                        buf.setCodeSource(source);
                        buf.setProtectionPolicy(entry.getProtection());
                        return buf;
                    }
                }
                catch (IOException e) {
                    if (source.didRethrowOpenFailure()) break block4;
                    ClassLoadLogger.logException("Unable to access code-source: " + source + ".", e, false);
                }
            }
            entry = this.nextEntry(resourcePath, packagePath, entry);
        }
        return null;
    }

    public URL findResourceURL(String resourcePath, SharedCodeSourceList codeSources) {
        String packagePath = CodeSourceSearchPolicy.packagePath(resourcePath);
        SharedCodeSourceList.Entry entry = this.firstEntry(resourcePath, packagePath, codeSources);
        while (entry != null) {
            block4: {
                SharedCodeSource source = entry.getSource();
                try {
                    URL result = source.getResource(resourcePath);
                    if (result != null) {
                        return result;
                    }
                }
                catch (IOException e) {
                    if (source.didRethrowOpenFailure()) break block4;
                    ClassLoadLogger.logException("Unable to access code-source: " + source + ".", e, false);
                }
            }
            entry = this.nextEntry(resourcePath, packagePath, entry);
        }
        return null;
    }

    public void findAllResourceURLs(String resourcePath, SharedCodeSourceList codeSources, List list) {
        String packagePath = CodeSourceSearchPolicy.packagePath(resourcePath);
        SharedCodeSourceList.Entry entry = this.firstEntry(resourcePath, packagePath, codeSources);
        while (entry != null) {
            block4: {
                SharedCodeSource source = entry.getSource();
                try {
                    URL res = source.getResource(resourcePath);
                    if (res != null) {
                        list.add(res);
                    }
                }
                catch (IOException e) {
                    if (source.didRethrowOpenFailure()) break block4;
                    ClassLoadLogger.logException("Could not check for resources in: " + source + ".", e, false);
                }
            }
            entry = this.nextEntry(resourcePath, packagePath, entry);
        }
    }

    private static String packagePath(String resourcePath) {
        if (resourcePath.contains("..")) {
            return null;
        }
        int lastIndex = resourcePath.lastIndexOf(47);
        if (lastIndex >= 0) {
            return resourcePath.substring(0, lastIndex);
        }
        return null;
    }

    protected abstract SharedCodeSourceList.Index createIndex();

    protected abstract SharedCodeSourceList.Entry firstEntry(String var1, String var2, SharedCodeSourceList var3);

    protected abstract SharedCodeSourceList.Entry nextEntry(String var1, String var2, SharedCodeSourceList.Entry var3);

    public static abstract class Index
    extends CodeSourceSearchPolicy {
        protected abstract SharedCodeSourceList.Index createIndex();

        protected SharedCodeSourceList.Entry firstEntry(String resourcePath, String packagePath, SharedCodeSourceList list) {
            SharedCodeSourceList.Index index = list.getIndex();
            if (index != null && packagePath != null) {
                return index.find(packagePath);
            }
            return list.getFirst();
        }

        protected SharedCodeSourceList.Entry nextEntry(String resourcePath, String packagePath, SharedCodeSourceList.Entry current) {
            return current.getNext(true);
        }
    }

    public static class RuntimeIndex2
    extends Index {
        protected SharedCodeSourceList.Index createIndex() {
            return new SharedCodeSourceList.RuntimeIndex2();
        }
    }

    public static class RuntimeIndex1
    extends Index {
        protected SharedCodeSourceList.Index createIndex() {
            return new SharedCodeSourceList.RuntimeIndex1();
        }
    }

    public static class Linear
    extends CodeSourceSearchPolicy {
        public SharedCodeSourceList.Index createIndex() {
            return null;
        }

        protected SharedCodeSourceList.Entry firstEntry(String resourcePath, String packagePath, SharedCodeSourceList list) {
            return list.getFirst();
        }

        protected SharedCodeSourceList.Entry nextEntry(String resourcePath, String packagePath, SharedCodeSourceList.Entry current) {
            return current.getNext(true);
        }
    }
}

