/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.net.URL;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.ConfigurationType;

public class ConfigurationOrigin {
    public static final String TEST_PREFIX = "test.";
    private ConfigurationType type;
    private String origin;
    private String protectionName;

    public ConfigurationOrigin(ConfigurationType type, String origin, String protectionName) {
        this.type = type;
        this.origin = origin;
        this.protectionName = protectionName;
    }

    public ConfigurationOrigin(ConfigurationType type, String origin) {
        this.type = type;
        this.origin = origin;
        this.protectionName = null;
    }

    public ConfigurationOrigin createManifestOrigin(URL location) {
        return new ConfigurationOrigin(this.type.getManifestType(), location.getPath());
    }

    public ConfigurationType getType() {
        return this.type;
    }

    public ClassLoaderScope getScope() {
        return this.type.getScope();
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getProtectionName() {
        return this.protectionName;
    }

    public boolean isTest() {
        return this.origin.startsWith(TEST_PREFIX);
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.origin.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        try {
            ConfigurationOrigin other = (ConfigurationOrigin)obj;
            return this.type == other.type && this.origin.equals(other.origin);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        String relation = this.type.getRelationToContext();
        if (relation == null || relation.length() == 0) {
            return this.type.getName() + " " + this.origin;
        }
        return this.type.getName() + " " + relation + " " + this.origin;
    }

    public int getMaxToStringLength() {
        return this.type.getName().length() + this.type.getRelationToContext().length() + 4 + this.origin.length();
    }
}

