/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadAsserts;
import oracle.classloader.util.VersionNumber;

public class ExtensionDeclaration {
    private String specTitle;
    private String name;
    private VersionNumber specVersion;
    private String specVendor;
    private VersionNumber implVersion;
    private String implVendor;
    private String implVendorID;
    private String implURL;
    private SharedCodeSource source;
    private static HashMap declarations;

    public static ExtensionDeclaration getDeclaration(SharedCodeSource source, Attributes attributes) {
        String name;
        ExtensionDeclaration result = null;
        if (attributes != null && (name = attributes.getValue(Attributes.Name.EXTENSION_NAME)) != null) {
            result = new ExtensionDeclaration(source, attributes);
        }
        return result;
    }

    public static synchronized Map getDeclarations() {
        HashMap result = new HashMap();
        for (Map.Entry e : declarations.entrySet()) {
            Object key = e.getKey();
            Object[] value = (ExtensionDeclaration[])e.getValue();
            value = (ExtensionDeclaration[])ArrayUtils.copyAndCompress(value, value.length);
            result.put(key, value);
        }
        return result;
    }

    private static synchronized void register(ExtensionDeclaration extension) {
        String name = extension.getExtensionName();
        Object[] array = null;
        if (declarations == null) {
            declarations = new HashMap();
        } else {
            array = (ExtensionDeclaration[])declarations.get(name);
        }
        if (array == null) {
            array = new ExtensionDeclaration[4];
        }
        Object[] value = ArrayUtils.insertSparse(ExtensionDeclaration.class, array, extension);
        declarations.put(name, value);
    }

    protected static synchronized ExtensionDeclaration[] find(String extensionName) {
        return (ExtensionDeclaration[])declarations.get(extensionName);
    }

    private static synchronized void unregister(ExtensionDeclaration extension) {
        String name;
        Object[] array;
        if (declarations != null && (array = (Object[])declarations.get(name = extension.getExtensionName())) != null) {
            ArrayUtils.removeSparse(array, extension);
            if (ArrayUtils.indexOfFirstValid(array, array.length) == -1) {
                declarations.remove(name);
            }
        }
    }

    private ExtensionDeclaration(SharedCodeSource source, Attributes attrs) {
        this.source = source;
        this.name = attrs.getValue(Attributes.Name.EXTENSION_NAME);
        if (this.name == null) {
            throw new IllegalStateException("Extension-Name does not exist!");
        }
        this.specTitle = attrs.getValue(Attributes.Name.SPECIFICATION_TITLE);
        this.specVersion = this.getVersion(attrs.getValue(Attributes.Name.SPECIFICATION_VERSION));
        this.specVendor = attrs.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        this.implVersion = this.getVersion(attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
        this.implVendor = attrs.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        this.implVendorID = attrs.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
        this.implURL = attrs.getValue(Attributes.Name.IMPLEMENTATION_URL);
        ExtensionDeclaration.register(this);
    }

    protected ExtensionDeclaration(SharedCodeSource source, String extensionName, Attributes attrs) {
        this.source = source;
        String s = extensionName + "-";
        String attrKey = s + Attributes.Name.EXTENSION_NAME.toString();
        this.name = attrs.getValue(attrKey);
        if (this.name == null) {
            ClassLoadAsserts.fail("extension.name.missing", extensionName, source);
        }
        attrKey = s + Attributes.Name.SPECIFICATION_TITLE.toString();
        this.specTitle = attrs.getValue(attrKey);
        attrKey = s + Attributes.Name.SPECIFICATION_VERSION.toString();
        this.specVersion = this.getVersion(attrs.getValue(attrKey));
        attrKey = s + Attributes.Name.SPECIFICATION_VENDOR.toString();
        this.specVendor = attrs.getValue(attrKey);
        attrKey = s + Attributes.Name.IMPLEMENTATION_VERSION.toString();
        this.implVersion = this.getVersion(attrs.getValue(attrKey));
        attrKey = s + Attributes.Name.IMPLEMENTATION_VENDOR.toString();
        this.implVendor = attrs.getValue(attrKey);
        attrKey = s + Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString();
        this.implVendorID = attrs.getValue(attrKey);
        attrKey = s + Attributes.Name.IMPLEMENTATION_URL.toString();
        this.implURL = attrs.getValue(attrKey);
    }

    private VersionNumber getVersion(String versionString) {
        if (versionString == null) {
            return null;
        }
        return new VersionNumber(versionString, false, false);
    }

    void destroy() {
        ExtensionDeclaration.unregister(this);
    }

    public String getExtensionName() {
        return this.name;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public VersionNumber getSpecificationVersion() {
        return this.specVersion;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public VersionNumber getImplementationVersion() {
        return this.implVersion;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public String getImplementationVendorID() {
        return this.implVendorID;
    }

    public String getImplementationURL() {
        return this.implURL;
    }

    public SharedCodeSource getCodeSource() {
        return this.source;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeCodeSource) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append("(");
        boolean started = this.appendValue("spec-title: ", this.specTitle, false, buffer);
        started = this.appendValue("spec-version: ", this.specVersion, started, buffer);
        started = this.appendValue("impl-version: ", this.implVersion, started, buffer);
        started = this.appendValue("impl-vendor: ", this.implVendor, started, buffer);
        started = this.appendValue("impl-vendor ID: ", this.implVendorID, started, buffer);
        if (includeCodeSource) {
            this.appendValue("code-source: ", this.source, started, buffer);
        }
        buffer.append(")");
        return buffer.toString();
    }

    private boolean appendValue(String key, Object value, boolean started, StringBuffer buffer) {
        if (value != null) {
            if (started) {
                buffer.append(", ");
            }
            buffer.append(key);
            buffer.append(value.toString());
            return true;
        }
        return started;
    }
}

