/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchMetrics;
import oracle.classloader.SearchPolicy;

public class FilteredAskParentSearchPolicy
extends SearchPolicy {
    private Class[] excludedClasses;

    public FilteredAskParentSearchPolicy(Class[] excludedClasses) {
        super("filteredAskParent");
        this.excludedClasses = excludedClasses;
    }

    protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        Class result = loader.askParentForClass(className, metrics, false);
        if (result != null) {
            for (int i = 0; i < this.excludedClasses.length; ++i) {
                if (result != this.excludedClasses[i]) continue;
                return null;
            }
        }
        return result;
    }

    public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        return loader.askParentForResource(resourceName, metrics, false);
    }

    public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) throws IOException {
        loader.askParentForAllResources(resourceName, resources, metrics, false);
    }

    public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
        PolicyClassLoader parent;
        if (visitNonSharedParents && (parent = loader.parent()) != null) {
            return parent.visitUsingPolicy(visitor, visitNonSharedParents, true);
        }
        return true;
    }
}

