/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchMetrics;
import oracle.classloader.SearchPolicy;

public class JVMSearchPolicy
extends SearchPolicy {
    public static final String NAME = "JVM-Native";

    public JVMSearchPolicy() {
        super(NAME);
    }

    protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        try {
            return loader.findJREClass(className, metrics);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        return loader.findJREResource(resourceName, metrics);
    }

    public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) throws IOException {
        loader.findJREResources(resourceName, resources, metrics);
    }

    public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
        return visitor.visit(loader);
    }
}

