/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.CodeSourceSearchPolicy;
import oracle.classloader.CodeSourceVisitor;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.EventDispatcher;
import oracle.classloader.LoaderReference;
import oracle.classloader.MBean;
import oracle.classloader.MBeanTarget;
import oracle.classloader.PolicyClassLoaderSet;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SearchMetrics;
import oracle.classloader.SearchPolicy;
import oracle.classloader.Sharable;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceList;
import oracle.classloader.SharedCodeSourceSet;
import oracle.classloader.SubscriberSet;
import oracle.classloader.util.AnnotatedClassFormatError;
import oracle.classloader.util.AnnotatedClassNotFoundException;
import oracle.classloader.util.AnnotatedLinkageError;
import oracle.classloader.util.AnnotatedNoClassDefFoundError;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadAsserts;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ClassPreprocessor;
import oracle.classloader.util.ClassPreprocessorFactory;
import oracle.classloader.util.ExecutionStack;
import oracle.classloader.util.FileUtils;
import oracle.classloader.util.InitialLoadersFactory;
import oracle.classloader.util.InvalidClass;
import oracle.classloader.util.MissingClass;
import oracle.classloader.util.VersionNumber;

public class PolicyClassLoader
extends SecureClassLoader
implements Sharable,
MBeanTarget {
    public static final char UNIQUE_NAME_SEPARATOR = ':';
    private static final String OS_ARCH = ClassLoadEnvironment.getProperty("os.arch");
    private static final boolean VERBOSE_TOSTRING = ClassLoadEnvironment.getVerboseLoaderToString();
    private PolicyClassLoader parent;
    private int childCount;
    private LoaderReference[] children;
    private Object childLock = new Object();
    private SharedCodeSourceList codeSources;
    private volatile boolean closed;
    private int nativeCodeSourcesCount;
    private SharedCodeSource[] nativeCodeSources;
    private int importedLoadersCount;
    private PolicyClassLoader[] importedLoaders;
    private SubscriberSet subscribers;
    private boolean committed;
    private String name;
    private String uniqueName;
    private String identityHashCode;
    private VersionNumber version;
    private ConfigurationOrigin origin;
    private SearchPolicy searchPolicy;
    private ConfigurationPolicy configPolicy;
    private StackTraceElement[] creationStack;
    private RecoverableByteBuffer buffer;
    private ClassPreprocessor preprocessor;
    private int searchDepth;
    private ProtectionPolicy protectionPolicy;
    private MBean mBean;
    private SearchMetrics metrics;
    private SearchMetrics recursionMetrics;
    private final HashMap<CodeSource, ProtectionDomain> pdcache = new HashMap(11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getProtectionDomain(CodeSource cs, PermissionCollection perms) {
        ProtectionDomain pd;
        if (cs == null) {
            return null;
        }
        HashMap<CodeSource, ProtectionDomain> hashMap = this.pdcache;
        synchronized (hashMap) {
            pd = this.pdcache.get(cs);
            if (pd == null) {
                pd = new ProtectionDomain(cs, perms == null ? this.getPermissions(cs) : perms, this, null);
                this.pdcache.put(cs, pd);
            }
        }
        return pd;
    }

    public PolicyClassLoader(ClassLoader jreSystemClassLoader) {
        this(InitialLoadersFactory.getSystemLoaderName(), InitialLoadersFactory.getSystemLoaderVersionNumber(), InitialLoadersFactory.createInitialLoaders(jreSystemClassLoader), InitialLoadersFactory.createSystemLoaderOrigin(), InitialLoadersFactory.createSystemLoaderConfigurationPolicy(), InitialLoadersFactory.createSystemLoaderSearchPolicy(), InitialLoadersFactory.createSystemLoaderProtectionPolicy());
    }

    public PolicyClassLoader(String name, ConfigurationOrigin origin, ConfigurationPolicy configurationPolicy) {
        this(name, VersionNumber.ZERO, ClassLoaderQuery.getSystemLoader(), origin, configurationPolicy, SearchPolicy.STANDARD, ProtectionPolicy.defaultFor(origin.getScope()));
    }

    public PolicyClassLoader(String name, ClassLoader parent, ConfigurationOrigin origin, ConfigurationPolicy configurationPolicy) {
        this(name, VersionNumber.ZERO, parent, origin, configurationPolicy, SearchPolicy.STANDARD, ProtectionPolicy.defaultFor(origin.getScope()));
    }

    public PolicyClassLoader(String name, ClassLoader parent, ConfigurationOrigin origin, ConfigurationPolicy configurationPolicy, ProtectionPolicy protectionPolicy) {
        this(name, VersionNumber.ZERO, parent, origin, configurationPolicy, SearchPolicy.STANDARD, protectionPolicy);
    }

    public PolicyClassLoader(String name, VersionNumber version, ClassLoader parent, ConfigurationOrigin origin, ConfigurationPolicy configurationPolicy) {
        this(name, version, parent, origin, configurationPolicy, SearchPolicy.STANDARD, ProtectionPolicy.defaultFor(origin.getScope()));
    }

    public PolicyClassLoader(String name, VersionNumber version, ClassLoader parent, ConfigurationOrigin origin, ConfigurationPolicy configurationPolicy, SearchPolicy searchPolicy) {
        this(name, version, parent, origin, configurationPolicy, searchPolicy, ProtectionPolicy.defaultFor(origin.getScope()));
    }

    public PolicyClassLoader(String name, VersionNumber version, ClassLoader parent, ConfigurationOrigin origin, ConfigurationPolicy configurationPolicy, SearchPolicy searchPolicy, ProtectionPolicy protectionPolicy) {
        super(parent);
        this.init(name, version, parent, origin, configurationPolicy, searchPolicy, protectionPolicy);
        configurationPolicy.configure(this, parent, this.parent, origin);
        EventDispatcher.loaderCreated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyClassLoader(PolicyClassLoader source, boolean closeSource, boolean commit) {
        super(source.getParent());
        PolicyClassLoader policyClassLoader = source;
        synchronized (policyClassLoader) {
            this.init(source.name, ClassLoaderQuery.next(source.version), source.getParent(), source.origin, source.configPolicy, source.searchPolicy, source.protectionPolicy);
            Class<PolicyClassLoaderSet> clazz = PolicyClassLoaderSet.class;
            synchronized (PolicyClassLoaderSet.class) {
                int i;
                ConfigurationOrigin origin;
                SharedCodeSource cs;
                PolicyClassLoaderSet.add(this);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                for (SharedCodeSourceList.Entry entry = source.codeSources.getFirst(); entry != null; entry = entry.getNext(true)) {
                    cs = entry.getSource();
                    origin = cs.getSubscribers().getFirstOriginFor(source);
                    ProtectionPolicy prot = entry.getProtection();
                    cs.addSubscriber(this, origin);
                    this.adoptCodeSource(cs, origin, prot);
                }
                for (i = 0; i < source.nativeCodeSourcesCount; ++i) {
                    cs = source.nativeCodeSources[i];
                    origin = cs.getSubscribers().getFirstOriginFor(source);
                    cs.addSubscriber(this, origin);
                    this.adoptNativeCodeSource(cs);
                }
                for (i = 0; i < source.importedLoadersCount; ++i) {
                    PolicyClassLoader loader = source.importedLoaders[i];
                    origin = loader.getSubscribers().getFirstOriginFor(source);
                    this.addImportedLoader(loader, origin);
                }
            }
        }
        {
            if (closeSource) {
                source.close();
            }
            if (commit) {
                this.commit();
            }
            EventDispatcher.loaderCreated(this);
            return;
        }
    }

    public PolicyClassLoader copy(boolean closeThis, boolean commitCopy) {
        return new PolicyClassLoader(this, closeThis, commitCopy);
    }

    private void init(String name, VersionNumber version, ClassLoader parent, ConfigurationOrigin origin, ConfigurationPolicy configurationPolicy, SearchPolicy searchPolicy, ProtectionPolicy protectionPolicy) {
        this.name = name;
        this.uniqueName = name + ':' + version.toString();
        this.identityHashCode = PolicyClassLoader.identityHashAsHexString(this);
        this.version = version;
        this.origin = origin;
        this.configPolicy = configurationPolicy;
        this.protectionPolicy = protectionPolicy;
        this.metrics = SearchMetrics.getInstance(this.uniqueName);
        this.parent = parent instanceof PolicyClassLoader ? (PolicyClassLoader)parent : null;
        this.codeSources = new SharedCodeSourceList(this);
        this.subscribers = new SubscriberSet(this, false);
        this.creationStack = new Error().getStackTrace();
        this.searchPolicy = ClassLoadEnvironment.filterSearchPolicy(searchPolicy, this);
    }

    public PolicyClassLoader parent() {
        return this.parent;
    }

    public synchronized SharedCodeSource[] getCodeSources(boolean includeManifestSources) {
        this.checkState(false);
        return this.codeSources.getCodeSources(includeManifestSources);
    }

    synchronized SharedCodeSource[] getCodeSourcesWhileAnalyzingFailure(boolean includeManifestSources) {
        if (this.isClosed()) {
            return new SharedCodeSource[0];
        }
        return this.codeSources.getCodeSources(includeManifestSources);
    }

    public synchronized boolean visitCodeSources(CodeSourceVisitor visitor, boolean includeManifestSources) {
        this.checkState(false);
        return this.codeSources.visitCodeSources(visitor, includeManifestSources);
    }

    public synchronized SharedCodeSource[] getNativeCodeSources() {
        this.checkState(false);
        return (SharedCodeSource[])ArrayUtils.copy(this.nativeCodeSources, this.nativeCodeSourcesCount);
    }

    public SubscriberSet getSubscribers() {
        return this.subscribers;
    }

    public String getDisplayName() {
        return this.getUniqueName();
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getIdentityHashCode() {
        return this.identityHashCode;
    }

    public String getName() {
        return this.name;
    }

    public VersionNumber getVersionNumber() {
        return this.version;
    }

    public boolean isSharedLoader() {
        return this.configPolicy.isShared();
    }

    public boolean isSystemLoader() {
        if (this.configPolicy.isShared()) {
            return this.configPolicy != ConfigurationPolicy.SHARED;
        }
        return !this.configPolicy.isApplicationScope();
    }

    public boolean isSystemSharedLoader() {
        return this.configPolicy.isShared() && (this.configPolicy == ConfigurationPolicy.SHARED_BOOT_PUBLIC || this.configPolicy == ConfigurationPolicy.SHARED_BOOT_PRIVATE);
    }

    public boolean isPrivateSystemSharedLoader() {
        return this.configPolicy == ConfigurationPolicy.SHARED_BOOT_PRIVATE;
    }

    public boolean isApplicationLoader() {
        return this.configPolicy.isApplicationScope();
    }

    public synchronized void commit() {
        if (!this.committed) {
            if (this.name != ClassLoadEnvironment.getRootLoaderName()) {
                this.codeSources.resolveExtensionDependencies();
            }
            this.configPolicy.loaderCommitting(this);
            this.committed = true;
            this.preprocessor = ClassPreprocessorFactory.create(this, this.getPreprocessor());
            EventDispatcher.loaderCommitted(this);
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void importLoader(PolicyClassLoader loader, ConfigurationOrigin origin) {
        this.assertValidImport(loader, origin);
        this.addImportedLoader(loader, origin);
    }

    public void setSearchPolicy(SearchPolicy policy, ConfigurationOrigin origin) {
        ClassLoadAsserts.assertFalse(this.committed, "loader.committed", this.uniqueName, origin, "set search policy");
        this.searchPolicy = policy;
    }

    public synchronized SharedCodeSource addCodeSource(String sourcePath, ConfigurationOrigin origin) throws IOException {
        this.configPolicy.assertAccepted(this.name, this.origin, origin);
        return this.adoptCodeSource(SharedCodeSourceSet.subscribe(sourcePath, origin, this), origin, null);
    }

    public synchronized SharedCodeSource addCodeSource(String sourcePath, ConfigurationOrigin origin, ProtectionPolicy protection) throws IOException {
        this.configPolicy.assertAccepted(this.name, this.origin, origin);
        return this.adoptCodeSource(SharedCodeSourceSet.subscribe(sourcePath, origin, this), origin, protection);
    }

    public synchronized SharedCodeSource addCodeSource(File sourceFile, ConfigurationOrigin origin) throws IOException {
        this.configPolicy.assertAccepted(this.name, this.origin, origin);
        return this.adoptCodeSource(SharedCodeSourceSet.subscribe(sourceFile, origin, this), origin, null);
    }

    public synchronized SharedCodeSource addCodeSource(File sourceFile, ConfigurationOrigin origin, ProtectionPolicy protection) throws IOException {
        this.configPolicy.assertAccepted(this.name, this.origin, origin);
        return this.adoptCodeSource(SharedCodeSourceSet.subscribe(sourceFile, origin, this), origin, protection);
    }

    public synchronized SharedCodeSource addCodeSource(URL codeLocation, ConfigurationOrigin origin) throws IOException {
        this.configPolicy.assertAccepted(this.name, this.origin, origin);
        return this.adoptCodeSource(SharedCodeSourceSet.subscribe(codeLocation, origin, this), origin, null);
    }

    public synchronized SharedCodeSource addCodeSource(URL codeLocation, ConfigurationOrigin origin, ProtectionPolicy protection) throws IOException {
        this.configPolicy.assertAccepted(this.name, this.origin, origin);
        return this.adoptCodeSource(SharedCodeSourceSet.subscribe(codeLocation, origin, this), origin, protection);
    }

    public SharedCodeSource addNativeCodeSource(String directoryPath, ConfigurationOrigin origin) throws IOException {
        this.configPolicy.assertAccepted(this.name, this.origin, origin);
        return this.adoptNativeCodeSource(SharedCodeSourceSet.subscribe(directoryPath, origin, this));
    }

    public synchronized SharedCodeSource addNativeCodeSource(File directory, ConfigurationOrigin origin) throws IOException {
        this.configPolicy.assertAccepted(this.name, this.origin, origin);
        return this.adoptNativeCodeSource(SharedCodeSourceSet.subscribe(directory, origin, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedCodeSource adoptCodeSource(SharedCodeSource source, ConfigurationOrigin origin, ProtectionPolicy protection) {
        if (source == SharedCodeSource.NON_EXISTENT || source == null) {
            return null;
        }
        if (this.committed) {
            SharedCodeSourceList.Entry start = this.codeSources.add(source, protection);
            try {
                this.committed = false;
                this.codeSources.resolveExtensionDependencies(start);
            }
            finally {
                this.committed = true;
            }
        } else {
            this.codeSources.add(source, protection);
        }
        return source;
    }

    private synchronized SharedCodeSource adoptNativeCodeSource(SharedCodeSource source) {
        if (source == SharedCodeSource.NON_EXISTENT || source == null) {
            return null;
        }
        if (ArrayUtils.contains(this.nativeCodeSources, this.nativeCodeSourcesCount, source)) {
            source = null;
        } else {
            this.nativeCodeSources = (SharedCodeSource[])ArrayUtils.append(SharedCodeSource.class, this.nativeCodeSources, this.nativeCodeSourcesCount++, source);
        }
        return source;
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close(boolean removeSelfFromParent) {
        if (this.codeSources != null) {
            if (this.isSharedLoader() && this.getSubscribers().getCount() != 0) {
                if (this.getSubscribers().containsApplicationSubscriber()) {
                    ClassLoadLogger.log(Level.WARNING, "close.shared.with.subscribers", this.getUniqueName(), this.getSubscribers());
                } else {
                    ClassLoadLogger.log(Level.WARNING, "close.shared.with.subscribers", this.getUniqueName(), this.getSubscribers());
                }
            }
            EventDispatcher.loaderClosing(this);
            if (this.mBean != null) {
                this.mBean.unregister(this);
            }
            Object object = this.childLock;
            synchronized (object) {
                if (this.childCount > 0) {
                    for (int i = 0; i < this.childCount; ++i) {
                        PolicyClassLoader child;
                        LoaderReference ref = this.children[i];
                        if (ref == null || (child = ref.getLoader()) == null) continue;
                        child.close(false);
                    }
                }
            }
            LoaderReference.lockAndExpungeStaleReferences();
            this.codeSources.unsubscribe();
            if (this.nativeCodeSourcesCount > 0) {
                for (int i = 0; i < this.nativeCodeSourcesCount; ++i) {
                    this.nativeCodeSources[i].unsubscribe(this);
                }
            }
            if (this.importedLoadersCount > 0) {
                for (int i = 0; i < this.importedLoadersCount; ++i) {
                    PolicyClassLoader loader = this.importedLoaders[i];
                    loader.getSubscribers().removeSubscriber(this);
                }
            }
            this.searchPolicy.close();
            this.parent = null;
            this.buffer = null;
            this.codeSources = null;
            this.importedLoadersCount = 0;
            this.importedLoaders = null;
            this.children = null;
            this.childCount = 0;
            this.closed = true;
            PolicyClassLoaderSet.remove(this, removeSelfFromParent);
            LoaderReference.expungeStaleReferences();
            EventDispatcher.loaderDestroyed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Class findJREClass(String className, SearchMetrics metrics) throws ClassNotFoundException {
        if (SearchMetrics.enabled()) {
            boolean endLocal = true;
            try {
                this.metrics.beginSearch(1, className);
                Class<?> result = super.loadClass(className, false);
                this.metrics.endSearch(this.metrics, 1, 9);
                this.metrics.endSearch(metrics, 0, 1);
                endLocal = false;
                Class<?> clazz = result;
                return clazz;
            }
            finally {
                if (endLocal) {
                    this.metrics.endSearch(this.metrics, 1, 9);
                }
            }
        }
        return super.loadClass(className, false);
    }

    final URL findJREResource(String resourcePath, SearchMetrics metrics) {
        URL result = super.getResource(resourcePath);
        if (result != null) {
            this.metrics.endSearch(metrics, 0, 7);
        }
        return result;
    }

    final void findJREResources(String resourcePath, List resources, SearchMetrics metrics) throws IOException {
        Enumeration<URL> e = super.getResources(resourcePath);
        while (e.hasMoreElements()) {
            resources.add(e.nextElement());
        }
    }

    final Class findCachedClass(String className, SearchMetrics metrics, boolean fromChild) {
        ClassLoader definingLoader;
        this.metrics.beginSearch(1, className);
        Class<?> result = this.findLoadedClass(className);
        if (result != null && fromChild && this.importedLoaders != null && (definingLoader = result.getClassLoader()) != null && definingLoader != this) {
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (definingLoader != parent) continue;
                this.metrics.endSearch(this.metrics, 1, 10);
                this.metrics.endSearch(metrics, 0, 2);
                return result;
            }
            return null;
        }
        this.metrics.endSearch(this.metrics, 1, 10);
        if (result != null) {
            this.metrics.endSearch(metrics, 0, 2);
        }
        return result;
    }

    final int getImportedLoadersCount() {
        return this.importedLoadersCount;
    }

    final PolicyClassLoader[] getImportedLoaders() {
        return this.importedLoaders;
    }

    final Class askParentForClass(String className, SearchMetrics metrics, boolean sharedOnly) {
        if (this.parent != null) {
            return this.parent.getSearchPolicy().loadClass(className, this.parent, metrics, true);
        }
        try {
            return this.findJREClass(className, metrics);
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
    }

    final URL askParentForResource(String resourcePath, SearchMetrics metrics, boolean sharedOnly) {
        if (this.parent != null) {
            if (!sharedOnly || this.parent.isSharedLoader()) {
                return this.parent.getResourceUsingPolicy(resourcePath, metrics, true);
            }
        } else if (!sharedOnly) {
            return this.findJREResource(resourcePath, metrics);
        }
        return null;
    }

    final void askParentForAllResources(String resourcePath, List resources, SearchMetrics metrics, boolean sharedOnly) throws IOException {
        if (this.parent != null) {
            this.parent.addResourcesUsingPolicy(resourcePath, resources, metrics, true);
        } else {
            this.findJREResources(resourcePath, resources, metrics);
        }
    }

    final boolean visitUsingPolicy(ClassLoaderVisitor visitor, boolean visitNonSharedParents, boolean fromChild) {
        return this.searchPolicy.visit(visitor, this, visitNonSharedParents, fromChild);
    }

    final URL getResourceUsingPolicy(String resourcePath, SearchMetrics metrics, boolean fromChild) {
        return this.searchPolicy.findResource(resourcePath, this, metrics, fromChild);
    }

    final void addResourcesUsingPolicy(String resourcePath, List resources, SearchMetrics metrics, boolean fromChild) throws IOException {
        this.searchPolicy.addAllResources(resourcePath, resources, this, metrics, fromChild);
    }

    final Class findLocalClass(CodeSourceSearchPolicy policy, String className, SearchMetrics metrics) {
        if (this.codeSources == null) {
            if (!this.isSharedLoader()) {
                ClassLoadAsserts.fail("loader.closed", this.uniqueName, this.origin);
            }
        } else {
            this.metrics.beginSearch(1, className);
            String path = className.replace('.', '/').concat(".class");
            RecoverableByteBuffer buf = policy.findResourceBytes(path, this.codeSources, this.buffer);
            if (buf != null) {
                this.buffer = buf;
                SharedCodeSource source = buf.getCodeSource();
                ProtectionPolicy protection = this.configPolicy.getProtection(this, source, buf.getProtectionPolicy());
                Certificate[] certificates = buf.getCertificates();
                this.metrics.endSearch(this.metrics, 1, 11);
                return this.defineClass(className, buf.getArray(), 0, buf.getBytesUsed(), source, protection, certificates, metrics);
            }
            this.metrics.endSearch(this.metrics, 1, 11);
        }
        return null;
    }

    final synchronized URL findLocalResource(CodeSourceSearchPolicy policy, String resourcePath, SearchMetrics metrics) {
        if (this.codeSources == null) {
            if (!this.isSharedLoader()) {
                ClassLoadAsserts.fail("loader.closed", this.uniqueName, this.origin);
            }
            return null;
        }
        return policy.findResourceURL(resourcePath, this.codeSources);
    }

    final synchronized void addAllLocalResources(CodeSourceSearchPolicy policy, String resourcePath, List resources, SearchMetrics metrics) {
        if (this.codeSources == null) {
            if (!this.isSharedLoader()) {
                ClassLoadAsserts.fail("loader.closed", this.uniqueName, this.origin);
            }
        } else {
            policy.findAllResourceURLs(resourcePath, this.codeSources, resources);
        }
    }

    public final synchronized void bulkLoadClasses(String[] classNames, SharedCodeSource source, Map registry) throws Exception {
        if (source != null && !source.getSubscribers().containsSubscriber(this)) {
            ClassLoadAsserts.fail("code.source.not.subscribed", this.uniqueName, source);
        }
        ProtectionPolicy protection = this.configPolicy.getProtection(this, source, null);
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            this.metrics.beginSearch(0, className);
            Class clz = this.findLoadedClass(className);
            if (clz == null) {
                String classPath = className.replace('.', '/') + ".class";
                RecoverableByteBuffer buf = null;
                buf = source == null ? CodeSourceSearchPolicy.DEFAULT.findResourceBytes(classPath, this.codeSources, this.buffer) : source.getResourceBytes(classPath, this.buffer);
                if (buf != null) {
                    this.buffer = buf;
                    Certificate[] certificates = buf.getCertificates();
                    SharedCodeSource cs = source == null ? buf.getCodeSource() : source;
                    clz = this.defineClass(className, buf.getArray(), 0, buf.getBytesUsed(), cs, protection, certificates, this.metrics);
                } else {
                    String loc = source != null ? source.toString() : this.getUniqueName();
                    ClassLoadLogger.log(Level.WARNING, "Bulk-load class '" + className + "' not found in " + loc);
                }
            } else {
                this.metrics.endSearch(this.metrics, 0, 2);
            }
            if (registry == null) continue;
            registry.put(className, clz);
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return this.internalLoadClass(className, resolve);
        }
        try {
            return (Class)AccessController.doPrivileged(new LoadClassAction(this, className, resolve));
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            if (cause instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Internal Error", cause);
        }
    }

    private synchronized Class internalLoadClass(String className, boolean resolve) throws ClassNotFoundException {
        this.checkState(true);
        if (this.searchDepth > 0) {
            this.metrics.endSearchIfRequired(this.recursionMetrics, 13, 0);
        }
        this.metrics.beginSearch(0, className);
        Class result = this.searchPolicy.getClass(className, this, this.metrics, false);
        if (result == null) {
            this.handleClassNotFound(className);
        }
        if (this.metrics.isActive(0)) {
            this.metrics.endSearch(this.metrics, 0, 3);
        }
        if (resolve) {
            this.resolveClass(result);
        }
        EventDispatcher.classFound(result, this);
        return result;
    }

    public synchronized URL getResource(String resourcePath) {
        URL result;
        this.checkState(true);
        final String finalPath = this.doInitialPreprocessingForResourcePath(resourcePath);
        if (finalPath == null) {
            return null;
        }
        this.metrics.beginSearch(0, finalPath);
        if (System.getSecurityManager() == null) {
            result = this.getResourceUsingPolicy(finalPath, this.metrics, false);
        } else {
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    return PolicyClassLoader.this.getResourceUsingPolicy(finalPath, PolicyClassLoader.this.metrics, false);
                }
            };
            result = (URL)AccessController.doPrivileged(action);
        }
        if (this.metrics.isActive(0)) {
            int searchResult = result == null ? 8 : 6;
            this.metrics.endSearch(this.metrics, 0, searchResult);
        }
        if (result == null) {
            EventDispatcher.resourceNotFound(resourcePath, this);
        } else {
            EventDispatcher.resourceFound(result, this);
        }
        return result;
    }

    public Enumeration getResources(String resourcePath) throws IOException {
        this.checkState(true);
        final String finalPath = this.doInitialPreprocessingForResourcePath(resourcePath);
        if (finalPath == null) {
            return null;
        }
        final ArrayList list = new ArrayList();
        this.metrics.beginSearch(0, finalPath);
        if (System.getSecurityManager() == null) {
            this.addResourcesUsingPolicy(finalPath, list, this.metrics, false);
        } else {
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    PolicyClassLoader.this.addResourcesUsingPolicy(finalPath, list, PolicyClassLoader.this.metrics, false);
                    return null;
                }
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException ex) {
                Exception cause = ex.getException();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException("Internal Error", cause);
            }
        }
        if (list.isEmpty()) {
            EventDispatcher.resourceNotFound(resourcePath, this);
            this.metrics.endSearch(this.metrics, 0, 8);
        } else {
            EventDispatcher.resourcesFound(list, this);
            this.metrics.endSearch(this.metrics, 0, 6);
        }
        return Collections.enumeration(list);
    }

    private String doInitialPreprocessingForResourcePath(String resourcePath) {
        if ((resourcePath = FileUtils.getCanonicalPath(resourcePath)) != null && resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if (resourcePath == null) {
            EventDispatcher.resourceNotFound(resourcePath, this);
        }
        return resourcePath;
    }

    public synchronized String findLibrary(String libraryName) {
        this.checkState(true);
        if (this == ClassLoaderQuery.getRootLoader()) {
            throw new IllegalStateException("findLibrary() called on " + this.getUniqueName());
        }
        if (this.nativeCodeSources != null) {
            File file = null;
            libraryName = System.mapLibraryName(libraryName);
            int count = this.nativeCodeSourcesCount;
            for (int i = 0; i < count; ++i) {
                try {
                    if (OS_ARCH != null && (file = this.nativeCodeSources[i].getFile(OS_ARCH + File.separatorChar + libraryName)) != null && file.exists()) {
                        return file.getAbsolutePath();
                    }
                    file = this.nativeCodeSources[i].getFile(libraryName);
                    if (file != null && file.exists()) {
                        return file.getAbsolutePath();
                    }
                    continue;
                }
                catch (IOException e) {
                    ClassLoadLogger.logException("Unable to access native library path: " + file + ".", e, false);
                }
            }
        }
        return null;
    }

    public String toString() {
        return this.toString(VERBOSE_TOSTRING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(boolean verbose) {
        if (this.codeSources != null) {
            if (verbose) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(this.uniqueName);
                buffer.append(" (instance ");
                buffer.append(this.identityHashCode);
                buffer.append(')');
                buffer.append(ClassLoadLogger.EOL);
                buffer.append("SearchPolicy:");
                buffer.append(ClassLoadLogger.EOL);
                buffer.append("    ");
                buffer.append(this.searchPolicy);
                buffer.append(ClassLoadLogger.EOL);
                buffer.append("Code-sources: ");
                buffer.append(ClassLoadLogger.EOL);
                int lineNumber = 1;
                PolicyClassLoader policyClassLoader = this;
                synchronized (policyClassLoader) {
                    for (SharedCodeSourceList.Entry entry = this.codeSources.getFirst(); entry != null; entry = entry.getNext(true)) {
                        PolicyClassLoader.appendLine(buffer, lineNumber++, entry.getSource().toString(this));
                    }
                    if (this.nativeCodeSourcesCount > 0) {
                        lineNumber = 1;
                        buffer.append(ClassLoadLogger.EOL);
                        buffer.append("Native code-sources: ");
                        buffer.append(ClassLoadLogger.EOL);
                        for (int i = 0; i < this.nativeCodeSourcesCount; ++i) {
                            PolicyClassLoader.appendLine(buffer, lineNumber++, this.nativeCodeSources[i].toString(this));
                        }
                    }
                    if (this.importedLoadersCount > 0) {
                        lineNumber = 1;
                        buffer.append(ClassLoadLogger.EOL);
                        buffer.append("Imported shared-libraries: ");
                        buffer.append(ClassLoadLogger.EOL);
                        for (int i = 0; i < this.importedLoadersCount; ++i) {
                            PolicyClassLoader.appendLine(buffer, lineNumber++, this.importedLoaders[i].getDisplayName());
                        }
                    }
                }
                return buffer.toString();
            }
            return this.uniqueName;
        }
        return this.uniqueName + "(CLOSED)";
    }

    private static void appendLine(StringBuffer buffer, int lineNumber, Object message) {
        if (lineNumber < 10) {
            buffer.append("    ");
        } else {
            buffer.append("   ");
        }
        buffer.append(lineNumber++);
        buffer.append(". ");
        buffer.append(message);
        buffer.append(ClassLoadLogger.EOL);
    }

    public void setMBean(MBean mBean) {
        this.mBean = mBean;
    }

    public MBean getMBean() {
        return this.mBean;
    }

    public void resetConfiguration(String name, VersionNumber version, ConfigurationPolicy configurationPolicy) {
        if (!InitialLoadersFactory.inConfig()) {
            throw new IllegalStateException();
        }
        this.name = name;
        this.uniqueName = name + ':' + version.toString();
        this.identityHashCode = PolicyClassLoader.identityHashAsHexString(this);
        this.version = version;
        this.configPolicy = configurationPolicy;
    }

    private static String identityHashAsHexString(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    synchronized boolean hasCodeSources() {
        return this.codeSources.getFirst() != null;
    }

    boolean hasNativeCodeSources() {
        return this.nativeCodeSourcesCount > 0;
    }

    public synchronized boolean isConfigured() {
        return this.codeSources.getFirst() != null || this.importedLoadersCount != 0 || this.nativeCodeSourcesCount != 0;
    }

    private void checkState(boolean commit) {
        if (this.codeSources == null) {
            ClassLoadAsserts.fail("loader.closed", this.uniqueName, this.origin);
        }
        if (commit && !this.committed && this.configPolicy.shouldAutoCommit()) {
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImportedLoader(PolicyClassLoader loader, ConfigurationOrigin origin) {
        if (loader.getSubscribers().addSubscriber(this, origin) != null) {
            PolicyClassLoader policyClassLoader = this;
            synchronized (policyClassLoader) {
                this.importedLoaders = (PolicyClassLoader[])ArrayUtils.append(PolicyClassLoader.class, this.importedLoaders, this.importedLoadersCount++, loader);
            }
        }
    }

    private void handleClassNotFound(String missingClassName) throws ClassNotFoundException {
        this.metrics.endSearch(this.metrics, 0, 4);
        if (this.searchDepth > 0) {
            EventDispatcher.classNotFound(missingClassName, this);
            throw new ClassNotFoundException(missingClassName);
        }
        if (!this.configPolicy.shouldAnnotateMissingClass(missingClassName)) {
            EventDispatcher.classNotFound(missingClassName, this);
            throw new ClassNotFoundException(missingClassName);
        }
        MissingClass missingClass = new MissingClass(missingClassName, this, new ExecutionStack());
        if (missingClass.mustThrowClassNotFound()) {
            EventDispatcher.classNotFound(missingClassName, this);
            throw new AnnotatedClassNotFoundException(missingClass);
        }
        if (ClassLoadEnvironment.canThrowNoClassDefFoundError()) {
            AnnotatedNoClassDefFoundError error = new AnnotatedNoClassDefFoundError(missingClass);
            EventDispatcher.classError(missingClassName, this, error);
            throw error;
        }
        missingClass.store();
        EventDispatcher.classNotFound(missingClassName, this);
        throw new ClassNotFoundException(missingClassName);
    }

    private void assertValidImport(PolicyClassLoader importCandidate, ConfigurationOrigin origin) {
        ClassLoadAsserts.assertTrue(importCandidate.isSharedLoader(), "loader.import.non.shared", this.uniqueName, origin, importCandidate.uniqueName);
        if (this.isSharedLoader()) {
            this.assertSelfNotReachableVia(importCandidate, origin, "loader.import.self", "");
        }
        if (!this.isSystemLoader()) {
            boolean isPublic = importCandidate.getConfigurationPolicy().isSharedPublic();
            ClassLoadAsserts.assertTrue(isPublic, "loader.import.private.shared", this.uniqueName, origin, importCandidate.uniqueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertSelfNotReachableVia(PolicyClassLoader candidate, ConfigurationOrigin origin, String failureKey, String sub2) {
        ClassLoadAsserts.assertFalse(this == candidate, failureKey, this.uniqueName, origin, sub2);
        PolicyClassLoader candidateParent = candidate.parent();
        if (candidateParent != null && candidateParent.isSharedLoader()) {
            this.assertSelfNotReachableVia(candidateParent, origin, "loader.import.self.via.parent", candidateParent.uniqueName);
        }
        PolicyClassLoader policyClassLoader = candidate;
        synchronized (policyClassLoader) {
            int count = candidate.importedLoadersCount;
            if (count > 0) {
                PolicyClassLoader[] imports = candidate.importedLoaders;
                for (int i = 0; i < count; ++i) {
                    this.assertSelfNotReachableVia(imports[i], origin, "loader.import.self.via.import", imports[i].uniqueName);
                }
            }
        }
    }

    protected Class defineClass(String className, byte[] data, int offset, int length, SharedCodeSource source, ProtectionPolicy protection, Certificate[] certificates, SearchMetrics metrics) {
        byte[] processedData;
        this.ensurePackageDefined(className, source);
        this.metrics.beginSearch(1, className);
        CodeSource cs = new CodeSource(source.getLocation(), certificates);
        ProtectionDomain pd = this.getProtectionDomain(cs, protection.getPermissions());
        boolean processed = false;
        if (this.preprocessor != null && (processedData = this.preprocessor.processClass(className, data, offset, length, pd, this)) != data) {
            data = processedData;
            offset = 0;
            length = data.length;
            processed = true;
        }
        try {
            ++this.searchDepth;
            this.recursionMetrics = metrics;
            EventDispatcher.classDefine(className, length - offset, this, source, processed);
            Class<?> result = this.defineClass(className, data, offset, length, pd);
            this.metrics.endSearchIfRequired(metrics, 13, 0);
            Class<?> clazz = result;
            return clazz;
        }
        catch (AnnotatedNoClassDefFoundError e) {
            throw e;
        }
        catch (AnnotatedLinkageError e) {
            throw e;
        }
        catch (NoClassDefFoundError e) {
            MissingClass missingClass = new MissingClass(e, className, this, source.getLocation().getPath(), ClassLoaderQuery.getFirstOriginDescription(source, this), null);
            AnnotatedNoClassDefFoundError error = new AnnotatedNoClassDefFoundError(missingClass);
            EventDispatcher.classError(className, this, error);
            throw error;
        }
        catch (LinkageError e) {
            this.metrics.endSearch(metrics, 0, 5);
            InvalidClass invalidClass = new InvalidClass(e, className, this.getUniqueName(), source.getLocation().getPath(), ClassLoaderQuery.getFirstOriginDescription(source, this), new ExecutionStack(1));
            LinkageError error = e instanceof ClassFormatError ? new AnnotatedClassFormatError(invalidClass, e) : new AnnotatedLinkageError(invalidClass, e);
            EventDispatcher.classError(className, this, error);
            throw error;
        }
        catch (RuntimeException e) {
            EventDispatcher.classError(className, this, e);
            throw e;
        }
        catch (Error e) {
            EventDispatcher.classError(className, this, e);
            throw e;
        }
        finally {
            --this.searchDepth;
        }
    }

    public Class defineClass(String className, URL source, Certificate[] certificates, ProtectionPolicy policy, byte[] data, int offset, int length) {
        CodeSource cs = new CodeSource(source, certificates);
        PermissionCollection permissions = policy.getPermissions();
        ProtectionDomain pd = this.getProtectionDomain(cs, permissions);
        return this.defineClass(className, pd, data, offset, length);
    }

    public Class defineClass(String className, ProtectionDomain protectionDomain, byte[] data, int offset, int length) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        return this.defineClass(className, data, offset, length, protectionDomain);
    }

    private void ensurePackageDefined(String className, SharedCodeSource source) {
        this.metrics.beginSearch(1, className);
        int lastDot = className.lastIndexOf(46);
        if (lastDot >= 0) {
            String packageName = className.substring(0, lastDot);
            Package pkg = this.getPackage(packageName);
            if (pkg != null) {
                source.assertSealedStateValid(pkg, packageName, this);
            } else {
                Manifest manifest = source.tryGetManifest();
                if (manifest != null) {
                    this.definePackage(packageName, manifest, source.getLocation());
                } else {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
            }
        }
        this.metrics.endSearch(this.metrics, 1, 12);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    public synchronized void recover(int currentMaintenanceTick, boolean force) {
        if (this.buffer != null) {
            this.buffer.recover(currentMaintenanceTick, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildReference(LoaderReference child) {
        Object object = this.childLock;
        synchronized (object) {
            this.children = (LoaderReference[])ArrayUtils.append(LoaderReference.class, this.children, this.childCount++, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChildReference(LoaderReference child) {
        Object object = this.childLock;
        synchronized (object) {
            this.childCount = ArrayUtils.remove((Object[])this.children, this.childCount, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasChildren() {
        LoaderReference.lockAndExpungeStaleReferences();
        Object object = this.childLock;
        synchronized (object) {
            return this.childCount != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PolicyClassLoader[] getChildren() {
        this.checkState(true);
        LoaderReference.lockAndExpungeStaleReferences();
        Object object = this.childLock;
        synchronized (object) {
            PolicyClassLoader[] result = new PolicyClassLoader[this.childCount];
            for (int i = 0; i < this.childCount; ++i) {
                PolicyClassLoader child;
                result[i] = child = this.children[i].getLoader();
            }
            return result;
        }
    }

    public final synchronized PolicyClassLoader[] getImports() {
        if (this.importedLoadersCount > 0) {
            return (PolicyClassLoader[])ArrayUtils.copy(this.importedLoaders, this.importedLoadersCount);
        }
        return null;
    }

    public final ConfigurationOrigin getOrigin() {
        return this.origin;
    }

    public final StackTraceElement[] getCreationStack() {
        return this.creationStack;
    }

    public final SearchPolicy getSearchPolicy() {
        return this.searchPolicy;
    }

    public final ConfigurationPolicy getConfigurationPolicy() {
        return this.configPolicy;
    }

    public final ClassLoaderScope getScope() {
        return this.configPolicy.getScope();
    }

    public final synchronized int getBufferSize() {
        if (this.buffer != null) {
            return this.buffer.getArray().length;
        }
        return 0;
    }

    public final ClassPreprocessor getPreprocessor() {
        return this.preprocessor;
    }

    public final ProtectionPolicy getProtection() {
        return this.protectionPolicy;
    }

    public final Map getLoadedPackages() {
        return ClassLoaderQuery.getLoadedPackages(this);
    }

    public final List getLoadedClasses() {
        return ClassLoaderQuery.getLoadedClasses(this);
    }

    public final synchronized SearchMetrics getMetrics() {
        return this.metrics.copy();
    }

    public final synchronized void addMetrics(SearchMetrics accumulator) {
        accumulator.add(this.metrics);
    }

    public synchronized ClassPreprocessor setPreprocessor(ClassPreprocessor preprocessor) {
        ClassPreprocessor result = this.preprocessor;
        this.preprocessor = preprocessor;
        return result;
    }

    private static class LoadClassAction
    implements PrivilegedExceptionAction {
        private PolicyClassLoader loader;
        private String className;
        private boolean resolve;

        public LoadClassAction(PolicyClassLoader loader, String className, boolean resolve) {
            this.loader = loader;
            this.className = className;
            this.resolve = resolve;
        }

        public Object run() throws ClassNotFoundException {
            return this.loader.internalLoadClass(this.className, this.resolve);
        }
    }
}

