/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.Clock;

public abstract class SearchMetrics {
    public static final SearchMetrics NULL = new Null();
    private static final boolean ENABLED = ClassLoadEnvironment.enableMetrics();
    static final int GLOBAL_SCOPE = 0;
    static final int LOCAL_SCOPE = 1;
    private static final int SCOPE_COUNT = 2;
    public static final int GLOBAL_SCOPE_RESULTS = -1;
    public static final int CLASS_DEFINED_RESULT = 0;
    public static final int CLASS_FOUND_IN_VM_RESULT = 1;
    public static final int CLASS_FOUND_IN_CACHE_RESULT = 2;
    public static final int CLASS_FOUND_RESULT = 3;
    public static final int CLASS_NOT_FOUND_RESULT = 4;
    public static final int CLASS_LINKAGE_ERROR_RESULT = 5;
    public static final int RESOURCE_FOUND_RESULT = 6;
    public static final int RESOURCE_FOUND_IN_VM_RESULT = 7;
    public static final int RESOURCE_NOT_FOUND_RESULT = 8;
    public static final int GLOBAL_SCOPE_RESULT_COUNT = 9;
    public static final int FIND_JRE_CLASS_COMPLETED_RESULT = 9;
    public static final int FIND_CACHED_CLASS_COMPLETED_RESULT = 10;
    public static final int FIND_CLASS_COMPLETED_RESULT = 11;
    public static final int DEFINE_PACKAGE_COMPLETED_RESULT = 12;
    public static final int DEFINE_CLASS_COMPLETED_RESULT = 13;
    public static final int RESULT_COUNT = 14;
    private static final String[] RESULT_DESCRIPTIONS = new String[]{"Class defined", "Class found in JRE", "Class found in cache", "Class found", "Class not found", "Class linkage error", "Resource found", "Resource found in JRE", "Resource not found", "findJREClass()", "findCachedClass()", "findLocalClass()", "definePackage()", "defineClass()"};

    public static SearchMetrics getInstance(String name) {
        if (ENABLED) {
            return new Timing(name);
        }
        return NULL;
    }

    public static boolean enabled() {
        return ENABLED;
    }

    public static String getResultDescription(int resultType) {
        if (resultType == -1) {
            return "Search summary";
        }
        return RESULT_DESCRIPTIONS[resultType];
    }

    abstract void beginSearch(int var1, String var2);

    abstract void endSearch(SearchMetrics var1, int var2, int var3);

    abstract void endSearchIfRequired(SearchMetrics var1, int var2, int var3);

    abstract boolean isActive(int var1);

    public abstract Clock getClock();

    abstract long getStartTicks(int var1);

    public abstract int getCount(int var1);

    public abstract long getTotalTicks(int var1);

    public long getTotalMillis(int resultType) {
        return this.getClock().toMillis(this.getTotalTicks(resultType));
    }

    public abstract long getMaximumTicks(int var1);

    public long getMaximumMillis(int resultType) {
        return this.getClock().toMillis(this.getMaximumTicks(resultType));
    }

    public abstract SearchMetrics copy();

    public abstract void add(SearchMetrics var1);

    static class Timing
    extends SearchMetrics {
        private String name;
        private String[] target = new String[2];
        private long[] startTicks = new long[2];
        private int[] counts = new int[14];
        private long[] maxTicks = new long[14];
        private long[] totalTicks = new long[14];
        private static boolean VERBOSE = ClassLoadEnvironment.getVerboseMetrics();
        private static Clock clock = Clock.getInstance();

        Timing(String name) {
            this.name = name;
        }

        public Clock getClock() {
            return clock;
        }

        void beginSearch(int searchScope, String searchTarget) {
            this.startTicks[searchScope] = clock.getTicks();
            this.target[searchScope] = searchTarget;
            if (VERBOSE) {
                if (searchScope == 1) {
                    System.out.print("    ");
                }
                System.out.println("BEGIN " + this.target[searchScope] + " " + this.name);
            }
        }

        void endSearch(SearchMetrics begin, int searchScope, int resultType) {
            if (VERBOSE) {
                if (searchScope == 1) {
                    System.out.print("    ");
                }
                Timing startInstance = (Timing)begin;
                String target = startInstance.target[searchScope];
                String beginName = startInstance.name;
                String suffix = " (" + RESULT_DESCRIPTIONS[resultType] + ")";
                if (startInstance.startTicks[searchScope] == 0L) {
                    suffix = suffix + " <<<--- HERE!";
                }
                System.out.println("  END " + target + " " + beginName + " --> " + this.name + suffix);
            }
            long start = begin.getStartTicks(searchScope);
            long elapsed = clock.getTicks() - start;
            int n = resultType;
            this.counts[n] = this.counts[n] + 1;
            int n2 = resultType;
            this.totalTicks[n2] = this.totalTicks[n2] + elapsed;
            if (elapsed > this.maxTicks[resultType]) {
                this.maxTicks[resultType] = elapsed;
            }
        }

        void endSearchIfRequired(SearchMetrics globalBegin, int localResultType, int globalResultType) {
            if (VERBOSE && this.isActive(1) != globalBegin.isActive(0)) {
                String scope = "local";
                String inactiveTarget = this.target[1];
                if (globalBegin.isActive(0)) {
                    scope = "global";
                    inactiveTarget = ((Timing)globalBegin).target[0];
                }
                String error = "-->> Only one scope was active: " + scope + ". Inactive: " + inactiveTarget;
                System.out.println(error);
            }
            if (this.isActive(1)) {
                this.endSearch(this, 1, localResultType);
            }
            if (globalBegin.isActive(0)) {
                this.endSearch(globalBegin, 0, globalResultType);
            }
        }

        boolean isActive(int searchScope) {
            return this.startTicks[searchScope] != 0L;
        }

        long getStartTicks(int searchScope) {
            long result = this.startTicks[searchScope];
            if (result == 0L) {
                throw new InternalError("End without start! Target: " + this.target[searchScope] + ". Thread: " + Thread.currentThread() + ". Scope: " + searchScope);
            }
            this.startTicks[searchScope] = 0L;
            return result;
        }

        public int getCount(int resultType) {
            if (resultType == -1) {
                int result = 0;
                for (int i = 0; i < 9; ++i) {
                    result += this.counts[i];
                }
                return result;
            }
            return this.counts[resultType];
        }

        public long getTotalTicks(int resultType) {
            if (resultType == -1) {
                long result = 0L;
                for (int i = 0; i < 9; ++i) {
                    result += this.totalTicks[i];
                }
                return result;
            }
            return this.totalTicks[resultType];
        }

        public long getMaximumTicks(int resultType) {
            if (resultType == -1) {
                long result = 0L;
                for (int i = 0; i < 9; ++i) {
                    if (this.maxTicks[i] <= result) continue;
                    result = this.maxTicks[i];
                }
                return result;
            }
            return this.maxTicks[resultType];
        }

        public SearchMetrics copy() {
            Timing result = new Timing(this.name);
            for (int i = 0; i < 14; ++i) {
                result.counts[i] = this.counts[i];
                result.totalTicks[i] = this.totalTicks[i];
                result.maxTicks[i] = this.maxTicks[i];
            }
            return result;
        }

        public void add(SearchMetrics other) {
            for (int i = 0; i < 14; ++i) {
                int n = i;
                this.counts[n] = this.counts[n] + other.getCount(i);
                int n2 = i;
                this.totalTicks[n2] = this.totalTicks[n2] + other.getTotalTicks(i);
                long otherMax = other.getMaximumTicks(i);
                if (otherMax <= this.maxTicks[i]) continue;
                this.maxTicks[i] = otherMax;
            }
        }
    }

    static class Null
    extends SearchMetrics {
        Null() {
        }

        void beginSearch(int searchScope, String searchTarget) {
        }

        void endSearch(SearchMetrics begin, int searchScope, int resultType) {
        }

        void endSearchIfRequired(SearchMetrics globalBegin, int localResultType, int globalResultType) {
        }

        public Clock getClock() {
            return null;
        }

        long getStartTicks(int searchScope) {
            return 0L;
        }

        boolean isActive(int searchScope) {
            return false;
        }

        public int getCount(int resultType) {
            return 0;
        }

        public long getTotalTicks(int resultType) {
            return 0L;
        }

        public long getMaximumTicks(int resultType) {
            return 0L;
        }

        public SearchMetrics copy() {
            return this;
        }

        public void add(SearchMetrics other) {
        }
    }
}

