/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.CodeSourceSearchPolicy;
import oracle.classloader.EventDispatcher;
import oracle.classloader.MappedSearchPolicy;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchMetrics;
import oracle.classloader.SearchSequence;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.InitialLoadersFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SearchPolicy {
    public static final SearchPolicy FIND_LOADED_CLASS = new FindLoadedClass();
    public static final SearchPolicy ASK_PARENT = new AskParent();
    public static final SearchPolicy ASK_SHARED_PARENT = new AskSharedParent();
    public static final SearchPolicy ASK_PARENT_AND_SHARED = new AskParentAndShared();
    public static final SearchPolicy FIND_LOCAL = new FindLocal();
    public static final SearchPolicy WEB_FIND_LOCAL = new WebFindLocal();
    public static final SearchPolicy WEB_OVERRIDE_ONLY = new JavaxServletOnly();
    public static final SearchPolicy FIND_MAIN_CLASS = new FindMain();
    public static final SearchPolicy ASK_MAIN = new AskMain();
    public static final SearchPolicy TRUSTED_ASK_MAIN = new TrustedAskMain();
    private static final Class ASK_LOCAL = AskLocal.class;
    public static final SearchPolicy CHECK_SHARED_LIBRARIES = new CheckSharedLibraries();
    public static final SearchPolicy STANDARD = new SearchSequence("Standard", new SearchPolicy[]{FIND_LOADED_CLASS, ASK_PARENT, CHECK_SHARED_LIBRARIES, FIND_LOCAL});
    public static final SearchPolicy TRUSTED_STANDARD = new SearchSequence("Trusted-Standard", new SearchPolicy[]{FIND_LOADED_CLASS, ASK_PARENT, CHECK_SHARED_LIBRARIES, TRUSTED_ASK_MAIN, FIND_LOCAL});
    public static final SearchPolicy BOOTSTRAP = new SearchSequence("Standard-Bootstrap", new SearchPolicy[]{FIND_LOADED_CLASS, ASK_PARENT, CHECK_SHARED_LIBRARIES, FIND_LOCAL, FIND_MAIN_CLASS});
    public static final SearchPolicy STANDARD_NO_IMPORTS = new SearchSequence("Standard-No-Imports", new SearchPolicy[]{FIND_LOADED_CLASS, ASK_PARENT, FIND_LOCAL});
    public static final SearchPolicy LOCAL_FIRST = new SearchSequence("Local-First", new SearchPolicy[]{FIND_LOADED_CLASS, FIND_LOCAL, ASK_PARENT, CHECK_SHARED_LIBRARIES});
    public static final SearchPolicy WEB_LOCAL_FIRST = new SearchSequence("Web-Local-First", new SearchPolicy[]{FIND_LOADED_CLASS, WEB_FIND_LOCAL, ASK_PARENT, WEB_OVERRIDE_ONLY, CHECK_SHARED_LIBRARIES});
    public static final SearchPolicy LOCAL_ONLY = new SearchSequence("Local-Only", new SearchPolicy[]{FIND_LOADED_CLASS, FIND_LOCAL});
    public static final SearchPolicy WRAPPERS = new SearchSequence("Wrappers", new SearchPolicy[]{FIND_LOADED_CLASS, ASK_PARENT_AND_SHARED, ASK_MAIN, FIND_LOCAL});
    public static final SearchPolicy WRAPPERS_NO_MAIN = new SearchSequence("Wrappers-No-Main", new SearchPolicy[]{FIND_LOADED_CLASS, ASK_PARENT_AND_SHARED, FIND_LOCAL});
    private static final SearchPolicy IMPORTED_LOADERS = new SearchSequence("Imported-Loaders", new SearchPolicy[]{FIND_LOADED_CLASS, ASK_SHARED_PARENT, CHECK_SHARED_LIBRARIES, FIND_LOCAL});
    private static PolicyClassLoader mainLoader;
    private static Map<String, Class> externalClasses;
    private String name;

    public static SearchPolicy createExternalsSearchPolicy(Map<String, Class> classes) {
        externalClasses = Collections.unmodifiableMap(classes);
        return new MappedSearchPolicy(classes);
    }

    public static Map<String, Class> getExternalClasses() {
        return externalClasses;
    }

    protected SearchPolicy(String policyName) {
        this.name = policyName;
    }

    public static PolicyClassLoader getMainLoader() {
        if (mainLoader == null) {
            mainLoader = ClassLoaderQuery.findLatestLoader(ClassLoadEnvironment.getMainLoaderName());
        }
        return mainLoader;
    }

    public void close() {
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String[] getSearchStepNames() {
        return new String[]{this.name};
    }

    public SearchPolicy prepend(String policyName, SearchPolicy policy) {
        return new SearchSequence(policyName, new SearchPolicy[]{policy, this});
    }

    public SearchPolicy append(String policyName, SearchPolicy policy) {
        return new SearchSequence(policyName, new SearchPolicy[]{this, policy});
    }

    public SearchPolicy insert(String policyName, SearchPolicy policy, SearchPolicy position) {
        return new SearchSequence(policyName, new SearchPolicy[]{this, policy});
    }

    public boolean doesCheckImports() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        PolicyClassLoader policyClassLoader = loader;
        synchronized (policyClassLoader) {
            return this.getClass(className, loader, metrics, fromChild);
        }
    }

    protected abstract Class getClass(String var1, PolicyClassLoader var2, SearchMetrics var3, boolean var4);

    public abstract URL findResource(String var1, PolicyClassLoader var2, SearchMetrics var3, boolean var4);

    public abstract void addAllResources(String var1, List var2, PolicyClassLoader var3, SearchMetrics var4, boolean var5) throws IOException;

    public abstract boolean visit(ClassLoaderVisitor var1, PolicyClassLoader var2, boolean var3, boolean var4);

    public static class CheckSharedLibraries
    extends SearchPolicy {
        protected CheckSharedLibraries() {
            super("checkSharedLibraries");
        }

        public boolean doesCheckImports() {
            return true;
        }

        protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            int importCount;
            if (!fromChild && (importCount = loader.getImportedLoadersCount()) > 0) {
                PolicyClassLoader[] imports = loader.getImportedLoaders();
                for (int i = 0; i < importCount; ++i) {
                    Class result = IMPORTED_LOADERS.loadClass(className, imports[i], metrics, true);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }

        public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            int importCount;
            if (!fromChild && (importCount = loader.getImportedLoadersCount()) > 0) {
                PolicyClassLoader[] imports = loader.getImportedLoaders();
                for (int i = 0; i < importCount; ++i) {
                    URL result = IMPORTED_LOADERS.findResource(resourceName, imports[i], metrics, true);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }

        public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) throws IOException {
            int importCount;
            if (!fromChild && (importCount = loader.getImportedLoadersCount()) > 0) {
                PolicyClassLoader[] imports = loader.getImportedLoaders();
                for (int i = 0; i < importCount; ++i) {
                    IMPORTED_LOADERS.addAllResources(resourceName, resources, imports[i], metrics, true);
                }
            }
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            int importCount;
            if (!fromChild && (importCount = loader.getImportedLoadersCount()) > 0) {
                PolicyClassLoader[] imports = loader.getImportedLoaders();
                for (int i = 0; i < importCount; ++i) {
                    PolicyClassLoader shared = imports[i];
                    if (IMPORTED_LOADERS.visit(visitor, shared, visitNonSharedParents, true)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class AskLocal
    extends SearchPolicy {
        private PolicyClassLoader delegate;

        public AskLocal(PolicyClassLoader delegate) {
            super("askLocal");
            this.delegate = delegate;
        }

        protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            return LOCAL_ONLY.loadClass(className, this.delegate, metrics, fromChild);
        }

        public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            return this.delegate.findLocalResource(CodeSourceSearchPolicy.DEFAULT, resourceName, metrics);
        }

        public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            this.delegate.addAllLocalResources(CodeSourceSearchPolicy.DEFAULT, resourceName, resources, metrics);
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            return visitor.visit(this.delegate);
        }
    }

    public static class TrustedAskMain
    extends SearchPolicy {
        private Map fwTransferClasses = InitialLoadersFactory.getFrameworkTransferClasses();

        protected TrustedAskMain() {
            super("trustedAskMain");
        }

        protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            PolicyClassLoader main = TrustedAskMain.getMainLoader();
            Class result = main.findCachedClass(className, metrics, true);
            if (result == null && (result = (Class)this.fwTransferClasses.get(className)) == null) {
                result = main.findLocalClass(CodeSourceSearchPolicy.DEFAULT, className, metrics);
            }
            if (result != null) {
                EventDispatcher.classFoundTrusted(result, loader);
            }
            return result;
        }

        public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            PolicyClassLoader main = TrustedAskMain.getMainLoader();
            URL result = main.findLocalResource(CodeSourceSearchPolicy.DEFAULT, resourceName, metrics);
            if (result != null) {
                EventDispatcher.resourceFoundTrusted(result, loader);
            }
            return result;
        }

        public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            PolicyClassLoader main = TrustedAskMain.getMainLoader();
            ArrayList localResources = new ArrayList();
            main.addAllLocalResources(CodeSourceSearchPolicy.DEFAULT, resourceName, localResources, metrics);
            if (!localResources.isEmpty()) {
                resources.addAll(localResources);
                EventDispatcher.resourcesFoundTrusted(localResources, loader);
            }
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            PolicyClassLoader main = TrustedAskMain.getMainLoader();
            return visitor.visit(main);
        }
    }

    public static class AskMain
    extends SearchPolicy {
        protected AskMain() {
            super("askMain");
        }

        protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            PolicyClassLoader main = AskMain.getMainLoader();
            Class result = main.findCachedClass(className, metrics, true);
            if (result == null) {
                result = main.findLocalClass(CodeSourceSearchPolicy.DEFAULT, className, metrics);
            }
            return result;
        }

        public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            PolicyClassLoader main = AskMain.getMainLoader();
            return main.findLocalResource(CodeSourceSearchPolicy.DEFAULT, resourceName, metrics);
        }

        public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            PolicyClassLoader main = AskMain.getMainLoader();
            main.addAllLocalResources(CodeSourceSearchPolicy.DEFAULT, resourceName, resources, metrics);
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            PolicyClassLoader main = AskMain.getMainLoader();
            return visitor.visit(main);
        }
    }

    public static class FindMain
    extends SearchPolicy {
        private static boolean triggered;

        protected FindMain() {
            super("findMain");
        }

        protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            if (!triggered) {
                triggered = true;
                try {
                    return this.getClass().getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            return null;
        }

        public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            return null;
        }

        public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            return true;
        }
    }

    public static class JavaxServletOnly
    extends SearchPolicy {
        protected JavaxServletOnly() {
            super("webOverrideOnly");
        }

        protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            if (!ClassLoadEnvironment.canWebLoaderOverrideClassOrResource(className)) {
                return loader.findLocalClass(CodeSourceSearchPolicy.DEFAULT, className, metrics);
            }
            return null;
        }

        public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            if (!ClassLoadEnvironment.canWebLoaderOverrideClassOrResource(resourceName)) {
                return loader.findLocalResource(CodeSourceSearchPolicy.DEFAULT, resourceName, metrics);
            }
            return null;
        }

        public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            if (!ClassLoadEnvironment.canWebLoaderOverrideClassOrResource(resourceName)) {
                loader.addAllLocalResources(CodeSourceSearchPolicy.DEFAULT, resourceName, resources, metrics);
            }
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            return visitor.visit(loader);
        }
    }

    public static class WebFindLocal
    extends SearchPolicy {
        protected WebFindLocal() {
            super("webFindLocal");
        }

        protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            if (ClassLoadEnvironment.canWebLoaderOverrideClassOrResource(className)) {
                return loader.findLocalClass(CodeSourceSearchPolicy.DEFAULT, className, metrics);
            }
            return null;
        }

        public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            if (ClassLoadEnvironment.canWebLoaderOverrideClassOrResource(resourceName)) {
                return loader.findLocalResource(CodeSourceSearchPolicy.DEFAULT, resourceName, metrics);
            }
            return null;
        }

        public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            if (ClassLoadEnvironment.canWebLoaderOverrideClassOrResource(resourceName)) {
                loader.addAllLocalResources(CodeSourceSearchPolicy.DEFAULT, resourceName, resources, metrics);
            }
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            return visitor.visit(loader);
        }
    }

    public static class FindLocal
    extends SearchPolicy {
        protected FindLocal() {
            super("findLocal");
        }

        protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            return loader.findLocalClass(CodeSourceSearchPolicy.DEFAULT, className, metrics);
        }

        public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            return loader.findLocalResource(CodeSourceSearchPolicy.DEFAULT, resourceName, metrics);
        }

        public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            loader.addAllLocalResources(CodeSourceSearchPolicy.DEFAULT, resourceName, resources, metrics);
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            return visitor.visit(loader);
        }
    }

    public static class AskParentAndShared
    extends SearchPolicy {
        protected AskParentAndShared() {
            super("askParentAndShared");
        }

        protected Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            PolicyClassLoader parent = loader.parent();
            if (parent != null) {
                SearchPolicy policy = parent.getSearchPolicy();
                return policy.loadClass(className, parent, metrics, false);
            }
            return null;
        }

        public URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            PolicyClassLoader parent = loader.parent();
            if (parent != null) {
                SearchPolicy policy = parent.getSearchPolicy();
                return policy.findResource(resourceName, parent, metrics, false);
            }
            return null;
        }

        public void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) throws IOException {
            PolicyClassLoader parent = loader.parent();
            SearchPolicy policy = parent.getSearchPolicy();
            policy.addAllResources(resourceName, resources, parent, metrics, false);
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            PolicyClassLoader parent;
            if (visitNonSharedParents && (parent = loader.parent()) != null) {
                return parent.visitUsingPolicy(visitor, visitNonSharedParents, false);
            }
            return true;
        }
    }

    protected static class AskSharedParent
    extends SearchPolicy {
        protected AskSharedParent() {
            super("askSharedParent");
        }

        protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            PolicyClassLoader parent = loader.parent();
            if (parent != null && parent.isSharedLoader()) {
                return loader.askParentForClass(className, metrics, true);
            }
            return null;
        }

        public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            PolicyClassLoader parent = loader.parent();
            if (parent != null && parent.isSharedLoader()) {
                return loader.askParentForResource(resourceName, metrics, true);
            }
            return null;
        }

        public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) throws IOException {
            PolicyClassLoader parent = loader.parent();
            if (parent != null && parent.isSharedLoader()) {
                loader.askParentForAllResources(resourceName, resources, metrics, true);
            }
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            PolicyClassLoader parent = loader.parent();
            if (parent != null && parent.isSharedLoader()) {
                return parent.visitUsingPolicy(visitor, visitNonSharedParents, true);
            }
            return true;
        }
    }

    public static class AskParent
    extends SearchPolicy {
        protected AskParent() {
            super("askParent");
        }

        protected Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            return loader.askParentForClass(className, metrics, false);
        }

        public URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            return loader.askParentForResource(resourceName, metrics, false);
        }

        public void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) throws IOException {
            loader.askParentForAllResources(resourceName, resources, metrics, false);
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            PolicyClassLoader parent;
            if (visitNonSharedParents && (parent = loader.parent()) != null) {
                return parent.visitUsingPolicy(visitor, visitNonSharedParents, true);
            }
            return true;
        }
    }

    public static class FindLoadedClass
    extends SearchPolicy {
        protected FindLoadedClass() {
            super("findLoadedClass");
        }

        protected final Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            return loader.findCachedClass(className, metrics, fromChild);
        }

        public final URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
            return null;
        }

        public final void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        }

        public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
            return true;
        }
    }
}

