/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchMetrics;
import oracle.classloader.SearchPolicy;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;

public class SearchSequence
extends SearchPolicy {
    private SearchPolicy[] policies;
    private boolean doesCheckImports;

    public SearchSequence(String policyName, SearchPolicy[] policies) {
        super(policyName);
        this.policies = policies;
        for (int i = 0; i < policies.length; ++i) {
            if (!policies[i].doesCheckImports()) continue;
            this.doesCheckImports = true;
            break;
        }
    }

    public SearchPolicy prepend(String policyName, SearchPolicy policy) {
        int size = this.policies.length;
        SearchPolicy[] newPolicies = new SearchPolicy[size + 1];
        System.arraycopy(this.policies, 0, newPolicies, 1, size);
        newPolicies[0] = policy;
        return new SearchSequence(policyName, newPolicies);
    }

    public SearchPolicy append(String policyName, SearchPolicy policy) {
        int size = this.policies.length;
        SearchPolicy[] newPolicies = new SearchPolicy[size + 1];
        System.arraycopy(this.policies, 0, newPolicies, 0, size);
        newPolicies[size] = policy;
        return new SearchSequence(policyName, newPolicies);
    }

    public SearchPolicy insert(String policyName, SearchPolicy policy, SearchPolicy position) {
        int destIndex = 0;
        SearchPolicy[] newPolicies = new SearchPolicy[this.policies.length + 1];
        int srcIndex = ArrayUtils.indexOf(this.policies, this.policies.length, position);
        if (srcIndex < 0) {
            srcIndex = this.policies.length - 1;
        }
        for (int i = 0; i < this.policies.length; ++i) {
            if (i == srcIndex) {
                newPolicies[destIndex++] = policy;
            }
            newPolicies[destIndex++] = this.policies[i];
        }
        return new SearchSequence(policyName, newPolicies);
    }

    public boolean doesCheckImports() {
        return this.doesCheckImports;
    }

    protected Class getClass(String className, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        for (int i = 0; i < this.policies.length; ++i) {
            Class result = this.policies[i].getClass(className, loader, metrics, fromChild);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public URL findResource(String resourceName, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) {
        for (int i = 0; i < this.policies.length; ++i) {
            ClassLoader ctx;
            URL result = this.policies[i].findResource(resourceName, loader, metrics, fromChild);
            if (result == null) continue;
            if (!fromChild && loader == ClassLoaderQuery.getSystemLoader() && resourceName.startsWith("META-INF/services/javax.xml.") && ClassLoadEnvironment.maskJAXPSystemResources() && (ctx = Thread.currentThread().getContextClassLoader()) instanceof PolicyClassLoader && ctx != ClassLoaderQuery.getSystemLoader()) {
                ClassLoadLogger.log(Level.FINE, "Masking " + result + " from " + loader.getDisplayName());
                return null;
            }
            return result;
        }
        return null;
    }

    public void addAllResources(String resourceName, List resources, PolicyClassLoader loader, SearchMetrics metrics, boolean fromChild) throws IOException {
        for (int i = 0; i < this.policies.length; ++i) {
            this.policies[i].addAllResources(resourceName, resources, loader, metrics, fromChild);
        }
    }

    public boolean visit(ClassLoaderVisitor visitor, PolicyClassLoader loader, boolean visitNonSharedParents, boolean fromChild) {
        for (int i = 0; i < this.policies.length; ++i) {
            if (this.policies[i].visit(visitor, loader, visitNonSharedParents, fromChild)) continue;
            return false;
        }
        return true;
    }

    public SearchPolicy[] getPolicies() {
        return (SearchPolicy[])this.policies.clone();
    }

    public String[] getSearchStepNames() {
        int size = this.policies.length;
        String[] result = new String[size];
        for (int i = 0; i < this.policies.length; ++i) {
            result[i] = this.policies[i].getName();
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append("[");
        for (int i = 0; i < this.policies.length; ++i) {
            if (i > 0) {
                buf.append(" -> ");
            }
            buf.append(this.policies[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public void close() {
        for (int i = 0; i < this.policies.length; ++i) {
            this.policies[i].close();
        }
    }
}

