/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedDirectory;
import oracle.classloader.SharedJar;
import oracle.classloader.util.ClassLoadLogger;

public abstract class SharedCodeSourceFactory {
    private static Map factories = new HashMap();

    public static synchronized SharedCodeSource create(URL location, File existingCanonicalFile) throws IOException {
        SharedCodeSource result = null;
        String protocol = location.getProtocol();
        SharedCodeSourceFactory factory = (SharedCodeSourceFactory)factories.get(protocol);
        if (factory != null) {
            result = factory.createCodeSource(location, existingCanonicalFile);
            if (result != null) {
                return result;
            }
            ClassLoadLogger.log(Level.WARNING, "Could not create code-source for " + location);
            return null;
        }
        throw new IOException("Unsupported URL protocol for code source creation: " + location);
    }

    public static synchronized SharedCodeSourceFactory register(String protocol, SharedCodeSourceFactory factory) {
        return factories.put(protocol, factory);
    }

    protected abstract SharedCodeSource createCodeSource(URL var1, File var2) throws IOException;

    static {
        factories.put("file", new FileSystem());
    }

    public static class FileSystem
    extends SharedCodeSourceFactory {
        protected SharedCodeSource createCodeSource(URL location, File existingCanonicalFile) throws IOException {
            if (existingCanonicalFile != null) {
                if (!existingCanonicalFile.exists()) {
                    throw new IOException("File does not exist: " + location);
                }
                if (existingCanonicalFile.isFile()) {
                    return this.createJar(existingCanonicalFile, location);
                }
                if (existingCanonicalFile.isDirectory()) {
                    return this.createDirectory(existingCanonicalFile, location);
                }
            }
            return null;
        }

        protected SharedJar createJar(File file, URL location) {
            return new SharedJar(file, location);
        }

        protected SharedDirectory createDirectory(File file, URL location) {
            return new SharedDirectory(file, location);
        }
    }
}

