/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.classloader.CodeSourceVisitor;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ExtensionDependency;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ClassLoadLogger;

public class SharedCodeSourceList {
    static final Entry MARKER = new Entry();
    private Index index;
    private PolicyClassLoader loader;
    private Entry head;
    private Entry tail;
    private boolean committed;

    public SharedCodeSourceList(PolicyClassLoader loader) {
        this.loader = loader;
        this.index = loader.getConfigurationPolicy().createIndex();
    }

    public Entry add(SharedCodeSource source, ProtectionPolicy protection) {
        Entry entry = new Entry(source, protection, false);
        this.addEntry(entry);
        if (entry.shouldCheckManifest(this.loader)) {
            source.subscribeManifestClassPath(this.loader, this, protection);
        }
        return entry;
    }

    public void addFromManifest(SharedCodeSource source, ProtectionPolicy protection) {
        Entry entry = new Entry(source, protection, true);
        this.addEntry(entry);
        if (entry.shouldCheckManifest(this.loader)) {
            source.subscribeManifestClassPath(this.loader, this, protection);
        }
    }

    private void addEntry(Entry entry) {
        if (this.head == null) {
            this.head = entry;
            this.tail = entry;
        } else {
            this.tail.next = entry;
            this.tail = entry;
        }
        if (this.index != null) {
            try {
                this.index.update(entry);
            }
            catch (Exception e) {
                ClassLoadLogger.logException("Could not build index", e, false);
                this.index = new LinearIndex(this);
            }
        }
    }

    public Entry getFirst() {
        return this.head;
    }

    public void resolveExtensionDependencies() {
        this.resolveExtensionDependencies(this.head);
        this.committed = true;
    }

    public void resolveExtensionDependencies(Entry current) {
        while (current != null) {
            ExtensionDependency.resolveAll(current.source, this.loader);
            current = current.next;
        }
    }

    public SharedCodeSource[] getCodeSources(boolean includeManifestSources) {
        ArrayList<SharedCodeSource> list = new ArrayList<SharedCodeSource>();
        for (Entry entry = this.getFirst(); entry != null; entry = entry.getNext(includeManifestSources)) {
            if (!includeManifestSources && entry.isFromManifest()) continue;
            list.add(entry.getSource());
        }
        SharedCodeSource[] result = new SharedCodeSource[list.size()];
        list.toArray(result);
        return result;
    }

    public boolean visitCodeSources(CodeSourceVisitor visitor, boolean includeManifestSources) {
        for (Entry entry = this.getFirst(); entry != null; entry = entry.getNext(includeManifestSources)) {
            if (!includeManifestSources && entry.isFromManifest() || visitor.visit(entry.getSource(), this.loader)) continue;
            return false;
        }
        return true;
    }

    public void unsubscribe() {
        for (Entry entry = this.getFirst(); entry != null; entry = entry.getNext(true)) {
            entry.getSource().unsubscribe(this.loader);
        }
    }

    public PolicyClassLoader getOwner() {
        return this.loader;
    }

    Index getIndex() {
        return this.index;
    }

    static class RuntimeIndex2
    implements Index {
        private Map<String, Entry> map = new HashMap<String, Entry>();

        RuntimeIndex2() {
        }

        public void update(Entry entry) throws Exception {
            SharedCodeSource source = entry.source;
            String[] packagePaths = source.listPackagePaths();
            block0: for (int i = 0; i < packagePaths.length; ++i) {
                String packagePath = packagePaths[i];
                Entry indexEntry = this.map.get(packagePath);
                if (indexEntry == null) {
                    indexEntry = new Entry(entry);
                    this.map.put(packagePath, indexEntry);
                    continue;
                }
                while (indexEntry.source != source) {
                    if (indexEntry.next != null) {
                        indexEntry = indexEntry.next;
                        continue;
                    }
                    indexEntry.next = new Entry(entry);
                    continue block0;
                }
            }
        }

        public Entry find(String packagePath) {
            return this.map.get(packagePath);
        }
    }

    static class RuntimeIndex1
    implements Index {
        private Map map = new HashMap();

        RuntimeIndex1() {
        }

        public void update(Entry entry) throws Exception {
            SharedCodeSource source = entry.source;
            String[] files = source.listFilePaths();
            block0: for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                int lastSlash = file.lastIndexOf(47);
                if (lastSlash < 0) continue;
                String resourcePath = file.substring(0, lastSlash);
                Entry indexEntry = (Entry)this.map.get(resourcePath);
                if (indexEntry == null) {
                    indexEntry = new Entry(entry);
                    this.map.put(resourcePath, indexEntry);
                    continue;
                }
                while (indexEntry.source != source) {
                    if (indexEntry.next != null) {
                        indexEntry = indexEntry.next;
                        continue;
                    }
                    indexEntry.next = new Entry(entry);
                    continue block0;
                }
            }
        }

        public Entry find(String packagePath) {
            return (Entry)this.map.get(packagePath);
        }
    }

    static class LinearIndex
    implements Index {
        SharedCodeSourceList list;

        LinearIndex(SharedCodeSourceList list) {
            this.list = list;
        }

        public void update(Entry entry) throws Exception {
        }

        public Entry find(String packagePath) {
            return this.list.getFirst();
        }
    }

    public static interface Index {
        public void update(Entry var1) throws Exception;

        public Entry find(String var1);
    }

    public static class Entry {
        private boolean fromManifest;
        private SharedCodeSource source;
        private ProtectionPolicy protection;
        private Entry next;

        protected Entry() {
        }

        public Entry(Entry existing) {
            this.source = existing.source;
            this.protection = existing.protection;
            this.fromManifest = existing.fromManifest;
        }

        public Entry(SharedCodeSource source, ProtectionPolicy protection, boolean fromManifest) {
            this.source = source;
            this.protection = protection;
            this.fromManifest = fromManifest;
        }

        protected boolean shouldCheckManifest(PolicyClassLoader loader) {
            ConfigurationOrigin[] origins = this.source.getSubscribers().getOriginsFor(loader);
            for (int i = 0; i < origins.length; ++i) {
                ConfigurationOrigin origin = origins[i];
                if (origin.getType().shouldManifestBeChecked()) continue;
                return false;
            }
            return true;
        }

        public SharedCodeSource getSource() {
            return this.source;
        }

        public ProtectionPolicy getProtection() {
            return this.protection;
        }

        public boolean isFromManifest() {
            return this.fromManifest;
        }

        public Entry getNext(boolean includeManifestSources) {
            Entry result = this.next;
            if (!includeManifestSources) {
                while (result != null && result.fromManifest) {
                    result = result.next;
                }
            }
            return result;
        }

        public Entry setNext(Entry next) {
            Entry old = this.next;
            this.next = next;
            return old;
        }
    }
}

