/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.EventDispatcher;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceFactory;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.FileUtils;

public class SharedCodeSourceSet {
    private static final int SUBSTITUTE_DENY = 0;
    private static final int SUBSTITUTE_ALLOW = 1;
    private static final int SUBSTITUTE_IGNORE = 2;
    private static Map codeSources = new HashMap();
    private static Map fileNameToCodeSources = new HashMap();
    private static int autoCloseIdleTicks = ClassLoadEnvironment.getDefaultMinimumCodeSourceIdleTicks();
    private static boolean maximizeFileSharing = ClassLoadEnvironment.maximizeFileSharing();
    private static int maxLRUSize = ClassLoadEnvironment.getDefaultMaximumCodeSourceLRUSize();
    private static LinkedList lru = new LinkedList();
    private static SharedCodeSource bootCodeSource;

    public static int setAutoCloseIdleTicks(int ticks) {
        int old = autoCloseIdleTicks;
        autoCloseIdleTicks = ticks;
        return old;
    }

    public static synchronized int setMaxLRUSize(int size) {
        int old = maxLRUSize;
        maxLRUSize = size;
        SharedCodeSourceSet.trimLRU(size);
        return old;
    }

    public static synchronized void flushLRU() {
        SharedCodeSourceSet.trimLRU(0);
    }

    public static synchronized void flushCodeSource(SharedCodeSource cs) {
        if (cs != null) {
            SharedCodeSourceSet.removeFromLRU(cs);
            SharedCodeSourceSet.remove(cs);
            cs.destroy();
            EventDispatcher.codeSourceDestroyed(cs.getLocation());
        }
    }

    public static SharedCodeSource subscribe(String path, ConfigurationOrigin origin, PolicyClassLoader subscriber) throws IOException {
        return SharedCodeSourceSet.subscribe(new File(path), origin, subscriber);
    }

    public static SharedCodeSource subscribe(File file, ConfigurationOrigin origin, PolicyClassLoader subscriber) throws IOException {
        File canonicalFile = FileUtils.getCanonicalFile(file, origin);
        if (canonicalFile.exists()) {
            if (canonicalFile.isFile() && canonicalFile.length() == 0L) {
                if (ClassLoadLogger.willLog(Level.WARNING)) {
                    ClassLoadLogger.log(Level.WARNING, "Ignoring zero-length code source: " + file.getPath() + "(from " + origin + ")");
                }
            } else {
                URL codeLocation = canonicalFile.toURL();
                if (codeLocation != null) {
                    return SharedCodeSourceSet.subscribe(codeLocation, canonicalFile, origin, subscriber);
                }
            }
        }
        if (ClassLoadLogger.willLog(Level.FINEST)) {
            ClassLoadLogger.log(Level.FINEST, "Ignoring non-existent code source: " + file.getPath() + "(from " + origin + ")");
        }
        return SharedCodeSource.NON_EXISTENT;
    }

    public static SharedCodeSource subscribe(URL codeLocation, ConfigurationOrigin origin, PolicyClassLoader subscriber) throws IOException {
        if (codeLocation.getProtocol().equals("code-source")) {
            File existingCanonicalFile = new File(codeLocation.getPath());
            return SharedCodeSourceSet.subscribe(codeLocation, existingCanonicalFile, origin, subscriber);
        }
        if (codeLocation.getProtocol().equals("file")) {
            String path = codeLocation.getPath();
            if (path.indexOf(37) >= 0) {
                path = URLDecoder.decode(path, "UTF-8");
            }
            return SharedCodeSourceSet.subscribe(path, origin, subscriber);
        }
        return SharedCodeSourceSet.subscribe(codeLocation, null, origin, subscriber);
    }

    public static synchronized void addFileNameAliasFor(SharedCodeSource codeSource, String fileNameAlias) {
        fileNameToCodeSources.put(fileNameAlias, codeSource);
    }

    private static synchronized SharedCodeSource subscribe(URL codeLocation, File existingCanonicalFile, ConfigurationOrigin origin, PolicyClassLoader subscriber) throws IOException {
        String fileName;
        SharedCodeSource substitute;
        PolicyClassLoader alreadyVisibleTo = null;
        String path = codeLocation.getPath();
        SharedCodeSource result = (SharedCodeSource)codeSources.get(path);
        if (result != null) {
            boolean isNative = origin.getType().isNative();
            alreadyVisibleTo = result.getVisibleFrom(subscriber, isNative);
            if (subscriber.getSearchPolicy() != SearchPolicy.WEB_LOCAL_FIRST && alreadyVisibleTo != null) {
                ClassLoadLogger.log(Level.FINER, "visible.ignore", origin, result, subscriber.getDisplayName());
                return null;
            }
            if (!ClassLoadEnvironment.allowCodeSource(result, subscriber)) {
                return null;
            }
            SharedCodeSourceSet.refresh(result);
            result.addSubscriber(subscriber, origin);
            return result;
        }
        if (existingCanonicalFile != null && existingCanonicalFile.isFile() && (substitute = (SharedCodeSource)fileNameToCodeSources.get(fileName = existingCanonicalFile.getName())) != null) {
            int canSub = SharedCodeSourceSet.shouldSubstitute(substitute, existingCanonicalFile, subscriber, origin);
            if (canSub == 1) {
                result = substitute;
            } else if (canSub == 2) {
                return null;
            }
        }
        if (result == null) {
            result = SharedCodeSourceFactory.create(codeLocation, existingCanonicalFile);
            if (result == null) {
                return null;
            }
            EventDispatcher.codeSourceCreated(result, origin);
        } else {
            SharedCodeSourceSet.refresh(result);
        }
        return (SharedCodeSource)result.addSubscriber(subscriber, origin);
    }

    private static void refresh(SharedCodeSource source) {
        if (source.getState() == 4) {
            source.setState(1);
        }
        source.refresh();
    }

    static synchronized void add(SharedCodeSource source) {
        String path = source.getLocation().getPath();
        codeSources.put(path, source);
        String fileName = SharedCodeSourceSet.getFileName(path);
        if (fileName != null && !fileNameToCodeSources.containsKey(fileName)) {
            fileNameToCodeSources.put(fileName, source);
        }
    }

    private static void remove(SharedCodeSource source) {
        String path = source.getLocation().getPath();
        codeSources.remove(path);
        String fileName = SharedCodeSourceSet.getFileName(path);
        if (fileName != null && fileNameToCodeSources.get(fileName) == source) {
            fileNameToCodeSources.remove(fileName);
        }
    }

    private static String getFileName(String path) {
        int index;
        if (path.charAt(path.length() - 1) != '/' && (index = path.lastIndexOf(47)) >= 0) {
            return path.substring(index + 1);
        }
        return null;
    }

    static List getAllCodeSources() {
        SharedCodeSourceSet.getBootCodeSource();
        ArrayList result = new ArrayList();
        SharedCodeSourceSet.addAllCodeSources(result);
        return result;
    }

    public static SharedCodeSource getBootCodeSource() {
        if (bootCodeSource == null) {
            try {
                Class<SharedCodeSourceSet> ourClass = SharedCodeSourceSet.class;
                URL ourLocation = ClassLoaderQuery.getCodeSourceLocationFor(ourClass);
                File ourFile = null;
                if (ourLocation == null) {
                    ourFile = new File(ClassLoaderQuery.getHomeDirectory(), "lib/pcl.jar");
                    ourLocation = ourFile.toURL();
                } else {
                    ourFile = new File(ClassLoaderQuery.getPath(ourLocation));
                }
                bootCodeSource = SharedCodeSourceFactory.create(ourLocation, ourFile);
            }
            catch (Exception e) {
                bootCodeSource = SharedCodeSource.NON_EXISTENT;
                ClassLoadLogger.logException("Could not create boot code-source.", e, false);
            }
        }
        return bootCodeSource;
    }

    static synchronized void addAllCodeSources(Collection collection) {
        collection.addAll(codeSources.values());
    }

    static InputStream getResourceStream(URL codeSourceURL) throws IOException {
        String fullPath = codeSourceURL.getPath();
        int length = fullPath.length();
        int index = fullPath.indexOf(33);
        if (index >= 0) {
            String codeSourcePath = fullPath.substring(0, index);
            SharedCodeSource source = SharedCodeSourceSet.find(codeSourcePath);
            if (source == null) {
                throw new IOException(codeSourcePath + " does not exist.");
            }
            if (++index < length) {
                if (fullPath.charAt(index) == '/') {
                    if (++index < length) {
                        return source.getStream(fullPath.substring(index));
                    }
                } else {
                    return source.getStream(fullPath.substring(index));
                }
            }
        }
        throw new IOException(codeSourceURL + " has no \"!/<path>\" suffix so does not name a path within the code-source.");
    }

    static long getResourceLength(URL codeSourceURL) {
        String codeSourcePath;
        SharedCodeSource source;
        long result = -1L;
        String fullPath = codeSourceURL.getPath();
        int length = fullPath.length();
        int index = fullPath.indexOf(33);
        if (index >= 0 && (source = SharedCodeSourceSet.find(codeSourcePath = fullPath.substring(0, index))) != null) {
            try {
                if (++index < length) {
                    if (fullPath.charAt(index) == '/') {
                        if (++index < length) {
                            result = source.getLength(fullPath.substring(index));
                        }
                    } else {
                        result = source.getLength(fullPath.substring(index));
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    static long getLastModifiedTime(URL codeSourceURL) {
        String codeSourcePath;
        SharedCodeSource source;
        long result = 0L;
        String fullPath = codeSourceURL.getPath();
        int length = fullPath.length();
        int index = fullPath.indexOf(33);
        if (index >= 0 && (source = SharedCodeSourceSet.find(codeSourcePath = fullPath.substring(0, index))) != null) {
            try {
                if (++index < length) {
                    if (fullPath.charAt(index) == '/') {
                        if (++index < length) {
                            result = source.getLastModifiedTime(fullPath.substring(index));
                        }
                    } else {
                        result = source.getLastModifiedTime(fullPath.substring(index));
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    static SharedCodeSource find(URL location) {
        return SharedCodeSourceSet.find(location.getPath());
    }

    static synchronized SharedCodeSource find(String path) {
        return (SharedCodeSource)codeSources.get(path);
    }

    private static int shouldSubstitute(SharedCodeSource existing, File candidate, PolicyClassLoader subscriber, ConfigurationOrigin origin) {
        int result;
        String logMsg;
        Level logLevel;
        ConfigurationPolicy cfgPolicy = subscriber.getConfigurationPolicy();
        int eqPolicy = cfgPolicy.getFileEqualityPolicyFor(candidate, existing, subscriber);
        if (eqPolicy == 1 || eqPolicy == 5) {
            return 0;
        }
        boolean isNative = origin.getType().isNative();
        PolicyClassLoader alreadyVisibleTo = existing.getVisibleFrom(subscriber, isNative);
        if (alreadyVisibleTo == null && !maximizeFileSharing) {
            return 0;
        }
        if (existing.canSubstituteFor(eqPolicy, candidate, subscriber)) {
            if (alreadyVisibleTo != null) {
                logLevel = Level.FINE;
                logMsg = "equal.visible";
                result = 2;
            } else {
                logLevel = Level.FINE;
                logMsg = "equal.not.visible";
                result = 1;
            }
        } else if (alreadyVisibleTo != null) {
            logLevel = Level.WARNING;
            logMsg = "not.equal.visible";
            result = 0;
        } else {
            logLevel = Level.FINE;
            logMsg = "not.equal.not.visible";
            result = 0;
        }
        if (ClassLoadLogger.willLog(logLevel)) {
            ClassLoadLogger.log(logLevel, logMsg, candidate.getPath(), origin, existing, subscriber.getDisplayName());
        }
        return result;
    }

    private static void trimLRU(int maxSize) {
        while (lru.size() > maxSize) {
            SharedCodeSource tail = (SharedCodeSource)lru.getLast();
            SharedCodeSourceSet.remove(tail);
            tail.destroy();
            EventDispatcher.codeSourceDestroyed(tail.getLocation());
        }
    }

    static synchronized void addToLRU(SharedCodeSource cs) {
        SharedCodeSourceSet.trimLRU(maxLRUSize);
        lru.addFirst(cs);
    }

    static synchronized void removeFromLRU(SharedCodeSource cs) {
        lru.remove(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doPeriodicMaintenance(int currentMaintenanceTick) {
        if (autoCloseIdleTicks < 0) return;
        int closeCount = 0;
        SharedCodeSource[] close = null;
        Class<SharedCodeSourceSet> clazz = SharedCodeSourceSet.class;
        synchronized (SharedCodeSourceSet.class) {
            for (SharedCodeSource cs : codeSources.values()) {
                int idleTicks;
                if (cs.getState() != 2 || (idleTicks = currentMaintenanceTick - cs.getLastReadTick()) < autoCloseIdleTicks || !ClassLoadEnvironment.shouldCloseOnIdle(cs, idleTicks)) continue;
                close = (SharedCodeSource[])ArrayUtils.append(SharedCodeSource.class, close, closeCount++, cs);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (closeCount <= 0) return;
            for (int i = 0; i < closeCount; ++i) {
                close[i].close();
            }
            return;
        }
    }

    static boolean setMaximizeFileSharing(boolean maximize) {
        boolean result = maximizeFileSharing;
        maximizeFileSharing = maximize;
        return result;
    }
}

