/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader;

import java.lang.ref.WeakReference;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.ClassLoaderVisitor;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.Sharable;
import oracle.classloader.util.ArrayUtils;

public class SubscriberSet
implements ClassLoaderVisitor {
    private Sharable shared;
    private int subscribersCount;
    private SubscriberEntry[] subscribers = new SubscriberEntry[4];
    private boolean searchNonSharedParents;
    private PolicyClassLoader searchReachesExistingSubscriber;
    private boolean isNative;

    public SubscriberSet(Sharable shared, boolean searchNonSharedParents) {
        this.shared = shared;
        this.searchNonSharedParents = searchNonSharedParents;
    }

    public Sharable getShared() {
        return this.shared;
    }

    public synchronized int getCount() {
        return this.subscribersCount;
    }

    public synchronized PolicyClassLoader getFirstSubscriber() {
        while (this.subscribersCount > 0) {
            PolicyClassLoader subscriber = this.subscribers[0].getSubscriber();
            if (subscriber == null) {
                this.subscribersCount = ArrayUtils.remove((Object[])this.subscribers, this.subscribersCount, 0);
                continue;
            }
            return subscriber;
        }
        return null;
    }

    public synchronized ClassLoaderScope getMinimumScope() {
        ClassLoaderScope scope = null;
        for (int i = 0; i < this.subscribersCount; ++i) {
            PolicyClassLoader loader = (PolicyClassLoader)this.subscribers[i].get();
            if (loader == null) continue;
            ClassLoaderScope potential = loader.getScope();
            if (scope != null && potential.getLevel() >= scope.getLevel()) continue;
            scope = potential;
        }
        return scope;
    }

    public synchronized boolean containsSubscriber(PolicyClassLoader subscriber) {
        return this.find(subscriber) != null;
    }

    public synchronized boolean containsApplicationSubscriber() {
        for (int i = 0; i < this.subscribersCount; ++i) {
            PolicyClassLoader subscriber = this.subscribers[i].getSubscriber();
            if (subscriber == null || !subscriber.isApplicationLoader()) continue;
            return true;
        }
        return false;
    }

    public synchronized PolicyClassLoader[] getSubscribers() {
        PolicyClassLoader[] result = new PolicyClassLoader[this.subscribersCount];
        for (int i = 0; i < this.subscribersCount; ++i) {
            result[i] = this.subscribers[i].getSubscriber();
        }
        return result;
    }

    public synchronized ConfigurationOrigin getFirstOriginFor(PolicyClassLoader subscriber) {
        SubscriberEntry entry = this.find(subscriber);
        if (entry != null) {
            return entry.getFirstOrigin();
        }
        return null;
    }

    public synchronized ConfigurationOrigin[] getOriginsFor(PolicyClassLoader subscriber) {
        SubscriberEntry entry = this.find(subscriber);
        if (entry != null) {
            return entry.copyOrigins();
        }
        return new ConfigurationOrigin[0];
    }

    public synchronized Sharable addSubscriber(PolicyClassLoader candidate, ConfigurationOrigin origin) {
        SubscriberEntry entry = this.find(candidate);
        if (entry != null) {
            entry.addOrigin(origin);
            return null;
        }
        entry = new SubscriberEntry(candidate, origin);
        this.subscribers = (SubscriberEntry[])ArrayUtils.append(SubscriberEntry.class, this.subscribers, this.subscribersCount++, entry);
        return this.shared;
    }

    synchronized PolicyClassLoader getVisibleFrom(PolicyClassLoader subscriber, boolean isNative) {
        if (this.subscribersCount == 0) {
            return null;
        }
        this.searchReachesExistingSubscriber = null;
        this.isNative = isNative;
        subscriber.visitUsingPolicy(this, this.searchNonSharedParents, false);
        return this.searchReachesExistingSubscriber;
    }

    public boolean visit(PolicyClassLoader loader) {
        for (int i = 0; i < this.subscribersCount; ++i) {
            if (this.subscribers[i].get() != loader) continue;
            for (int j = 0; j < this.subscribers[i].originsCount; ++j) {
                boolean existingIsNative = this.subscribers[i].origins[j].getType().isNative();
                if (this.isNative != existingIsNative) continue;
                this.searchReachesExistingSubscriber = loader;
                return false;
            }
        }
        return true;
    }

    public synchronized int removeSubscriber(PolicyClassLoader subscriber) {
        int index = this.indexOf(subscriber);
        if (index >= 0) {
            this.subscribersCount = ArrayUtils.remove((Object[])this.subscribers, this.subscribersCount, index);
        }
        return this.subscribersCount;
    }

    private SubscriberEntry find(PolicyClassLoader subscriber) {
        for (int i = 0; i < this.subscribersCount; ++i) {
            if (this.subscribers[i].get() != subscriber) continue;
            return this.subscribers[i];
        }
        return null;
    }

    private int indexOf(PolicyClassLoader subscriber) {
        for (int i = 0; i < this.subscribersCount; ++i) {
            if (this.subscribers[i].get() != subscriber) continue;
            return i;
        }
        return -1;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.subscribersCount; ++i) {
            PolicyClassLoader subscriber = this.subscribers[i].getSubscriber();
            if (subscriber == null) continue;
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(subscriber.getDisplayName());
        }
        return buf.toString();
    }

    private static class SubscriberEntry
    extends WeakReference {
        private int originsCount;
        private ConfigurationOrigin[] origins = new ConfigurationOrigin[8];

        private SubscriberEntry(PolicyClassLoader subscriber, ConfigurationOrigin origin) {
            super(subscriber);
            this.origins[this.originsCount++] = origin;
        }

        private PolicyClassLoader getSubscriber() {
            return (PolicyClassLoader)this.get();
        }

        private ConfigurationOrigin getFirstOrigin() {
            return this.origins[0];
        }

        private ConfigurationOrigin[] copyOrigins() {
            return (ConfigurationOrigin[])ArrayUtils.copy(this.origins, this.originsCount);
        }

        private void addOrigin(ConfigurationOrigin origin) {
            if (!ArrayUtils.contains(this.origins, this.originsCount, origin)) {
                this.origins = (ConfigurationOrigin[])ArrayUtils.append(ConfigurationOrigin.class, this.origins, this.originsCount++, origin);
            }
        }
    }
}

