/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SharedCodeSource;

public abstract class ClassQuery
extends ClassLoaderQuery {
    private RecoverableByteBuffer buffer;
    private PolicyClassLoader start;
    protected long startTime;
    protected int codeSourcesCount;
    protected int classesCount;
    protected int maxClassSize;
    protected int totalClassSize;
    protected String maxClassName;
    protected Set hits = new HashSet();
    protected String[] sortedHits;
    protected Set errors = new HashSet();
    protected SharedCodeSource currentSource;
    protected String currentClassName;

    public void createQueryReport(String[] args) throws Exception {
        this.startTime = System.currentTimeMillis();
        this.parseArgs(args);
        List sources = this.collectCodeSources();
        this.collectHits(sources);
        this.sortHits();
        this.buildReport();
        if (this.buffer != null) {
            this.buffer.recover(0, true);
        }
    }

    protected abstract void visitArgument(String var1);

    protected abstract void prepare();

    protected abstract boolean shouldVisitClass(String var1);

    protected abstract void visitClass(String var1, byte[] var2, int var3) throws Exception;

    protected abstract void buildReport();

    protected void sortHits() {
        this.sortedHits = new String[this.hits.size()];
        this.hits.toArray(this.sortedHits);
        Arrays.sort(this.sortedHits);
    }

    private void collectHits(List sources) {
        for (SharedCodeSource cs : sources) {
            try {
                this.check(cs);
            }
            catch (Exception e) {
                this.hits.add("(Caught " + e + " checking " + ClassQuery.getDisplayPath(cs) + ")");
            }
        }
    }

    private void check(SharedCodeSource source) throws Exception {
        ++this.codeSourcesCount;
        this.currentSource = source;
        String[] paths = source.listFilePaths();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (!path.endsWith(".class")) continue;
            this.currentClassName = path.replace('/', '.').substring(0, path.length() - 6);
            if (!this.shouldVisitClass(this.currentClassName)) continue;
            RecoverableByteBuffer buf = source.getResourceBytes(path, this.buffer);
            if (buf == null) {
                throw new InternalError("buffer was null!");
            }
            this.buffer = buf;
            byte[] classData = buf.getArray();
            int classSize = buf.getBytesUsed();
            ++this.classesCount;
            this.totalClassSize += classSize;
            if (classSize > this.maxClassSize) {
                this.maxClassSize = classSize;
                this.maxClassName = this.currentClassName;
            }
            try {
                this.visitClass(this.currentClassName, classData, classSize);
                continue;
            }
            catch (Exception e) {
                this.errors.add("Caught " + e + " checking " + this.currentClassName + " in " + ClassQuery.getDisplayPath(source));
            }
        }
    }

    private List collectCodeSources() {
        if (this.start == null) {
            return ClassQuery.getAllCodeSourcesInScope(ClassLoaderScope.GLOBAL);
        }
        List sources = ClassQuery.getCodeSourcesVisibleTo(this.start, true);
        ClassQuery.removeCodeSourcesAboveScope(ClassLoaderScope.GLOBAL, sources);
        return sources;
    }

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            this.start = ClassQuery.findLoader(arg);
            if (this.start != null) continue;
            this.visitArgument(arg);
        }
        this.prepare();
    }
}

