/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.query.ReportQuery;

public class FindCodeSource
extends ReportQuery {
    private String pattern;
    private boolean all;
    private Pattern regex;

    public String getDescription() {
        return "List the code-sources whose path contains the specified pattern.\n\nArgs: [pattern]\n\nIf 'pattern' begins with a '~' it is treated as a regular expression; otherwise it is treated as a simple substring. If pattern is '*' or no pattern is specified, will list all known code-sources.\n";
    }

    public void createQueryReport(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("*")) {
            this.all = true;
            this.pattern = "*";
        } else {
            this.pattern = args[0];
            if (this.pattern.charAt(0) == '~') {
                this.regex = Pattern.compile(this.pattern.substring(1));
            } else {
                if (this.pattern.charAt(0) == '*') {
                    this.pattern = this.pattern.substring(1);
                }
                if (this.pattern.endsWith("*")) {
                    this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
                }
            }
        }
        int lineNumber = 1;
        List sources = this.getMatchingCodeSources();
        int count = sources.size();
        if (count == 0) {
            this.append("No code-sources");
        } else if (count == 1) {
            this.append("Found code-source");
        } else {
            this.append("Found code-sources");
        }
        this.append(" matching '");
        this.append(this.pattern);
        this.appendln(count == 0 ? "'." : "':");
        this.appendln();
        for (SharedCodeSource source : sources) {
            this.appendLineNumber(lineNumber++);
            this.appendCodeSource(source);
            this.appendln();
        }
    }

    private List getMatchingCodeSources() {
        List sources = ClassLoaderQuery.getAllCodeSources();
        ArrayList<SharedCodeSource> result = new ArrayList<SharedCodeSource>();
        for (SharedCodeSource source : sources) {
            String path = source.getLocation().getPath();
            if (!this.matches(path)) continue;
            result.add(source);
        }
        return result;
    }

    private boolean matches(String codeSourcePath) {
        if (this.all) {
            return true;
        }
        if (this.regex == null) {
            return codeSourcePath.indexOf(this.pattern) >= 0;
        }
        return this.regex.matcher(codeSourcePath).matches();
    }

    protected void appendCodeSource(SharedCodeSource source) {
        this.appendDisplayPath(source);
    }
}

