/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassDependencies;

public class LoadClass
extends ClassLoaderQuery {
    private static final String[] IGNORE_PACKAGES = new String[]{"java."};
    private String className;
    private PolicyClassLoader loader;
    private boolean useClassForName;
    private boolean checkDependencies;
    private boolean recurse;
    private boolean sort;
    private boolean invokeMain;

    public String getDescription() {
        return "Call loadClass() or Class.forName() using a specified loader and report the results.\n\nArgs: className [loaderName] [-forName] [-depends] [-r] [-sort]\n\nUses loadClass() unless -forName is specified. Uses the default app root loader if not specified. If -depends is specified, all direct dependencies of the class will be loaded and listed. Use -r to recursively load all dependencies (will not recurse into java.* classes). Use -sort to sort the dependency list by class name.";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.parseArgs(args);
        if (this.useClassForName) {
            this.append("Calling Class.forName(\"");
            this.append(this.className);
            this.append("\", true, ");
            this.append(this.loader.getDisplayName());
            this.append(")");
        } else {
            this.append("Calling loadClass(\"");
            this.append(this.className);
            this.append("\") on ");
            this.append(this.loader.getDisplayName());
        }
        try {
            List list = LoadClass.load(this.className, this.loader, this.useClassForName, this.checkDependencies, this.recurse, this.sort, this.invokeMain);
            this.appendln(" returned:");
            this.appendln();
            Class clz = (Class)list.get(0);
            this.append("          Class: ");
            this.appendClass(clz);
            this.appendln();
            this.append("Defining loader: ");
            this.appendLoader(clz);
            this.appendln();
            this.append("    Code-Source: ");
            this.appendCodeSource(clz);
            this.appendln();
            int size = list.size();
            if (size > 1) {
                this.appendln();
                if (this.recurse) {
                    this.appendln("All dependencies ('java.*' only if direct dependencies):");
                } else {
                    this.appendln("Direct dependencies:");
                }
                this.appendln();
                for (int i = 1; i < size; ++i) {
                    this.indentLineNumber(i);
                    clz = (Class)list.get(i);
                    this.appendClass(clz);
                    this.append(". Loader: ");
                    this.appendLoader(clz);
                    this.append(". Code-Source: ");
                    this.appendCodeSource(clz);
                    this.appendln();
                }
            }
            this.appendln();
        }
        catch (Throwable e) {
            this.appendln(" failed: ");
            this.appendln();
            this.appendln(e.toString());
        }
    }

    protected void appendClass(Class clz) {
        this.append(clz.getName());
    }

    protected void appendLoader(Class clz) {
        this.append(LoadClass.getLoaderNameFor(clz));
    }

    protected void appendCodeSource(Class clz) {
        this.append(LoadClass.getCodeSourceDescriptionFor(clz));
    }

    public static List load(String className, PolicyClassLoader loader, boolean useClassForName, boolean checkDependencies, boolean recurse, boolean sort, boolean invokeMain) throws Exception {
        ArrayList<Class> result = new ArrayList<Class>();
        Class clz = null;
        clz = useClassForName ? Class.forName(className, true, loader) : loader.loadClass(className);
        if (invokeMain) {
            Method main = clz.getDeclaredMethod("main", String[].class);
            main.invoke(null, new Object[]{new String[0]});
        }
        result.add(clz);
        if (checkDependencies) {
            List deps = ClassDependencies.getDependencies(className, loader, recurse, IGNORE_PACKAGES);
            for (String name : deps) {
                clz = loader.loadClass(name);
                result.add(clz);
            }
        }
        if (sort) {
            Collections.sort(result, new ClassNameComparator());
        }
        return result;
    }

    private void parseArgs(String[] args) {
        this.className = args[0];
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-forName")) {
                this.useClassForName = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-depends")) {
                this.checkDependencies = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-r")) {
                this.checkDependencies = true;
                this.recurse = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-sort")) {
                this.sort = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-invokeMain")) {
                this.invokeMain = true;
                continue;
            }
            this.loader = LoadClass.findLoader(args[1]);
            if (this.loader != null) continue;
            throw new IllegalArgumentException("Loader \"" + args[1] + "\" not found.");
        }
        if (this.loader == null) {
            this.loader = LoadClass.findLoader("default.root");
            if (this.loader == null) {
                this.loader = LoadClass.getMainLoader();
            }
        }
    }

    public static class ClassNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String name1 = ((Class)o1).getName();
            String name2 = ((Class)o2).getName();
            return name1.compareTo(name2);
        }
    }
}

