/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.List;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;

public class LoadedClasses
extends ClassLoaderQuery {
    public String getDescription() {
        return "List the names of all loaded classes (if available).";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.reportLoadedClasses();
    }

    private void reportAvailableClasses() throws Exception {
        List codeSources = LoadedClasses.getAllCodeSources();
        for (SharedCodeSource cs : codeSources) {
            String[] filePaths = cs.listFilePaths();
            for (int i = 0; i < filePaths.length; ++i) {
                String filePath = filePaths[i];
                if (!filePath.endsWith(".class")) continue;
                String className = filePath.substring(0, filePath.length() - 6);
                className = className.replaceAll("/", "\\.");
                this.appendln(className);
            }
        }
    }

    private void reportLoadedClasses() throws Exception {
        for (PolicyClassLoader loader : LoadedClasses.getAllLoaders()) {
            for (Class loadedClass : LoadedClasses.getLoadedClasses(loader)) {
                this.appendln(loadedClass.getName());
            }
        }
    }
}

