/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.Collection;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.PolicyClassLoaderSet;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SubscriberSet;
import oracle.classloader.util.ClassLoadMonitor;

public class LoaderTree
extends ClassLoaderQuery {
    private static final int BUFFER_SIZE = 262144;
    private static final char[] CODE_SOURCE_STATES = new char[]{'.', '-', '+', '*', '!', '~'};
    private PolicyClassLoader root;
    private boolean verbose;
    private static final String EMPTY = "   ";
    private static final String LINE = " | ";
    private static final String JOIN = " +-";
    private static final String JOIN_BOTTOM = " +-";

    public String getDescription() {
        return "List the class loader tree.\n\nArgs: [rootLoaderName] [-verbose]\n\nSpecify a root loader name to list only that loader and it's children; defaults to the jre.bootstrap loader.";
    }

    public void createQueryReport(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-v") || arg.equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            this.root = LoaderTree.findLoader(args[0]);
            if (this.root != null) continue;
            throw new IllegalArgumentException("Loader \"" + args[0] + "\" not found.");
        }
        StringBuffer buffer = this.getReportBuffer();
        buffer.ensureCapacity(262144);
        LoaderTree.appendTree(this.root, this.verbose, buffer);
        this.appendln();
    }

    public static String getLoaderTreeAsString(PolicyClassLoader root, boolean verbose) {
        StringBuffer buffer = new StringBuffer(262144);
        LoaderTree.appendTree(root, verbose, buffer);
        return buffer.toString();
    }

    private static void appendTree(PolicyClassLoader rootLoader, boolean verbose, StringBuffer buffer) {
        PolicyClassLoaderSet.doPeriodicMaintenance(ClassLoadMonitor.getLastMaintenanceTick());
        if (rootLoader == null) {
            rootLoader = LoaderTree.getRootLoader();
        }
        boolean[] parentDepth = new boolean[128];
        LoaderTree.appendLoaderInfo(buffer, verbose, rootLoader, false, parentDepth, 0);
    }

    private static void appendLoaderInfo(StringBuffer buffer, boolean verbose, PolicyClassLoader loader, boolean parentsLastChild, boolean[] parentDepth, int depth) {
        LoaderTree.newLine(buffer, parentDepth, depth);
        LoaderTree.newNodeLine(buffer, parentDepth, depth, parentsLastChild);
        if (verbose) {
            buffer.append("Name: ");
        }
        buffer.append(loader.getDisplayName());
        if (loader == ClassLoader.getSystemClassLoader()) {
            buffer.append(" (returned by ClassLoader.getSystemClassLoader())");
        }
        if (verbose) {
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Parent: ");
            String parentName = "none";
            PolicyClassLoader parent = loader.parent();
            if (parent != null) {
                parentName = parent.getDisplayName();
            }
            buffer.append(parentName);
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Scope: ");
            buffer.append(loader.getScope());
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Creator: ");
            StackTraceElement[] trace = loader.getCreationStack();
            for (int i = 0; i < trace.length; ++i) {
                LoaderTree.newLineIndent(buffer, parentDepth, depth);
                buffer.append(trace[i].toString());
            }
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Search-Policy: ");
            buffer.append(loader.getSearchPolicy());
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Supported-Configurations: ");
            ConfigurationType[] configs = loader.getConfigurationPolicy().getTypes();
            for (int i = 0; i < configs.length; ++i) {
                LoaderTree.newLineIndent(buffer, parentDepth, depth);
                buffer.append(configs[i].toString());
            }
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Buffer-Size: ");
            buffer.append(loader.getBufferSize());
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Code-Sources:");
            LoaderTree.appendCodeSources(buffer, parentDepth, depth, loader.getCodeSources(true), loader);
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Native-Code-Sources:");
            LoaderTree.appendCodeSources(buffer, parentDepth, depth, loader.getNativeCodeSources(), loader);
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Imported-Shared-Libraries:");
            PolicyClassLoader[] shared = loader.getImports();
            if (shared != null) {
                for (int i = 0; i < shared.length; ++i) {
                    LoaderTree.newLineIndent(buffer, parentDepth, depth);
                    buffer.append(shared[i].getDisplayName());
                }
            }
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Loaded-Packages: ");
            try {
                LoaderTree.appendCollection(buffer, parentDepth, depth, LoaderTree.getLoadedPackages(loader).keySet());
            }
            catch (Exception e1) {
                buffer.append("Cannot access. Caught " + e1.toString());
            }
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Loaded-Classes: ");
            try {
                LoaderTree.appendCollection(buffer, parentDepth, depth, LoaderTree.getLoadedClasses(loader));
            }
            catch (Exception e1) {
                buffer.append("Cannot access. Caught " + e1.toString());
            }
        }
        if (verbose) {
            LoaderTree.newLine(buffer, parentDepth, depth);
            buffer.append("Children:");
        }
        if (parentsLastChild) {
            parentDepth[depth - 1] = true;
        }
        PolicyClassLoader[] children = loader.getChildren();
        int childCount = children.length;
        int lastChild = childCount - 1;
        for (int i = 0; i < childCount; ++i) {
            PolicyClassLoader child = children[i];
            if (child == null) continue;
            LoaderTree.appendLoaderInfo(buffer, verbose, child, i == lastChild, parentDepth, depth + 1);
        }
        parentDepth[depth] = false;
    }

    private static void appendCollection(StringBuffer buffer, boolean[] parentDepth, int depth, Collection c) {
        int index = 0;
        for (Object o : c) {
            LoaderTree.newLineIndent(buffer, parentDepth, depth);
            buffer.append(++index);
            buffer.append(". ");
            buffer.append(o.toString());
        }
    }

    private static void appendCodeSources(StringBuffer buffer, boolean[] parentDepth, int depth, SharedCodeSource[] sources, PolicyClassLoader loader) {
        buffer.append(" (# of subscribers) '.' = created, '-' = closed, '+' = open, '*' = suspended, '!' = orphaned");
        if (sources != null) {
            for (int i = 0; i < sources.length; ++i) {
                SharedCodeSource source = sources[i];
                SubscriberSet subscribers = source.getSubscribers();
                LoaderTree.newLineIndent(buffer, parentDepth, depth);
                buffer.append(i);
                buffer.append(". (");
                buffer.append(subscribers.getCount());
                buffer.append(')');
                buffer.append(CODE_SOURCE_STATES[source.getState()]);
                buffer.append(' ');
                String path = source.getLocation().getPath();
                SharedCodeSource.append(path, subscribers.getOriginsFor(loader), buffer);
            }
        }
    }

    private static void newLineIndent(StringBuffer buffer, boolean[] parentDepth, int depth) {
        LoaderTree.newLine(buffer, parentDepth, depth);
        buffer.append("    ");
    }

    private static void newNodeLine(StringBuffer buffer, boolean[] parentDepth, int depth, boolean parentsLastChild) {
        if (depth > 0) {
            buffer.append(EOL);
        }
        LoaderTree.indent(buffer, parentDepth, depth - 1);
        if (depth > 0) {
            if (parentsLastChild) {
                buffer.append(" +-");
            } else {
                buffer.append(" +-");
            }
        }
    }

    private static void indent(StringBuffer buffer, boolean[] parentDepth, int depth) {
        for (int i = 0; i < depth; ++i) {
            if (parentDepth[i]) {
                buffer.append(EMPTY);
                continue;
            }
            buffer.append(LINE);
        }
    }

    private static void newLine(StringBuffer buffer, boolean[] parentDepth, int depth) {
        buffer.append(EOL);
        LoaderTree.indent(buffer, parentDepth, depth);
    }
}

