/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.query.Query;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ClassLoadTracing;

public class QueryProcessor {
    private static boolean shouldExit;
    private static boolean started;

    public static Serializable executeQuery(String queryClassName, String[] arguments) {
        try {
            Query query = QueryProcessor.loadQuery(queryClassName);
            if (arguments == null) {
                arguments = new String[]{};
            }
            return query.execute(arguments);
        }
        catch (Throwable e) {
            return e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Serializable executeQuery(String querySpec) {
        String[] arguments;
        String className;
        int index = querySpec.indexOf(40);
        if (index >= 0) {
            className = querySpec.substring(0, index);
            int length = querySpec.length();
            if (!querySpec.endsWith(")")) return new IllegalArgumentException(querySpec);
            StringTokenizer st = new StringTokenizer(querySpec.substring(index + 1, length - 1), ",");
            int count = st.countTokens();
            arguments = new String[count];
            index = 0;
            while (st.hasMoreTokens()) {
                arguments[index++] = st.nextToken().trim();
            }
            return QueryProcessor.executeQuery(className, arguments);
        } else {
            className = querySpec;
            arguments = new String[]{};
        }
        return QueryProcessor.executeQuery(className, arguments);
    }

    public static Serializable[] executeQueries(String querySpecs) {
        ArrayList<Serializable> results = new ArrayList<Serializable>();
        StringTokenizer specs = new StringTokenizer(querySpecs, "+");
        while (specs.hasMoreTokens()) {
            String spec = specs.nextToken().trim();
            try {
                Serializable result = QueryProcessor.executeQuery(spec);
                results.add(result);
            }
            catch (Exception e) {
                results.add(e);
            }
        }
        return (Serializable[])ArrayUtils.toArray(Serializable.class, results, true);
    }

    public static boolean executeTransferQueries(Logger log) {
        return QueryProcessor.executeQueries(ClassLoadEnvironment.getTransferQuery(), log);
    }

    public static void executeStartupQueries() {
        QueryProcessor.executeStartupQueries(ClassLoadLogger.getLogger());
    }

    public static synchronized void executeStartupQueries(Logger log) {
        started = true;
        if (log.isLoggable(Level.FINE)) {
            StringBuilder builder = new StringBuilder();
            builder.append("Startup completed. Uptime: ");
            builder.append(ClassLoadTracing.getUpTime());
            builder.append("ms.");
            log.log(Level.FINE, builder.toString());
            for (Handler h : log.getHandlers()) {
                h.flush();
            }
        }
        QueryProcessor.executeQueries(ClassLoadEnvironment.getStartQuery(), log);
    }

    public static synchronized boolean hasStarted() {
        return started;
    }

    public static synchronized boolean shouldExit() {
        return shouldExit;
    }

    public static synchronized void setShouldExit(boolean exit) {
        shouldExit = exit;
    }

    public static boolean executeQueries(String query, Logger log) {
        if (query != null) {
            Serializable[] results = QueryProcessor.executeQueries(query);
            for (int i = 0; i < results.length; ++i) {
                Serializable result = results[i];
                if (result instanceof Throwable) {
                    log.log(Level.SEVERE, "", (Throwable)result);
                    continue;
                }
                if (result == null) continue;
                log.info(result.toString());
            }
            QueryProcessor.flush(log);
            return true;
        }
        return false;
    }

    private static void flush(Logger log) {
        Handler[] handlers = log.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].flush();
        }
    }

    public static Query loadQuery(String queryClassName) throws Exception {
        Class queryClass = QueryProcessor.loadQueryClass(queryClassName, true);
        return (Query)queryClass.newInstance();
    }

    public static Class loadQueryClass(String queryClassName, boolean allowAlias) throws Exception {
        try {
            return ClassLoadEnvironment.loadQueryClass(ClassLoaderQuery.getMainLoader(), queryClassName, allowAlias);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return ClassLoadEnvironment.loadQueryClass(Thread.currentThread().getContextClassLoader(), queryClassName, allowAlias);
    }

    public static synchronized Object executeQuery(String queryClassName, byte[] queryClassData, String[] arguments) {
        Object result = null;
        PolicyClassLoader loader = null;
        try {
            loader = ClassLoadEnvironment.createQueryLoader();
            if (loader != null) {
                loader.commit();
                URL url = new URL("code-source://classLoading.executeQuery");
                ProtectionPolicy protection = ProtectionPolicy.MAIN_PERMISSIONS;
                Class queryClass = loader.defineClass(queryClassName, url, null, protection, queryClassData, 0, queryClassData.length);
                Query query = (Query)queryClass.newInstance();
                if (arguments == null) {
                    arguments = new String[]{};
                }
                result = query.execute(arguments);
            } else {
                result = "Unsupported operation.";
            }
        }
        catch (Throwable e) {
            result = e;
        }
        if (loader != null) {
            loader.close();
        }
        return result;
    }
}

