/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.classloader.ClassLoaderFilters;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ArrayUtils;

public class SharedLibraries
extends ClassLoaderQuery {
    private List systemLoaders = Collections.EMPTY_LIST;
    private List appLoaders = Collections.EMPTY_LIST;

    public String getDescription() {
        return "List shared-libraries and the loaders that have imported them.\n\nArgs: [loaderName]\n\nSpecify a loader name to list only that loader. See also: LoaderTree.";
    }

    public void createQueryReport(String[] args) throws Exception {
        this.parseArgs(args);
        int lineNumber = 1;
        for (PolicyClassLoader loader : this.systemLoaders) {
            this.appendLoader(lineNumber++, loader, true);
        }
        for (PolicyClassLoader loader : this.appLoaders) {
            this.appendLoader(lineNumber++, loader, false);
        }
    }

    private void appendLoader(int lineNumber, PolicyClassLoader loader, boolean system) {
        if (lineNumber > 1) {
            this.appendln();
        }
        this.appendLineNumber(lineNumber);
        if (system) {
            this.append("System");
        } else {
            this.append("Application");
        }
        this.append(" shared-library \"");
        this.append(loader.getDisplayName());
        this.append("\" (parent = ");
        this.append(loader.parent().getDisplayName());
        this.appendln(')');
        this.indent();
        this.appendln("Code-sources:");
        SharedCodeSource[] sources = loader.getCodeSources(true);
        if (sources.length > 0) {
            for (int i = 0; i < sources.length; ++i) {
                SharedCodeSource source = sources[i];
                this.indent();
                this.indentLineNumber(i + 1);
                this.appendln(source.getLocation().getPath());
            }
        } else {
            this.indent(2);
            this.appendln("none");
        }
        this.indent();
        this.appendln("Imports:");
        PolicyClassLoader[] imports = loader.getImports();
        if (imports != null) {
            for (int i = 0; i < imports.length; ++i) {
                PolicyClassLoader imp = imports[i];
                this.indent();
                this.indentLineNumber(i + 1);
                this.appendln(imp.getDisplayName());
            }
        } else {
            this.indent(2);
            this.appendln("none");
        }
        this.indent();
        this.appendln("Imported by:");
        Object[] subs = loader.getSubscribers().getSubscribers();
        subs = (PolicyClassLoader[])ArrayUtils.copyAndCompress(subs, subs.length);
        if (subs.length > 1) {
            for (int i = 0; i < subs.length; ++i) {
                Object sub = subs[i];
                if (sub == null) continue;
                this.indent();
                this.indentLineNumber(i + 1);
                this.appendln(((PolicyClassLoader)sub).getDisplayName());
            }
        } else {
            this.indent(2);
            this.appendln("none");
        }
    }

    private void parseArgs(String[] args) {
        ArrayList<PolicyClassLoader> loaders = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            PolicyClassLoader shared = SharedLibraries.findLoader(arg);
            if (shared == null) {
                throw new IllegalArgumentException("Shared-library \"" + arg + "\" not found.");
            }
            if (!shared.isSharedLoader()) {
                throw new IllegalArgumentException("Loader \"" + arg + "\" is not shared.");
            }
            if (loaders == null) {
                loaders = new ArrayList<PolicyClassLoader>();
            }
            loaders.add(shared);
        }
        if (loaders == null) {
            loaders = SharedLibraries.getAllLoaders(ClassLoaderFilters.SHARED);
        }
        for (PolicyClassLoader loader : loaders) {
            if (loader.isSystemSharedLoader()) {
                if (this.systemLoaders == Collections.EMPTY_LIST) {
                    this.systemLoaders = new ArrayList();
                }
                this.systemLoaders.add(loader);
                continue;
            }
            if (this.appLoaders == Collections.EMPTY_LIST) {
                this.appLoaders = new ArrayList();
            }
            this.appLoaders.add(loader);
        }
    }
}

