/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import oracle.classloader.util.FileUtils;

public class ManifestState {
    private static final Set<File> VISITED = new HashSet<File>();
    private static final String[] EMPTY = new String[0];
    private static int actualMaxDepth;
    private File referencingJarFile;
    private File baseDir;
    private String relativeJarPath;
    private File jarFile;
    private boolean duplicate;
    private int depth;
    private boolean exists;
    private Manifest manifest;
    private String[] classPath;
    private ManifestState[] children;
    private IOException failure;

    public ManifestState(File jar, int maxDepth) {
        this(jar, null, maxDepth, 0);
    }

    public IOException getFailure() {
        return this.failure;
    }

    public boolean doesExist() {
        return this.exists;
    }

    public File getReferencingJarFile() {
        return this.referencingJarFile;
    }

    public String getRelativeJarPath() {
        return this.relativeJarPath;
    }

    public String getAbsoluteJarPath() {
        return this.jarFile.getPath();
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public int getDepth() {
        return this.depth;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public String[] getClassPath() {
        return this.classPath;
    }

    public ManifestState[] getChildren() {
        return this.children;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public static int getActualMaxDepth() {
        return actualMaxDepth;
    }

    private ManifestState(File jar, String relativeJarPath, int maxDepth, int depth) {
        if (depth > actualMaxDepth) {
            actualMaxDepth = depth;
        }
        this.relativeJarPath = relativeJarPath;
        this.referencingJarFile = jar;
        this.baseDir = jar.getParentFile();
        if (relativeJarPath != null) {
            jar = new File(this.baseDir, relativeJarPath).getAbsoluteFile();
        }
        this.jarFile = FileUtils.canonicalizeFileExceptForLinks(jar);
        this.exists = this.jarFile.exists();
        if (VISITED.contains(this.jarFile)) {
            this.duplicate = true;
        } else {
            VISITED.add(this.jarFile);
            this.duplicate = false;
            this.depth = depth;
            try {
                if (this.exists) {
                    this.manifest = new JarFile(this.jarFile).getManifest();
                    if (this.manifest != null) {
                        this.classPath = ManifestState.getManifestClassPath(this.manifest);
                        if (depth < maxDepth && this.classPath.length > 0) {
                            this.addChildren(maxDepth, depth);
                        }
                    }
                }
            }
            catch (IOException e) {
                this.failure = e;
            }
        }
    }

    private void addChildren(int maxDepth, int depth) {
        ArrayList<ManifestState> list = new ArrayList<ManifestState>();
        for (int i = 0; i < this.classPath.length; ++i) {
            String relativePath = this.classPath[i];
            ManifestState state = new ManifestState(this.jarFile, relativePath, maxDepth, depth + 1);
            if (state.isDuplicate()) continue;
            list.add(state);
        }
        int count = list.size();
        if (count > 0) {
            this.children = new ManifestState[count];
            list.toArray(this.children);
        }
    }

    private static String[] getManifestClassPath(Manifest manifest) {
        String classPath;
        Attributes attributes;
        String[] result = EMPTY;
        if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (classPath = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
            StringTokenizer st = new StringTokenizer(classPath);
            result = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                result[i] = st.nextToken();
                ++i;
            }
        }
        return result;
    }
}

