/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.classloader.tools.ManifestClassPathFormatter;
import oracle.classloader.tools.ManifestClassPathListFormatter;
import oracle.classloader.tools.ManifestFormatter;
import oracle.classloader.tools.ManifestTreeFormatter;

public class ManifestTool {
    private static final ManifestFormatter[] FORMATTERS = new ManifestFormatter[]{new ManifestTreeFormatter(), new ManifestClassPathFormatter(), new ManifestClassPathListFormatter()};
    private static final Map<String, ManifestFormatter> FORMATS = new HashMap<String, ManifestFormatter>();
    private static final String USAGE_1 = ManifestFormatter.EOL + "Usage: [-r(ecursive)] [<format> [<format options>]] jarPath ..." + ManifestFormatter.EOL + ManifestFormatter.EOL + "Available formats are:" + ManifestFormatter.EOL + ManifestFormatter.EOL;
    private static final String USAGE_2 = ManifestFormatter.EOL + "Default format is '" + FORMATTERS[0].formatOption() + "'. (v0.2)" + ManifestFormatter.EOL;
    private ManifestFormatter formatter = FORMATTERS[0];
    private File[] jars;
    private boolean recurse;

    public static void main(String[] args) {
        try {
            ManifestTool tool = new ManifestTool(args);
            String result = tool.format();
            System.out.println(result);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    private ManifestTool(String[] args) throws Exception {
        this.parseArgs(args);
    }

    private String format() {
        return this.formatter.format(this.jars, this.recurse ? Integer.MAX_VALUE : 1);
    }

    private void parseArgs(String[] args) {
        ArrayList<File> list = new ArrayList<File>();
        if (args.length == 0) {
            this.usage(null);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.startsWith("-r")) {
                    this.recurse = true;
                    continue;
                }
                ManifestFormatter format = FORMATS.get(arg);
                if (format != null) {
                    this.formatter = format;
                    continue;
                }
                if (this.formatter.checkArgument(arg)) continue;
                this.usage(arg);
                continue;
            }
            File jar = new File(arg).getAbsoluteFile();
            if (!jar.exists()) {
                throw new IllegalArgumentException(jar + " does not exist.");
            }
            list.add(jar);
        }
        int count = list.size();
        this.jars = new File[count];
        list.toArray(this.jars);
    }

    private void usage(String unknownArg) {
        StringBuilder builder = new StringBuilder();
        if (unknownArg != null) {
            builder.append("Unknown argument: ");
            builder.append(unknownArg);
            builder.append(ManifestFormatter.EOL);
        }
        builder.append(USAGE_1);
        for (int i = 0; i < FORMATTERS.length; ++i) {
            ManifestFormatter format = FORMATTERS[i];
            builder.append("    ");
            builder.append(format.formatOption());
            builder.append(" ");
            builder.append(format.options());
            builder.append(ManifestFormatter.EOL);
        }
        builder.append(USAGE_2);
        throw new IllegalArgumentException(builder.toString());
    }

    static {
        for (int i = 0; i < FORMATTERS.length; ++i) {
            ManifestFormatter formatter = FORMATTERS[i];
            FORMATS.put(formatter.formatOption(), formatter);
        }
    }
}

