/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassLoadLogger;

public class ApplicationLogManager
extends LogManager {
    private static String WARNING = "ApplicationLogManager is not installed, may result in loader leaks. Set -Djava.util.logging.manager=oracle.classloader.util.ApplicationLogManager";
    private static Map applicationLoggers;

    public static void checkInstalled() {
        if (ApplicationLogManager.class.getName().equals(System.getProperty("java.util.logging.manager"))) {
            try {
                Field managerField = LogManager.class.getDeclaredField("manager");
                managerField.setAccessible(true);
                Object manager = managerField.get(null);
                if (!(manager instanceof ApplicationLogManager)) {
                    ClassLoadLogger.log(Level.WARNING, WARNING);
                }
            }
            catch (Throwable t) {
                ClassLoadLogger.log(Level.FINE, "Could not check ApplicationLogManager: " + t);
            }
        }
    }

    public synchronized boolean addLogger(Logger logger) {
        ClassLoader loader;
        boolean isNewLogger = super.addLogger(logger);
        if (isNewLogger && (loader = Thread.currentThread().getContextClassLoader()) instanceof PolicyClassLoader && ((PolicyClassLoader)loader).isApplicationLoader()) {
            if (applicationLoggers == null) {
                applicationLoggers = Collections.synchronizedMap(new HashMap());
            }
            applicationLoggers.put(logger, loader);
        }
        return isNewLogger;
    }

    public static Map getApplicationLoggers() {
        return applicationLoggers;
    }

    public static void removeApplicationLoggerFromList(Logger logger) {
        applicationLoggers.remove(logger);
        ApplicationLogManager.close(logger);
    }

    public static void flush(Logger logger) {
        if (logger != null) {
            for (Handler h : logger.getHandlers()) {
                h.flush();
            }
        }
    }

    public static void close(Logger logger) {
        if (logger != null) {
            for (Handler h : logger.getHandlers()) {
                logger.removeHandler(h);
                h.close();
            }
        }
    }
}

