/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Collection;

public class ArrayUtils {
    public static Object[] append(Class arrayType, Object[] array, int inUseCount, Object newElement) {
        if (array == null) {
            array = (Object[])Array.newInstance(arrayType, 8);
        } else {
            int length = array.length;
            if (length == inUseCount) {
                array = ArrayUtils.grow(arrayType, array, length * 2);
            }
        }
        array[inUseCount] = newElement;
        return array;
    }

    public static Object[] grow(Class arrayType, Object[] array, int newSize) {
        int length = array.length;
        Object[] newArray = (Object[])Array.newInstance(arrayType, newSize);
        System.arraycopy(array, 0, newArray, 0, length);
        return newArray;
    }

    public static Object[] insert(Class arrayType, Object[] array, int inUseCount, Object newElement, int index) {
        if (inUseCount == array.length) {
            array = ArrayUtils.grow(arrayType, array, inUseCount * 2);
        }
        if (index < inUseCount) {
            System.arraycopy(array, index, array, index + 1, inUseCount - index);
        }
        array[index] = newElement;
        return array;
    }

    public static Object[] insertSparse(Class arrayType, Object[] array, Object newElement) {
        int index = 0;
        if (array == null) {
            array = (Object[])Array.newInstance(arrayType, 8);
        } else {
            int length = array.length;
            index = ArrayUtils.indexOf(array, length, null);
            if (index < 0) {
                array = ArrayUtils.grow(arrayType, array, length * 2);
                index = length;
            }
        }
        array[index] = newElement;
        return array;
    }

    public static int remove(Object[] array, int inUseCount, Object element) {
        return ArrayUtils.remove(array, inUseCount, ArrayUtils.indexOf(array, inUseCount, element));
    }

    public static int remove(Object[] array, int inUseCount, int indexToRemove) {
        if (indexToRemove >= 0 && indexToRemove < inUseCount) {
            int shiftCount = inUseCount - indexToRemove - 1;
            if (shiftCount > 0) {
                System.arraycopy(array, indexToRemove + 1, array, indexToRemove, shiftCount);
            }
            array[inUseCount - 1] = null;
            --inUseCount;
        }
        return inUseCount;
    }

    public static boolean removeSparse(Object[] array, Object element) {
        int index;
        if (array != null && (index = ArrayUtils.indexOf(array, array.length, element)) >= 0) {
            array[index] = null;
            return true;
        }
        return false;
    }

    public static boolean contains(Object[] array, int inUseCount, Object element) {
        return ArrayUtils.indexOf(array, inUseCount, element) >= 0;
    }

    public static int indexOf(Object[] array, int inUseCount, Object element) {
        if (array != null) {
            for (int i = 0; i < inUseCount; ++i) {
                if (array[i] != element) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfFirstValid(Object[] array, int inUseCount) {
        if (array != null) {
            for (int i = 0; i < inUseCount; ++i) {
                if (array[i] == null) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfLastValid(Object[] array, int inUseCount) {
        if (array != null) {
            for (int i = inUseCount - 1; i >= 0; --i) {
                if (array[i] == null) continue;
                return i;
            }
        }
        return -1;
    }

    public static Object[] copy(Object[] array, int inUseCount) {
        Object[] result = null;
        if (array != null) {
            if (array.length == inUseCount) {
                result = (Object[])array.clone();
            } else {
                result = (Object[])Array.newInstance(array.getClass().getComponentType(), inUseCount);
                if (inUseCount > 0) {
                    System.arraycopy(array, 0, result, 0, inUseCount);
                }
            }
        }
        return result;
    }

    public static Object[] copyAndCompress(Object[] array, int inUseCount) {
        Object[] result = null;
        if (array != null) {
            int nullCount = ArrayUtils.countNull(array, inUseCount);
            if (nullCount == 0) {
                return ArrayUtils.copy(array, inUseCount);
            }
            int index = 0;
            int size = inUseCount - nullCount;
            result = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            for (int i = 0; i < inUseCount; ++i) {
                Object element = array[i];
                if (element == null) continue;
                result[index++] = element;
            }
        }
        return result;
    }

    public static int countNonNull(Object[] array, int inUseCount) {
        int count = 0;
        for (int i = 0; i < inUseCount; ++i) {
            if (array[i] == null) continue;
            ++count;
        }
        return count;
    }

    public static int countNull(Object[] array, int inUseCount) {
        int count = 0;
        for (int i = 0; i < inUseCount; ++i) {
            if (array[i] != null) continue;
            ++count;
        }
        return count;
    }

    public static Object[] trim(Object[] array, int inUseCount) {
        Object[] result = array;
        if (array != null && array.length > inUseCount) {
            result = (Object[])Array.newInstance(array.getClass().getComponentType(), inUseCount);
            if (inUseCount > 0) {
                System.arraycopy(array, 0, result, 0, inUseCount);
            }
        }
        return result;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            return ArrayUtils.toString(array, array.length);
        }
        return object.toString();
    }

    public static String toString(Object[] array, int inUseCount) {
        if (array == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        for (int i = 0; i < inUseCount; ++i) {
            Object o;
            if (i > 0) {
                buf.append(", ");
            }
            if ((o = array[i]) == null) {
                buf.append("null");
                continue;
            }
            buf.append(o.toString());
        }
        buf.append('}');
        return buf.toString();
    }

    public static Object[] toArray(Class arrayType, Collection collection, boolean allowEmpty) {
        int count;
        Object[] result = null;
        if (collection != null && ((count = collection.size()) > 0 || allowEmpty)) {
            result = (Object[])Array.newInstance(arrayType, count);
            collection.toArray(result);
        }
        return result;
    }

    public static Object addNonNull(Object[] array, int inUseCount, Collection collection) {
        Object firstDup = null;
        if (array != null) {
            for (int i = 0; i < inUseCount; ++i) {
                Object element = array[i];
                if (element == null || collection.add(element) || firstDup != null) continue;
                firstDup = element;
            }
        }
        return firstDup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream in) throws IOException {
        byte[] result;
        try {
            int bytesRead;
            int readPosition = 0;
            int available = in.available();
            result = new byte[available <= 0 ? 1024 : available];
            while ((bytesRead = in.read(result, readPosition, result.length - readPosition)) >= 0) {
                if ((readPosition += bytesRead) != result.length) continue;
                int peek = in.read();
                if (peek < 0) break;
                byte[] temp = new byte[result.length * 2];
                System.arraycopy(result, 0, temp, 0, readPosition);
                result = temp;
                result[readPosition++] = (byte)peek;
            }
            if (readPosition < result.length) {
                byte[] temp = new byte[readPosition];
                System.arraycopy(result, 0, temp, 0, readPosition);
                result = temp;
            }
        }
        finally {
            in.close();
        }
        return result;
    }
}

