/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.File;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.classloader.util.AnnotationUtils;
import oracle.classloader.util.ApplicationLogManager;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadText;
import oracle.classloader.util.LocalizedText;
import oracle.classloader.util.LogStreamHandler;

public class ClassLoadLogger {
    public static final String EOL = ClassLoadEnvironment.getProperty("line.separator");
    public static final Level DEFAULT_LEVEL = Level.CONFIG;
    private static final String RESOURCE_BUNDLE_NAME = ClassLoadText.class.getName();
    private static volatile Logger logger;
    private static LocalizedText text;

    public static Level setLogLevel(Level newLevel) {
        Level orig = ClassLoadLogger.getLogger().getLevel();
        logger.setLevel(newLevel);
        String levelKey = ClassLoadEnvironment.getLogLevelKey();
        System.setProperty(levelKey, newLevel.getName());
        return orig;
    }

    public static Level setLogLevel(String levelName) {
        return ClassLoadLogger.setLogLevel(Level.parse(levelName));
    }

    public static void resetHandlers(String filePath) {
        String logFileKey = ClassLoadEnvironment.getLogFileKey();
        if (filePath == null || filePath.length() == 0) {
            System.getProperties().remove(logFileKey);
        } else {
            System.setProperty(logFileKey, filePath);
        }
        ClassLoadLogger.resetHandlers();
    }

    public static synchronized void resetHandlers() {
        Logger log = ClassLoadLogger.getLogger();
        for (Handler h : log.getHandlers()) {
            log.removeHandler(h);
            if (!(h instanceof LogStreamHandler)) continue;
            h.close();
        }
        log.setUseParentHandlers(true);
        Handler newHandler = ClassLoadLogger.getLogFileHandler();
        if (newHandler != null) {
            log.addHandler(newHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Logger getLogger() {
        if (logger != null) return logger;
        Class<ClassLoadLogger> clazz = ClassLoadLogger.class;
        synchronized (ClassLoadLogger.class) {
            if (logger == null) {
                logger = ClassLoadLogger.createLogger();
                text = new LocalizedText(RESOURCE_BUNDLE_NAME, logger.getResourceBundle());
                logger.log(Level.FINE, "Class loading logger created.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            ApplicationLogManager.checkInstalled();
            return logger;
        }
    }

    public static boolean willLog(Level level) {
        return ClassLoadLogger.getLogger().isLoggable(level);
    }

    public static void log(Level level, String message) {
        ClassLoadLogger.getLogger().log(level, message);
    }

    public static void log(Level level, String key, Object sub0) {
        Logger logger = ClassLoadLogger.getLogger();
        if (ClassLoadLogger.willLog(level)) {
            String msg = text.getText(key, sub0);
            logger.log(level, msg);
        }
    }

    public static void log(Level level, String key, Object sub0, Object sub1) {
        Logger logger = ClassLoadLogger.getLogger();
        if (ClassLoadLogger.willLog(level)) {
            String msg = text.getText(key, sub0, sub1);
            logger.log(level, msg);
        }
    }

    public static void log(Level level, String key, Object sub0, Object sub1, Object sub2) {
        Logger logger = ClassLoadLogger.getLogger();
        if (ClassLoadLogger.willLog(level)) {
            String msg = text.getText(key, sub0, sub1, sub2);
            logger.log(level, msg);
        }
    }

    public static void log(Level level, String key, Object sub0, Object sub1, Object sub2, Object sub3) {
        Logger logger = ClassLoadLogger.getLogger();
        if (ClassLoadLogger.willLog(level)) {
            String msg = text.getText(key, sub0, sub1, sub2, sub3);
            logger.log(level, msg);
        }
    }

    public static void log(Level level, String key, Object[] subs) {
        Logger logger = ClassLoadLogger.getLogger();
        if (ClassLoadLogger.willLog(level)) {
            String msg = text.getText(key, subs);
            logger.log(level, msg);
        }
    }

    public static void logException(String message, Throwable error, boolean stackTrace) {
        Throwable mapped = AnnotationUtils.mapError(error);
        if (stackTrace) {
            ClassLoadLogger.getLogger().log(Level.SEVERE, message, mapped);
        } else {
            ClassLoadLogger.getLogger().log(Level.SEVERE, message + " Caught " + mapped.toString());
        }
    }

    public static LocalizedText getText() {
        ClassLoadLogger.getLogger();
        return text;
    }

    private static Logger createLogger() {
        String name = ClassLoadEnvironment.getLogName();
        Level level = ClassLoadLogger.getLogLevel();
        Handler handler = ClassLoadLogger.getLogFileHandler();
        Logger logger = Logger.getLogger(name, RESOURCE_BUNDLE_NAME);
        logger.setLevel(level);
        boolean hasValidParent = false;
        int index = name.indexOf(46);
        if (index >= 0) {
            String parentName = name.substring(0, index);
            Logger parent = LogManager.getLogManager().getLogger(parentName);
            if (parent != null) {
                hasValidParent = true;
            }
        }
        if (hasValidParent) {
            logger.setUseParentHandlers(true);
        } else {
            logger.setUseParentHandlers(false);
            if (handler == null) {
                handler = new LogStreamHandler();
            }
        }
        if (handler != null) {
            logger.addHandler(handler);
        }
        return logger;
    }

    private static Level getLogLevel() {
        Level result = DEFAULT_LEVEL;
        String levelKey = ClassLoadEnvironment.getLogLevelKey();
        String levelName = ClassLoadEnvironment.getProperty(levelKey);
        if (levelName != null) {
            if (levelName.equalsIgnoreCase("off")) {
                result = Level.OFF;
            } else if (levelName.equalsIgnoreCase("severe")) {
                result = Level.SEVERE;
            } else if (levelName.equalsIgnoreCase("warning")) {
                result = Level.WARNING;
            } else if (levelName.equalsIgnoreCase("info")) {
                result = Level.INFO;
            } else if (levelName.equalsIgnoreCase("config")) {
                result = Level.CONFIG;
            } else if (levelName.equalsIgnoreCase("fine")) {
                result = Level.FINE;
            } else if (levelName.equalsIgnoreCase("finer")) {
                result = Level.FINER;
            } else if (levelName.equalsIgnoreCase("finest")) {
                result = Level.FINEST;
            } else if (levelName.equalsIgnoreCase("all")) {
                result = Level.ALL;
            } else {
                System.out.println("Unknown log level name: " + levelName + ". Using default.");
            }
        }
        System.setProperty(levelKey, result.toString());
        return result;
    }

    public static void flush() {
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].flush();
        }
    }

    private static Handler getLogFileHandler() {
        LogStreamHandler result = null;
        String logFileKey = ClassLoadEnvironment.getLogFileKey();
        String logFilePath = ClassLoadEnvironment.getProperty(logFileKey);
        if (logFilePath != null && logFilePath.length() > 0) {
            File log = new File(logFilePath);
            if (!log.isAbsolute()) {
                log = log.getAbsoluteFile();
                System.setProperty(logFileKey, log.getPath());
            }
            try {
                result = new LogStreamHandler(log);
            }
            catch (Exception e) {
                String msg = "WARNING: Log file not set: " + e.getMessage();
                System.setProperty(logFileKey, msg);
                System.err.println(msg);
            }
        }
        return result;
    }
}

