/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassSearchListener;
import oracle.classloader.CodeSourceListener;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.EventDispatcher;
import oracle.classloader.ExtensionDeclaration;
import oracle.classloader.ExtensionDependency;
import oracle.classloader.ExtensionDependencyQuery;
import oracle.classloader.LoaderLifeCycleListener;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ResourceSearchListener;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.AnnotatedThrowable;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ExecutionStack;
import oracle.classloader.util.LocalizedText;

public class ClassLoadTracing {
    public static final long BOOT_START_TIME = ClassLoadEnvironment.START_TIME;
    private static LoaderLifeCycleListener loaderLifecycleTracing;
    private static ClassSearchListener classSearchTracing;
    private static ResourceSearchListener resourceSearchTracing;
    private static CodeSourceListener codeSourceLifecycleTracing;
    private static boolean annotate;
    private static boolean addThreadID;
    private static boolean addStack;
    private static boolean addExtendedStack;
    private static boolean addTCL;
    private static boolean addXTCL;
    private static Logger logger;
    private static Level TRACE_LEVEL;

    public static boolean init() {
        ClassLoadLogger.getLogger();
        String options = ClassLoadEnvironment.getTraceOptions();
        return ClassLoadTracing.activate(options);
    }

    public static synchronized boolean activate(String selectors) {
        Filter classFilter = null;
        Filter resourceFilter = null;
        Filter codeSourceFilter = null;
        Filter loaderFilter = null;
        ClassLoadTracing.deactivate();
        if (selectors != null) {
            StringTokenizer st = new StringTokenizer(selectors, "+");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equals("?") || token.equalsIgnoreCase("help")) {
                    ClassLoadTracing.help();
                    return false;
                }
                if (token.equalsIgnoreCase("all") || token.equalsIgnoreCase("true")) {
                    logger.setLevel(Level.ALL);
                    classFilter = Filter.ALL;
                    resourceFilter = Filter.ALL;
                    codeSourceFilter = Filter.ALL;
                    loaderFilter = Filter.ALL;
                    continue;
                }
                if (token.equalsIgnoreCase("thread")) {
                    annotate = true;
                    addThreadID = true;
                    continue;
                }
                if (token.equalsIgnoreCase("stack")) {
                    annotate = true;
                    addStack = true;
                    addExtendedStack = false;
                    continue;
                }
                if (token.equalsIgnoreCase("xstack")) {
                    annotate = true;
                    addStack = false;
                    addExtendedStack = true;
                    continue;
                }
                if (token.equalsIgnoreCase("tcl")) {
                    annotate = true;
                    addTCL = true;
                    addXTCL = false;
                    continue;
                }
                if (token.equalsIgnoreCase("xtcl")) {
                    annotate = true;
                    addTCL = false;
                    addXTCL = true;
                    continue;
                }
                if (token.equalsIgnoreCase("untrusted") || token.equalsIgnoreCase("internal")) {
                    classFilter = Filter.getFilter("class-not-found-untrusted", classFilter);
                    resourceFilter = Filter.getFilter("resource-not-found-untrusted", classFilter);
                    continue;
                }
                if (token.startsWith("class")) {
                    classFilter = Filter.getFilter(token, classFilter);
                    continue;
                }
                if (token.startsWith("resource")) {
                    resourceFilter = Filter.getFilter(token, resourceFilter);
                    continue;
                }
                if (token.startsWith("loader")) {
                    loaderFilter = Filter.getFilter(token, loaderFilter);
                    continue;
                }
                if (token.startsWith("code-source")) {
                    codeSourceFilter = Filter.getFilter(ClassLoadTracing.getCodeSourceFilter(token), codeSourceFilter);
                    continue;
                }
                if (token.equals("none") || token.equals("default")) {
                    logger.setLevel(ClassLoadLogger.DEFAULT_LEVEL);
                    continue;
                }
                String traceKey = ClassLoadEnvironment.getTraceKey();
                System.setProperty(traceKey, "Unsupported option: " + token);
                Object[] args = new String[]{traceKey, token};
                logger.logp(Level.WARNING, (String)null, (String)null, "unsupported.option", args);
                return false;
            }
            if (loaderFilter != null) {
                loaderLifecycleTracing = ClassLoadTracing.createLoaderListener(loaderFilter);
                EventDispatcher.addListener(loaderLifecycleTracing);
            }
            if (classFilter != null) {
                classSearchTracing = ClassLoadTracing.createClassListener(classFilter);
                EventDispatcher.addListener(classSearchTracing);
            }
            if (resourceFilter != null) {
                resourceSearchTracing = ClassLoadTracing.createResourceListener(resourceFilter);
                EventDispatcher.addListener(resourceSearchTracing);
            }
            if (codeSourceFilter != null) {
                codeSourceLifecycleTracing = ClassLoadTracing.createCodeSourceListener(codeSourceFilter);
                EventDispatcher.addListener(codeSourceLifecycleTracing);
            }
        }
        String traceKey = ClassLoadEnvironment.getTraceKey();
        if (selectors == null) {
            System.getProperties().remove(traceKey);
        } else {
            System.setProperty(traceKey, selectors);
        }
        return true;
    }

    private static void help() {
        Object[] args = new String[]{ClassLoadEnvironment.getTraceKey(), ClassLoadEnvironment.getLogLevelKey(), ClassLoadEnvironment.getLogFileKey(), ClassLoadEnvironment.getTransferQueryKey(), ClassLoadEnvironment.getStartQueryKey()};
        LocalizedText text = ClassLoadLogger.getText();
        StringBuilder buf = new StringBuilder(8192);
        buf.append(ClassLoadLogger.EOL);
        buf.append(text.getText("log.usage.0", args));
        buf.append(ClassLoadLogger.EOL);
        buf.append(text.getText("log.usage.1", args));
        buf.append(ClassLoadLogger.EOL);
        buf.append(text.getText("log.usage.2", args));
        logger.setLevel(Level.INFO);
        logger.log(Level.INFO, buf.toString());
    }

    public static synchronized void deactivate() {
        System.getProperties().remove(ClassLoadEnvironment.getTraceKey());
        if (loaderLifecycleTracing != null) {
            EventDispatcher.removeListener(loaderLifecycleTracing);
        }
        if (classSearchTracing != null) {
            EventDispatcher.removeListener(classSearchTracing);
        }
        if (resourceSearchTracing != null) {
            EventDispatcher.removeListener(resourceSearchTracing);
        }
        if (codeSourceLifecycleTracing != null) {
            EventDispatcher.removeListener(codeSourceLifecycleTracing);
        }
        annotate = false;
        addThreadID = false;
        addStack = false;
        addExtendedStack = false;
        addTCL = false;
        addXTCL = false;
    }

    public static LoaderLifeCycleListener createLoaderListener(Filter filter) {
        return new LoaderListener(filter);
    }

    public static ClassSearchListener createClassListener(Filter filter) {
        return new ClassListener(filter);
    }

    public static ResourceSearchListener createResourceListener(Filter filter) {
        return new ResourceListener(filter);
    }

    public static CodeSourceListener createCodeSourceListener(Filter filter) {
        return new SourceListener(filter);
    }

    static void setLogger(Logger logger) {
        ClassLoadTracing.logger = logger;
    }

    public static long getUpTime() {
        return System.currentTimeMillis() - BOOT_START_TIME;
    }

    private static String getCodeSourceFilter(String token) {
        if (token.startsWith("loader.")) {
            logger.logp(Level.WARNING, null, null, "code.source.filter", token);
            return null;
        }
        return token;
    }

    private static void trace(String event, PolicyClassLoader loader) {
        ClassLoadTracing.trace(event, loader.getDisplayName(), loader.getIdentityHashCode());
    }

    private static void trace(String event, String loaderName, String loaderIdentityHashCode) {
        ClassLoadTracing.trace("ClassLoader " + event + ": " + loaderName + " (ID #" + loaderIdentityHashCode + ")");
    }

    private static void trace(String message) {
        if (annotate) {
            Object stack;
            ClassLoader tcl;
            StringBuffer buffer = new StringBuffer(8192);
            if (addThreadID) {
                buffer.append(Thread.currentThread());
                buffer.append(' ');
            }
            if (addTCL) {
                buffer.append("TCL=");
                tcl = Thread.currentThread().getContextClassLoader();
                buffer.append(ClassLoaderQuery.getDisplayNameFor(tcl, true));
                buffer.append(' ');
            }
            if (addXTCL) {
                buffer.append("TCL=");
                tcl = Thread.currentThread().getContextClassLoader();
                if (tcl instanceof PolicyClassLoader) {
                    buffer.append(((PolicyClassLoader)tcl).toString());
                    buffer.append(ClassLoadLogger.EOL);
                } else {
                    buffer.append(ClassLoaderQuery.getDisplayNameFor(tcl, true));
                    buffer.append(' ');
                }
            }
            buffer.append(message);
            if (addStack) {
                stack = new Error().getStackTrace();
                buffer.append(ClassLoadLogger.EOL);
                for (int i = 4; i < ((Object)stack).length; ++i) {
                    buffer.append("    at ");
                    buffer.append(((StackTraceElement)stack[i]).toString());
                    buffer.append(ClassLoadLogger.EOL);
                }
            } else if (addExtendedStack) {
                stack = new ExecutionStack(4);
                ((ExecutionStack)stack).appendStackTrace(buffer);
            }
            logger.log(TRACE_LEVEL, buffer.toString());
        } else {
            logger.log(TRACE_LEVEL, message);
        }
    }

    static {
        logger = ClassLoadLogger.getLogger();
        TRACE_LEVEL = ClassLoadEnvironment.getTraceLogLevel();
    }

    private static class SourceListener
    implements CodeSourceListener {
        private Filter filter;

        public SourceListener(Filter filter) {
            this.filter = filter;
        }

        public void codeSourceCreated(SharedCodeSource codeSource, ConfigurationOrigin origin) {
            String path = codeSource.getLocation().getPath();
            if (this.filter.matches(131072, path, null)) {
                float kb = codeSource.getSize() / 1024L;
                ClassLoadTracing.trace("Code-source created: " + path + " (" + kb + "kb, from " + origin + ").");
            }
        }

        public void codeSourceStateChanged(SharedCodeSource codeSource, int newState) {
            if (this.filter.matches(0x400000, codeSource.getLocation().getPath(), null)) {
                String state = SharedCodeSource.getStateName(newState);
                ClassLoadTracing.trace("Code-source " + state + ": " + codeSource + ".");
            }
        }

        public void codeSourceExtensionDependencySatisfied(ExtensionDeclaration dependency, ExtensionDeclaration satisfiedBy, PolicyClassLoader importedLoader) {
            if (this.filter.matches(524288, dependency.getCodeSource().getLocation().getPath(), null)) {
                StringBuffer buf = new StringBuffer();
                buf.append("Code-source extension dependency satisfied: ");
                buf.append(dependency.getCodeSource());
                buf.append(ClassLoadLogger.EOL);
                buf.append("\t   Dependency: ");
                buf.append(dependency.toString(false));
                buf.append(ClassLoadLogger.EOL);
                buf.append("\t Satisfied by: ");
                buf.append(satisfiedBy.toString());
                if (importedLoader != null) {
                    buf.append(ClassLoadLogger.EOL);
                    buf.append("\tAuto-imported: ");
                    buf.append(importedLoader.getUniqueName());
                }
                ClassLoadTracing.trace(buf.toString());
            }
        }

        public void codeSourceExtensionDependencyNotSatisfied(ExtensionDeclaration dependency, int reason) {
            if (this.filter.matches(0x100000, dependency.getCodeSource().getLocation().getPath(), null)) {
                StringBuffer buf = new StringBuffer();
                buf.append("Code-source extension dependency NOT satisfied: ");
                buf.append(dependency.getCodeSource());
                buf.append(ClassLoadLogger.EOL);
                buf.append("\t   Dependency: ");
                buf.append(dependency.toString(false));
                buf.append(ClassLoadLogger.EOL);
                buf.append("\t       Reason: ");
                buf.append(ExtensionDependencyQuery.getCompatibilityString(reason));
                ClassLoadTracing.trace(buf.toString());
            }
        }

        public void codeSourceManifestProcessed(SharedCodeSource codeSource, Manifest manifest) {
            if (this.filter.matches(0x200000, codeSource.getLocation().getPath(), null)) {
                String message;
                if (manifest == null) {
                    message = "No manifest.";
                } else {
                    ExtensionDependency[] list;
                    ExtensionDeclaration info;
                    StringBuffer buf = null;
                    File[] classPath = codeSource.getClassPathDependencies();
                    if (classPath != null) {
                        buf = new StringBuffer();
                        buf.append(ClassLoadLogger.EOL);
                        buf.append("\tClass-Path: ");
                        buf.append(ArrayUtils.toString(classPath));
                    }
                    if ((info = codeSource.getExtensionDeclaration()) != null) {
                        if (buf == null) {
                            buf = new StringBuffer();
                        }
                        buf.append(ClassLoadLogger.EOL);
                        buf.append("\tExtension-Name: ");
                        buf.append(ArrayUtils.toString(info));
                    }
                    if ((list = codeSource.getExtensionDependencies()) != null) {
                        if (buf == null) {
                            buf = new StringBuffer();
                        }
                        buf.append(ClassLoadLogger.EOL);
                        buf.append("\tExtension-List: ");
                        buf.append(ArrayUtils.toString(list));
                    }
                    message = buf != null ? buf.toString() : "No relevant entries.";
                }
                ClassLoadTracing.trace("Code-source manifest processed: " + codeSource + ": " + message);
            }
        }

        public void codeSourceDestroyed(URL codeSourceLocation) {
            if (this.filter.matches(262144, codeSourceLocation.getPath(), null)) {
                ClassLoadTracing.trace("Code-source destroyed: " + codeSourceLocation + ".");
            }
        }
    }

    private static class ResourceListener
    implements ResourceSearchListener {
        private Filter filter;

        public ResourceListener(Filter filter) {
            this.filter = filter;
        }

        private String getResourcePath(URL resource) {
            String resourcePath = null;
            String fullPath = resource.getPath();
            int length = fullPath.length();
            int index = fullPath.indexOf(33);
            if (index >= 0 && ++index < length) {
                if (fullPath.charAt(index) == '/') {
                    if (++index < length) {
                        resourcePath = fullPath.substring(index);
                    }
                } else {
                    resourcePath = fullPath.substring(index);
                }
            }
            return resourcePath;
        }

        private void resourceFound(URL resource, PolicyClassLoader loader, int eventID, String prefix) {
            String resourcePath = this.getResourcePath(resource);
            if (resourcePath != null && this.filter.matches(eventID, resourcePath, loader)) {
                ClassLoadTracing.trace(prefix + resource + ". Loader: " + loader.getUniqueName());
            }
        }

        private void resourcesFound(List resources, PolicyClassLoader loader, int eventID, String prefix) {
            String resourcePath;
            URL resource = (URL)resources.get(0);
            if (resource != null && (resourcePath = this.getResourcePath(resource)) != null && this.filter.matches(eventID, resourcePath, loader)) {
                StringBuilder builder = new StringBuilder();
                builder.append(prefix);
                boolean first = true;
                for (URL url : resources) {
                    if (!first) {
                        builder.append(", ");
                    }
                    first = false;
                    builder.append(url);
                }
                builder.append(". Loader: ");
                builder.append(loader.getUniqueName());
                ClassLoadTracing.trace(builder.toString());
            }
        }

        public void resourceFound(URL resource, PolicyClassLoader loader) {
            this.resourceFound(resource, loader, 2048, "Resource found: ");
        }

        public void resourceFoundTrusted(URL resource, PolicyClassLoader loader) {
            this.resourceFound(resource, loader, 4096, "Internal resource found: ");
        }

        public void resourcesFound(List resources, PolicyClassLoader loader) {
            this.resourcesFound(resources, loader, 8192, "Resources found: ");
        }

        public void resourcesFoundTrusted(List resources, PolicyClassLoader loader) {
            this.resourcesFound(resources, loader, 16384, "Internal resources found: ");
        }

        public void resourceNotFound(String resourcePath, PolicyClassLoader loader) {
            if (this.filter.matches(65536, resourcePath, loader) && loader.isApplicationLoader() && SearchPolicy.TRUSTED_ASK_MAIN.findResource(resourcePath, loader, null, false) != null) {
                ClassLoadTracing.trace("Internal resource not found: " + resourcePath + ". Loader:" + loader.getUniqueName());
            } else if (this.filter.matches(32768, resourcePath, loader)) {
                ClassLoadTracing.trace("Resource not found: " + resourcePath + ". Loader: " + loader.getUniqueName());
            }
        }
    }

    private static class ClassListener
    implements ClassSearchListener {
        private Filter filter;

        public ClassListener(Filter filter) {
            this.filter = filter;
        }

        public void classDefine(String className, int classSize, PolicyClassLoader loader, SharedCodeSource codeSource, boolean processed) {
            if (this.filter.matches(1, className, loader)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Class to be defined: ");
                buffer.append(className);
                buffer.append(" (");
                buffer.append(classSize);
                buffer.append(" bytes). Loader: ");
                buffer.append(loader.getUniqueName());
                buffer.append(". Source: ");
                buffer.append(codeSource);
                if (processed) {
                    buffer.append(". Modified by: ");
                    buffer.append(loader.getPreprocessor());
                }
                ClassLoadTracing.trace(buffer.toString());
            }
        }

        public void classFound(Class theClass, PolicyClassLoader loader) {
            if (this.filter.matches(2, theClass.getName(), loader)) {
                String source = ClassLoaderQuery.getCodeSourceDescriptionFor(theClass);
                PolicyClassLoader definingLoader = ClassLoaderQuery.getLoaderFor(theClass);
                if (loader == definingLoader) {
                    ClassLoadTracing.trace("Class found: " + theClass.getName() + ". Loader: " + loader.getUniqueName() + ". Source: " + source);
                } else {
                    String definingLoaderName = ClassLoaderQuery.getLoaderNameFor(theClass, definingLoader);
                    ClassLoadTracing.trace("Class found: " + theClass.getName() + ". Initiating loader: " + loader.getUniqueName() + ". Defining loader: " + definingLoaderName + ". Source: " + source);
                }
            }
        }

        public void classFoundTrusted(Class theClass, PolicyClassLoader loader) {
            if (this.filter.matches(4, theClass.getName(), loader)) {
                String source = ClassLoaderQuery.getCodeSourceDescriptionFor(theClass);
                ClassLoadTracing.trace("Class found by trusted app: " + theClass.getName() + ". Loader: " + loader.getUniqueName() + ". Source: " + source);
            }
        }

        public void classNotFound(String className, PolicyClassLoader loader) {
            if (this.filter.matches(16, className, loader) && loader.isApplicationLoader() && SearchPolicy.TRUSTED_ASK_MAIN.loadClass(className, loader, null, false) != null) {
                ClassLoadTracing.trace("Internal class not found: " + className + ". Loader:" + loader.getUniqueName());
            } else if (this.filter.matches(8, className, loader)) {
                ClassLoadTracing.trace("Class not found: " + className + ". Loader:" + loader.getUniqueName());
            }
        }

        public void classError(String className, PolicyClassLoader loader, Throwable error) {
            if (this.filter.matches(32, className, loader)) {
                if (error instanceof AnnotatedThrowable) {
                    ClassLoadTracing.trace("Class error: " + error + ClassLoadLogger.EOL);
                } else {
                    ClassLoadTracing.trace("Class error: " + error + ". Loader:" + loader.getUniqueName());
                }
            }
        }
    }

    private static class LoaderListener
    implements LoaderLifeCycleListener {
        private Filter filter;

        public LoaderListener(Filter filter) {
            this.filter = filter;
        }

        public void loaderCreated(PolicyClassLoader loader) {
            String loaderName = loader.getUniqueName();
            if (this.filter.matches(64, loaderName, loader)) {
                ClassLoadTracing.trace("created", loader);
            }
        }

        public void loaderCommitted(PolicyClassLoader loader) {
            String loaderName = loader.getUniqueName();
            if (this.filter.matches(128, loaderName, loader)) {
                ClassLoadTracing.trace("committed", loader);
            }
        }

        public void loaderClosing(PolicyClassLoader loader) {
            String loaderName = loader.getUniqueName();
            if (this.filter.matches(256, loaderName, loader)) {
                ClassLoadTracing.trace("closing", loader);
            }
        }

        public void loaderDestroyed(PolicyClassLoader loader) {
            String loaderName = loader.getUniqueName();
            if (this.filter.matches(512, loaderName, null)) {
                ClassLoadTracing.trace("destroyed", loader);
            }
        }

        public void loaderCollected(String loaderName, String loaderIdentityHashCode) {
            if (this.filter.matches(1024, loaderName, null)) {
                ClassLoadTracing.trace("collected", loaderName, loaderIdentityHashCode);
            }
        }
    }

    public static abstract class Filter {
        private static final int CLASS_DEFINE = 1;
        private static final int CLASS_FOUND = 2;
        private static final int CLASS_FOUND_TRUSTED = 4;
        private static final int CLASS_NOT_FOUND = 8;
        private static final int CLASS_NOT_FOUND_UNTRUSTED = 16;
        private static final int CLASS_ERROR = 32;
        private static final int LOADER_CREATED = 64;
        private static final int LOADER_COMMITTED = 128;
        private static final int LOADER_CLOSING = 256;
        private static final int LOADER_DESTROYED = 512;
        private static final int LOADER_COLLECTED = 1024;
        private static final int RESOURCE_FOUND = 2048;
        private static final int RESOURCE_FOUND_TRUSTED = 4096;
        private static final int RESOURCES_FOUND = 8192;
        private static final int RESOURCES_FOUND_TRUSTED = 16384;
        private static final int RESOURCE_NOT_FOUND = 32768;
        private static final int RESOURCE_NOT_FOUND_UNTRUSTED = 65536;
        private static final int CODE_SOURCE_CREATED = 131072;
        private static final int CODE_SOURCE_DESTROYED = 262144;
        private static final int CODE_SOURCE_DEPENDENCY_SATISFIED = 524288;
        private static final int CODE_SOURCE_DEPENDENCY_NOT_SATISFIED = 0x100000;
        private static final int CODE_SOURCE_MANIFEST_PROCESSED = 0x200000;
        private static final int CODE_SOURCE_STATE_CHANGED = 0x400000;
        private static final int ANY_EVENT = 0xFFFFFFF;
        private static final Map KEYS = Filter.createKeyMap();
        public static final Filter ALL = new Filter(){

            public boolean matches(int eventID, String name, PolicyClassLoader loader) {
                return true;
            }
        };

        private static Map createKeyMap() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("class", new Integer(0xFFFFFFF));
            map.put("class-define", new Integer(1));
            map.put("class-defined", new Integer(1));
            map.put("class-found", new Integer(6));
            map.put("class-found-trusted", new Integer(4));
            map.put("class-not-found", new Integer(8));
            map.put("class-not-found-untrusted", new Integer(16));
            map.put("class-error", new Integer(32));
            map.put("resource", new Integer(0xFFFFFFF));
            map.put("resource-found", new Integer(6144));
            map.put("resource-found-trusted", new Integer(4096));
            map.put("resources-found", new Integer(8192));
            map.put("resources-found-trusted", new Integer(16384));
            map.put("resource-not-found", new Integer(32768));
            map.put("resource-not-found-untrusted", new Integer(65536));
            map.put("code-source", new Integer(0xFFFFFFF));
            map.put("code-source-create", new Integer(131072));
            map.put("code-source-created", new Integer(131072));
            map.put("code-source-dependency", new Integer(0x180000));
            map.put("code-source-dependency-satisfied", new Integer(524288));
            map.put("code-source-dependency-not-satisfied", new Integer(0x100000));
            map.put("code-source-manifest", new Integer(0x200000));
            map.put("code-source-manifest-processed", new Integer(0x200000));
            map.put("code-source-state", new Integer(0x400000));
            map.put("code-source-state-changed", new Integer(0x400000));
            map.put("code-source-destroy", new Integer(262144));
            map.put("code-source-destroyed", new Integer(262144));
            map.put("loader", new Integer(0xFFFFFFF));
            map.put("loader-create", new Integer(64));
            map.put("loader-created", new Integer(64));
            map.put("loader-commit", new Integer(128));
            map.put("loader-committed", new Integer(128));
            map.put("loader-close", new Integer(256));
            map.put("loader-closed", new Integer(256));
            map.put("loader-destroy", new Integer(512));
            map.put("loader-destroyed", new Integer(512));
            map.put("loader-collect", new Integer(1024));
            map.put("loader-finalize", new Integer(1024));
            map.put("loader-collected", new Integer(1024));
            map.put("loader-finalized", new Integer(1024));
            return map;
        }

        public static Filter getFilter(String token, Filter existingFilter) {
            Filter result = existingFilter;
            if (token != null) {
                Integer selector;
                String key = token;
                String filterStr = null;
                boolean pattern = false;
                int eventSelector = 0xFFFFFFF;
                int index = token.indexOf(58);
                if (index < 0) {
                    index = token.indexOf(126);
                    boolean bl = pattern = index >= 0;
                }
                if (index > 0) {
                    key = token.substring(0, index);
                    filterStr = token.substring(index + 1);
                }
                if ((selector = (Integer)KEYS.get(key)) == null) {
                    logger.severe("Unknown value for " + ClassLoadEnvironment.getTraceKey() + ": " + key);
                } else {
                    eventSelector = selector;
                    result = Filter.OR(existingFilter, filterStr, eventSelector, pattern);
                }
            }
            return result;
        }

        public abstract boolean matches(int var1, String var2, PolicyClassLoader var3);

        public static Filter OR(Filter left, String rightFilterStr, int eventSelector, boolean pattern) {
            Filter right = null;
            if (rightFilterStr == null || rightFilterStr.length() == 0) {
                right = eventSelector == 0xFFFFFFF ? ALL : new EventFilter(eventSelector);
            } else if (pattern) {
                right = Filter.createPatternFilter(rightFilterStr, eventSelector);
            } else if (rightFilterStr.indexOf(44) > 0) {
                StringTokenizer tk = new StringTokenizer(rightFilterStr, ",");
                while (tk.hasMoreTokens()) {
                    Filter filter = Filter.createStringFilter(tk.nextToken(), eventSelector);
                    if (right == null) {
                        right = filter;
                        continue;
                    }
                    right = new OR(right, filter);
                }
            } else {
                right = Filter.createStringFilter(rightFilterStr, eventSelector);
            }
            if (left == null || left == ALL) {
                return right;
            }
            return new OR(left, right);
        }

        private static Filter createStringFilter(String filter, int eventSelector) {
            if (filter.startsWith("loader.")) {
                filter = filter.substring(7);
                return new LoaderNameEquals(filter, eventSelector);
            }
            if (filter.endsWith("*")) {
                filter = filter.substring(0, filter.length() - 1);
                return new NameStartsWith(filter, eventSelector);
            }
            if (filter.startsWith("*")) {
                filter = filter.substring(1);
                return new NameEndsWith(filter, eventSelector);
            }
            return new NameEquals(filter, eventSelector);
        }

        private static Filter createPatternFilter(String filter, int eventSelector) {
            if (filter == null) {
                return ALL;
            }
            if (filter.startsWith("loader.")) {
                filter = filter.substring(7);
                return new LoaderNameMatches(filter, eventSelector);
            }
            return new NameMatches(filter, eventSelector);
        }

        public static class OR
        extends BinaryFilter {
            public OR(Filter left, Filter right) {
                super(left, right);
            }

            public boolean matches(int eventID, String name, PolicyClassLoader loader) {
                return this.left.matches(eventID, name, loader) || this.right.matches(eventID, name, loader);
            }
        }

        public static class LoaderNameMatches
        extends PatternFilter {
            public LoaderNameMatches(String filter, int eventSelector) {
                super(filter, eventSelector);
            }

            public boolean matches(int eventID, String name, PolicyClassLoader loader) {
                return this.eventMatches(eventID) && this.filter.matcher(loader.getName()).matches();
            }
        }

        public static class NameMatches
        extends PatternFilter {
            public NameMatches(String filter, int eventSelector) {
                super(filter, eventSelector);
            }

            public boolean matches(int eventID, String name, PolicyClassLoader loader) {
                return this.eventMatches(eventID) && this.filter.matcher(name).matches();
            }
        }

        public static class LoaderNameEquals
        extends StringFilter {
            public LoaderNameEquals(String filter, int eventSelector) {
                super(filter, eventSelector);
            }

            public boolean matches(int eventID, String name, PolicyClassLoader loader) {
                return this.eventMatches(eventID) && loader.getName().equals(this.filter);
            }
        }

        public static class NameEndsWith
        extends StringFilter {
            public NameEndsWith(String filter, int eventSelector) {
                super(filter, eventSelector);
            }

            public boolean matches(int eventID, String name, PolicyClassLoader loader) {
                return this.eventMatches(eventID) && name.endsWith(this.filter);
            }
        }

        public static class NameStartsWith
        extends StringFilter {
            public NameStartsWith(String filter, int eventSelector) {
                super(filter, eventSelector);
            }

            public boolean matches(int eventID, String name, PolicyClassLoader loader) {
                return this.eventMatches(eventID) && name.startsWith(this.filter);
            }
        }

        public static class NameEquals
        extends StringFilter {
            public NameEquals(String filter, int eventSelector) {
                super(filter, eventSelector);
            }

            public boolean matches(int eventID, String name, PolicyClassLoader loader) {
                return this.eventMatches(eventID) && name.equals(this.filter);
            }
        }

        public static abstract class BinaryFilter
        extends Filter {
            protected Filter left;
            protected Filter right;

            protected BinaryFilter(Filter left, Filter right) {
                this.left = left;
                this.right = right;
            }
        }

        public static abstract class PatternFilter
        extends EventFilter {
            protected Pattern filter;

            protected PatternFilter(String filter, int eventSelector) {
                super(eventSelector);
                this.filter = Pattern.compile(filter);
            }
        }

        public static abstract class StringFilter
        extends EventFilter {
            protected String filter;

            protected StringFilter(String filter, int eventSelector) {
                super(eventSelector);
                this.filter = filter;
            }
        }

        public static class EventFilter
        extends Filter {
            private int eventSelector;

            public EventFilter(int eventSelector) {
                this.eventSelector = eventSelector;
            }

            public boolean matches(int eventID, String name, PolicyClassLoader loader) {
                return (eventID & this.eventSelector) != 0;
            }

            protected boolean eventMatches(int eventID) {
                return (eventID & this.eventSelector) != 0;
            }
        }
    }
}

