/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.CodeSourceSearchPolicy;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.ConfigurationType;
import oracle.classloader.MetaInfResourceCollector;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.Resource;
import oracle.classloader.ResourceCollector;
import oracle.classloader.SharedCodeSourceList;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ClassPreprocessor;
import oracle.classloader.util.ClassPreprocessorSequence;
import oracle.classloader.util.ResourceFilter;
import oracle.classloader.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtilities {
    private static List<Integer> utilityLoaders = Collections.synchronizedList(new ArrayList());
    private static final String USER_DEFINED_ORIGIN = "user-defined-origin";

    public static ClassLoader copy(ClassLoader loader) {
        PolicyClassLoader result = null;
        if (loader instanceof PolicyClassLoader) {
            result = new PolicyClassLoader((PolicyClassLoader)loader, false, true);
            utilityLoaders.add(System.identityHashCode(result));
        }
        return result;
    }

    public static boolean closeCopy(ClassLoader loader) {
        return ClassLoaderUtilities.close(loader);
    }

    public static boolean close(ClassLoader loader) {
        if (utilityLoaders.remove(new Integer(System.identityHashCode(loader)))) {
            ((PolicyClassLoader)loader).close();
            return true;
        }
        return false;
    }

    public static boolean addPreprocessor(ClassLoader loader, ClassPreprocessor preprocessor) {
        if (loader instanceof PolicyClassLoader) {
            PolicyClassLoader pcl = (PolicyClassLoader)loader;
            ClassPreprocessor existing = pcl.getPreprocessor();
            if (existing == null) {
                pcl.setPreprocessor(preprocessor);
            } else {
                pcl.setPreprocessor(new ClassPreprocessorSequence(existing, preprocessor));
            }
            return true;
        }
        return false;
    }

    public static ClassPreprocessor getPreprocessor(ClassLoader loader) {
        if (loader instanceof PolicyClassLoader) {
            return ((PolicyClassLoader)loader).getPreprocessor();
        }
        return null;
    }

    public static boolean setPreprocessor(ClassLoader loader, ClassPreprocessor preprocessor) {
        if (loader instanceof PolicyClassLoader) {
            ((PolicyClassLoader)loader).setPreprocessor(preprocessor);
            return true;
        }
        return false;
    }

    public static ClassLoader createClassLoader(String name, String version, ClassLoader parent, File[] codeSources, File ... archiveDirectories) {
        PolicyClassLoader loader;
        List<File> codeSourcesToAdd = ClassLoaderUtilities.getClassLoaderFiles(archiveDirectories);
        codeSourcesToAdd.addAll(Arrays.asList(codeSources));
        VersionNumber versionNumber = new VersionNumber(version);
        ConfigurationOrigin loaderOrigin = new ConfigurationOrigin(CustomClassLoaderConfig.CUSTOM_COMPONENT_TYPE, USER_DEFINED_ORIGIN);
        ConfigurationPolicy policy = CustomClassLoaderConfig.CUSTOM_COMPONENT_POLICY;
        try {
            loader = new PolicyClassLoader(name, versionNumber, parent, loaderOrigin, policy);
        }
        catch (Error e) {
            ClassLoadLogger.getLogger().log(Level.SEVERE, "Exception creating custom component loader", e);
            throw e;
        }
        catch (RuntimeException e) {
            ClassLoadLogger.getLogger().log(Level.SEVERE, "Exception creating custom component loader", e);
            throw e;
        }
        for (File jar : codeSourcesToAdd) {
            ConfigurationOrigin codeSourceOrigin = new ConfigurationOrigin(CustomClassLoaderConfig.CUSTOM_COMPONENT_TYPE, USER_DEFINED_ORIGIN);
            try {
                loader.addCodeSource(jar, codeSourceOrigin);
            }
            catch (IOException e) {
                ClassLoadLogger.getLogger().log(Level.SEVERE, "Unable to add a code source due to exception", e);
            }
        }
        utilityLoaders.add(System.identityHashCode(loader));
        return loader;
    }

    public static ClassLoader findClassLoader(String name, String minVersion, String maxVersion) {
        VersionNumber max;
        VersionNumber min = minVersion != null ? new VersionNumber(minVersion) : null;
        PolicyClassLoader result = ClassLoaderQuery.findLoader(name, min, max = maxVersion != null ? new VersionNumber(maxVersion) : null);
        if (result == ClassLoaderQuery.getMainLoader()) {
            result = null;
        }
        return result;
    }

    public static URL[] findResources(ResourceFilter filter, ClassLoader loader) {
        URL[] result = null;
        if (loader instanceof PolicyClassLoader) {
            PolicyClassLoader pcl = (PolicyClassLoader)loader;
            ResourceCollector c = new ResourceCollector(filter);
            c.visitAllLoadersInSearchOrder(pcl);
            return ClassLoaderUtilities.getURLs(c);
        }
        return result;
    }

    public static URL[] findMetaInfResources(ResourceFilter filter, ClassLoader loader) {
        URL[] result = null;
        if (loader instanceof PolicyClassLoader) {
            PolicyClassLoader pcl = (PolicyClassLoader)loader;
            MetaInfResourceCollector c = new MetaInfResourceCollector(filter);
            c.visitAllLoadersInSearchOrder(pcl);
            return ClassLoaderUtilities.getURLs(c);
        }
        return result;
    }

    private static URL[] getURLs(ResourceCollector collector) {
        List<Resource> resources = collector.getList();
        int count = resources.size();
        URL[] result = new URL[count];
        for (int i = 0; i < count; ++i) {
            Resource r = resources.get(i);
            result[i] = r.createURL();
        }
        return result;
    }

    private static List<File> getClassLoaderFiles(File ... loaderFiles) {
        ArrayList<File> files = new ArrayList<File>();
        for (File dir : loaderFiles) {
            if (!dir.exists()) continue;
            if (dir.isDirectory()) {
                String[] classArchives;
                for (String archive : classArchives = dir.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar") || name.endsWith(".zip");
                    }
                })) {
                    files.add(new File(dir, archive));
                }
                continue;
            }
            files.add(dir);
        }
        return files;
    }

    static class CustomConfigurationPolicy
    extends ConfigurationPolicy {
        public CustomConfigurationPolicy(ConfigurationType[] types, int sharingPolicy, boolean inheritImports, int defaultEqualityPolicy, boolean autoCommit, int category) {
            super(types, sharingPolicy, inheritImports, defaultEqualityPolicy, autoCommit, category);
        }

        public CustomConfigurationPolicy(ConfigurationType[] types, int sharingPolicy, boolean inheritImports, int defaultEqualityPolicy, boolean autoCommit, int category, boolean inheritImportsFromCommiitedOnly) {
            super(types, sharingPolicy, inheritImports, defaultEqualityPolicy, autoCommit, category, inheritImportsFromCommiitedOnly);
        }

        public SharedCodeSourceList.Index createIndex() {
            return new CodeSourceSearchPolicy.Linear().createIndex();
        }
    }

    private static class CustomClassLoaderConfig
    extends ConfigurationType {
        public static final ConfigurationType CUSTOM_COMPONENT_TYPE = CustomClassLoaderConfig.create(CustomClassLoaderScope.access$000(), "Application component", "in", "application", false);
        public static final ConfigurationPolicy CUSTOM_COMPONENT_POLICY = new CustomConfigurationPolicy(new ConfigurationType[]{CUSTOM_COMPONENT_TYPE}, 0, true, 3, true, 3);

        private CustomClassLoaderConfig() {
        }
    }

    private static class CustomClassLoaderScope
    extends ClassLoaderScope {
        private static final ClassLoaderScope CUSTOM = new CustomClassLoaderScope(ClassLoaderScope.APPLICATION.getLevel() + 2, "Application: Custom");

        protected CustomClassLoaderScope(int i, String s) {
            super(i, s);
        }

        static /* synthetic */ ClassLoaderScope access$000() {
            return CUSTOM;
        }
    }
}

