/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.security.ProtectionDomain;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassPreprocessor;

public class ClassPreprocessorSequence
implements ClassPreprocessor {
    private int count;
    private ClassPreprocessor[] list;

    public ClassPreprocessorSequence(ClassPreprocessor first, ClassPreprocessor second) {
        int i;
        ClassPreprocessorSequence sequence;
        if (first instanceof ClassPreprocessorSequence) {
            sequence = (ClassPreprocessorSequence)first;
            for (i = 0; i < sequence.count; ++i) {
                this.list = (ClassPreprocessor[])ArrayUtils.append(ClassPreprocessor.class, this.list, this.count++, sequence.list[i]);
            }
        } else {
            this.list = (ClassPreprocessor[])ArrayUtils.append(ClassPreprocessor.class, this.list, this.count++, first);
        }
        if (second instanceof ClassPreprocessorSequence) {
            sequence = (ClassPreprocessorSequence)second;
            for (i = 0; i < sequence.count; ++i) {
                this.list = (ClassPreprocessor[])ArrayUtils.append(ClassPreprocessor.class, this.list, this.count++, sequence.list[i]);
            }
        } else {
            this.list = (ClassPreprocessor[])ArrayUtils.append(ClassPreprocessor.class, this.list, this.count++, second);
        }
    }

    public ClassPreprocessorSequence(ClassPreprocessor[] sequence, int sequenceCount) {
        this.list = sequence;
        this.count = sequenceCount;
    }

    public ClassPreprocessor initialize(ClassLoader loader) {
        int i;
        for (i = 0; i < this.count; ++i) {
            this.list[i] = this.list[i].initialize(loader);
        }
        for (i = 0; i < this.count; ++i) {
            for (int j = 0; j < this.count; ++j) {
                if (j == i || this.list[i] != this.list[j]) continue;
                this.list[j] = null;
            }
        }
        return this;
    }

    public byte[] processClass(String className, byte[] classBytes, int offset, int length, ProtectionDomain pd, ClassLoader loader) {
        for (int i = 0; i < this.count; ++i) {
            byte[] result;
            if (this.list[i] == null || (result = this.list[i].processClass(className, classBytes, offset, length, pd, loader)) == classBytes) continue;
            offset = 0;
            length = result.length;
            classBytes = result;
        }
        return classBytes;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                buffer.append(" --> ");
            }
            buffer.append(this.list[i]);
        }
        return buffer.toString();
    }

    public ClassPreprocessor[] getMembers() {
        return (ClassPreprocessor[])ArrayUtils.copy(this.list, this.count);
    }
}

