/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.lang.reflect.Method;

public abstract class Clock {
    private static final long TICKS_PER_MILLISECOND = 1000L;
    private static Clock instance;

    public abstract long getTicks();

    public abstract long getFrequency();

    public abstract long toMillis(long var1);

    public static Clock getInstance() {
        if (instance == null) {
            try {
                instance = new JRE15Clock();
            }
            catch (Exception e1) {
                try {
                    instance = new DMSHighResClock();
                }
                catch (Exception e2) {
                    instance = new SystemMillisClock();
                }
            }
        }
        return instance;
    }

    static class JRE15Clock
    extends ReflectiveClock {
        JRE15Clock() throws Exception {
            super("java.lang.System", "nanoTime", false);
            this.setFrequency(1000000000L);
        }
    }

    static class DMSHighResClock
    extends ReflectiveClock {
        DMSHighResClock() throws Exception {
            super("oracle.dms.clock.HighResolutionClock", "getTime", true);
            Method freq = this.hrClock.getClass().getMethod("getHRReportedFrequency", new Class[0]);
            this.setFrequency((Long)freq.invoke(this.hrClock, this.args));
        }
    }

    static class ReflectiveClock
    extends Clock {
        Object hrClock;
        Method getTicksMethod;
        Object[] args = new Object[0];
        long frequency;
        long ticksToMillis;

        ReflectiveClock(String className, String methodName, boolean instance) throws Exception {
            Class<?> clz = Class.forName(className);
            if (instance) {
                this.hrClock = clz.newInstance();
            }
            Class[] params = new Class[]{};
            this.getTicksMethod = clz.getMethod(methodName, params);
        }

        void setFrequency(long freq) {
            this.frequency = freq;
            this.ticksToMillis = freq / 1000L;
        }

        public long getTicks() {
            try {
                Object result = this.getTicksMethod.invoke(this.hrClock, this.args);
                return (Long)result;
            }
            catch (Exception e) {
                return 0L;
            }
        }

        public long getFrequency() {
            return this.frequency;
        }

        public long toMillis(long ticks) {
            return ticks / this.ticksToMillis;
        }
    }

    static class SystemMillisClock
    extends Clock {
        SystemMillisClock() {
        }

        public long getTicks() {
            return System.currentTimeMillis();
        }

        public long getFrequency() {
            return 1000L;
        }

        public long toMillis(long ticks) {
            return ticks;
        }
    }
}

