/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ExecutionStack;
import oracle.classloader.util.LocalizedText;
import oracle.classloader.util.ThrowableAnnotation;

public abstract class DependentClass
implements ThrowableAnnotation {
    private PolicyClassLoader dependentClassLoader;
    private PolicyClassLoader initiatingClassLoader;
    private String initiatingClassLoaderName;
    private String dependentClassName;
    private String dependentClassLoaderName;
    private String dependentClassCodeSource;
    private String dependentClassOrigin;
    private String description;
    private ExecutionStack stack;

    protected DependentClass(PolicyClassLoader initiatingLoader, ExecutionStack stack) {
        this.stack = stack;
        Class dependentClass = stack.getCallerClass();
        this.dependentClassName = dependentClass.getName();
        this.dependentClassLoader = ClassLoaderQuery.getLoaderFor(dependentClass);
        this.dependentClassLoaderName = ClassLoaderQuery.getLoaderNameFor(dependentClass, this.dependentClassLoader);
        this.dependentClassCodeSource = ClassLoaderQuery.getCodeSourcePathFor(dependentClass, "unknown");
        this.dependentClassOrigin = ClassLoaderQuery.getFirstOriginDescriptionFor(dependentClass);
        if (initiatingLoader == null) {
            this.initiatingClassLoader = this.dependentClassLoader;
            this.initiatingClassLoaderName = this.dependentClassLoaderName;
        } else {
            this.initiatingClassLoader = initiatingLoader;
            this.initiatingClassLoaderName = initiatingLoader.getDisplayName();
        }
    }

    protected DependentClass(String dependentClassName, PolicyClassLoader dependentClassLoader, String dependentClassCodeSource, String dependentClassOrigin, ExecutionStack stack) {
        this.dependentClassName = dependentClassName;
        this.dependentClassLoader = dependentClassLoader;
        this.dependentClassLoaderName = dependentClassLoader.getDisplayName();
        this.dependentClassCodeSource = dependentClassCodeSource;
        this.dependentClassOrigin = dependentClassOrigin;
        this.stack = stack;
        this.initiatingClassLoader = dependentClassLoader;
        this.initiatingClassLoaderName = this.dependentClassLoaderName;
    }

    public ExecutionStack getExecutionStack() {
        return this.stack;
    }

    public PolicyClassLoader getInitiatingLoader() {
        return this.initiatingClassLoader;
    }

    public String getDescription() {
        if (this.description == null) {
            String desc = this.createDescription(ClassLoadLogger.getText(), this.dependentClassName, this.dependentClassLoaderName, this.dependentClassCodeSource, this.dependentClassOrigin, this.initiatingClassLoaderName);
            String analysis = null;
            if (this.dependentClassLoader != null) {
                try {
                    analysis = this.getAnalysis(ClassLoadLogger.getText(), this.dependentClassLoader, this.initiatingClassLoader);
                }
                catch (Throwable e) {
                    analysis = "(Failure analysis caught " + e + ")";
                }
            }
            this.description = analysis == null ? desc : desc + ClassLoadLogger.EOL + analysis;
        }
        return this.description;
    }

    protected abstract String createDescription(LocalizedText var1, String var2, String var3, String var4, String var5, String var6);

    protected abstract String getAnalysis(LocalizedText var1, PolicyClassLoader var2, PolicyClassLoader var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(Throwable error, PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            stream.println(error);
            if (this.stack == null) {
                stream.println(this.getStackTrace(error));
            } else {
                stream.println(this.stack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(Throwable error, PrintWriter stream) {
        PrintWriter printWriter = stream;
        synchronized (printWriter) {
            stream.println(error);
            if (this.stack == null) {
                stream.println(this.getStackTrace(error));
            } else {
                stream.println(this.stack);
            }
        }
    }

    public String getStackTrace(Throwable error) {
        StringBuffer buffer = new StringBuffer();
        if (this.stack == null) {
            StackTraceElement[] trace = error.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                buffer.append("\tat ");
                buffer.append(trace[i].toString());
                buffer.append(ClassLoadLogger.EOL);
            }
        } else {
            this.stack.appendStackTrace(buffer);
        }
        return buffer.toString();
    }
}

