/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadLogger;

public class GarbageCollection {
    private static Logger LOG = ClassLoadLogger.getLogger();

    static void log(String message) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "GC: " + message);
        }
    }

    public static synchronized boolean forceCollection(Goal goal) {
        boolean goalReached = goal.reached();
        if (!goalReached && !(goalReached = GarbageCollection.forceOldGenerationGC(goal))) {
            goalReached = GarbageCollection.forcePermanentGenerationGC(goal);
        }
        return goalReached;
    }

    private static boolean forcePermanentGenerationGC(Goal goal) {
        boolean goalReached = goal.reached();
        if (!goalReached && BigClassLoader.isValid()) {
            GarbageCollection.log("Begin permgen collection");
            ArrayList<Class> classCache = new ArrayList<Class>();
            OutOfMemoryError error = null;
            int cacheSize = 0;
            try {
                while (classCache != null) {
                    classCache.add(BigClassLoader.defineClass());
                    ++cacheSize;
                }
            }
            catch (OutOfMemoryError e) {
                error = e;
            }
            classCache = null;
            try {
                GarbageCollection.log("Loading final large class...");
                BigClassLoader.defineClass();
                GarbageCollection.log("Loaded final large class...");
            }
            catch (OutOfMemoryError e) {
                error = e;
            }
            goalReached = GarbageCollection.systemGC(goal);
            GarbageCollection.log("Got expected " + error + ", count " + cacheSize);
            GarbageCollection.log("Finished permgen collection; goalReached=" + goalReached);
        }
        return goalReached;
    }

    private static boolean forceOldGenerationGC(Goal goal) {
        boolean goalReached = goal.reached();
        if (!goalReached) {
            Object memory;
            GarbageCollection.log("Begin oldgen collection");
            OutOfMemoryError error = null;
            Runtime rt = Runtime.getRuntime();
            int allocSize = 0;
            try {
                memory = new byte[16384][];
                while (memory != null) {
                    for (int i = 0; i < ((byte[][])memory).length; ++i) {
                        if (i == 0) {
                            allocSize = (int)rt.freeMemory();
                        } else if (i == 1) {
                            allocSize = (int)rt.totalMemory();
                        } else if (i == 2) {
                            allocSize = (int)rt.maxMemory();
                        } else if (i == 3) {
                            allocSize = Integer.MAX_VALUE;
                        }
                        memory[i] = new byte[allocSize];
                    }
                }
            }
            catch (OutOfMemoryError e) {
                error = e;
            }
            memory = null;
            goalReached = goal.reached();
            if (!goalReached) {
                for (int i = 0; i < 3 && !(goalReached = GarbageCollection.systemGC(goal)); ++i) {
                }
            }
            GarbageCollection.log("Got expected " + error);
            GarbageCollection.log("Finished oldgen collection; goalReached=" + goalReached);
        }
        return goalReached;
    }

    private static boolean systemGC(Goal goal) {
        boolean goalReached = goal.reached();
        if (!goalReached) {
            System.gc();
            try {
                GarbageCollection.class.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.runFinalization();
            goalReached = goal.reached();
            GarbageCollection.log("Finished system GC calls; goalReached=" + goalReached);
        }
        return goalReached;
    }

    private static class BigClassLoader
    extends ClassLoader {
        private static final String BIG_CLASS_NAME = "com.sun.corba.se.impl.logging.ORBUtilSystemException";
        private static byte[] data;

        private BigClassLoader() {
        }

        private static void init() {
            try {
                String resource = BIG_CLASS_NAME.replace('.', '/').concat(".class");
                InputStream in = BigClassLoader.class.getClassLoader().getResourceAsStream(resource);
                data = ArrayUtils.read(in);
            }
            catch (Throwable t) {
                data = new byte[0];
                ClassLoadLogger.getLogger().log(Level.WARNING, "Caught", t);
            }
        }

        public static boolean isValid() {
            if (data == null) {
                BigClassLoader.init();
            }
            return data.length > 0;
        }

        public static Class defineClass() {
            return new BigClassLoader().defineIt();
        }

        private Class defineIt() {
            if (BigClassLoader.isValid()) {
                return this.defineClass(BIG_CLASS_NAME, data, 0, data.length);
            }
            return null;
        }
    }

    public static interface Goal {
        public boolean reached();
    }
}

