/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.ConfigurationType;
import oracle.classloader.DelegatingSearchPolicy;
import oracle.classloader.JVMSearchPolicy;
import oracle.classloader.MappedSearchPolicy;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SearchSequence;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ClassLoadTracing;
import oracle.classloader.util.InitialLoadersConfiguration;
import oracle.classloader.util.LoaderLeakDetector;
import oracle.classloader.util.MainClass;
import oracle.classloader.util.PropertyUtils;
import oracle.classloader.util.VersionNumber;
import oracle.classloader.util.XMLConfiguration;

public class InitialLoadersFactory {
    private static final ClassLoader JRE_SYSTEM_LOADER = InitialLoadersFactory.class.getClassLoader();
    private static int classTransferMode = ClassLoadEnvironment.getClassTransferMode();
    private static boolean replaceSystemLoader = true;
    private static PolicyClassLoader bootLoader;
    private static PolicyClassLoader extensionLoader;
    private static PolicyClassLoader systemLoader;
    private static String[] mainArguments;
    private static boolean configureMainAsSystemLoader;
    private static boolean inConfiguration;
    private static Map fwTransferClasses;
    private static SharedCodeSource fwCodeSource;
    private static String configOrigin;
    private static InitialLoadersConfiguration config;
    private static File homeDirectory;
    public static final String BOOT_CONFIG = "boot";
    public static final String EXTENSION_CONFIG = "extension";
    public static final String SYSTEM_CONFIG = "system";
    public static final String SHARED_CONFIG = "shared";
    public static final String SHARED_CONFIG_PRIVATE = "shared-private";
    public static final String MAIN_CONFIG = "main";

    public static MainClass create(InitialLoadersConfiguration config) throws Exception {
        classTransferMode = ClassLoadEnvironment.getClassTransferMode();
        mainArguments = config.getCommandLineArguments();
        replaceSystemLoader = config.shouldReplaceSystemLoader();
        homeDirectory = config.getHomeDirectory();
        InitialLoadersFactory.config = config;
        ClassLoadEnvironment.assertValidRuntime();
        if (!ClassLoadTracing.init()) {
            System.exit(0);
        }
        ClassLoadEnvironment.initURLHandling();
        ClassLoadLogger.getLogger();
        MainClass main = InitialLoadersFactory.initLoaders(config);
        if (ClassLoadEnvironment.activateLoaderLeakDetection()) {
            LoaderLeakDetector.activate();
        }
        InitialLoadersFactory.config = null;
        return main;
    }

    public static String getConfigurationOrigin() {
        if (configOrigin == null) {
            if (config == null) {
                return ClassLoadEnvironment.getDefaultInitialLoadersConfigurationOrigin();
            }
            configOrigin = config.getOrigin();
        }
        return configOrigin;
    }

    private static synchronized MainClass initLoaders(InitialLoadersConfiguration config) throws Exception {
        if (bootLoader == null) {
            systemLoader = new PolicyClassLoader(JRE_SYSTEM_LOADER);
        }
        MainClass result = InitialLoadersFactory.populateLoaders(config);
        ConfigurationPolicy.setAutoCommitBootLoaders(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setSystemClassLoader(boolean replaceSystemLoader) throws Exception {
        String systemLoaderName = ClassLoadEnvironment.setMainAsSystemLoader() ? ClassLoadEnvironment.getMainLoaderName() : ClassLoadEnvironment.getAPILoaderName();
        PolicyClassLoader systemLoader = ClassLoaderQuery.findLatestLoader(systemLoaderName);
        ClassLoaderQuery.setSystemLoader(systemLoader);
        if (!replaceSystemLoader) return;
        if (ClassLoader.getSystemClassLoader().getClass() == PolicyClassLoader.class) return;
        try {
            Class<ClassLoader> clazz = ClassLoader.class;
            synchronized (ClassLoader.class) {
                Field sclField = ClassLoader.class.getDeclaredField("scl");
                sclField.setAccessible(true);
                sclField.set(null, systemLoader);
                Field sclSetField = ClassLoader.class.getDeclaredField("sclSet");
                sclSetField.setAccessible(true);
                sclSetField.setBoolean(null, true);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
        catch (Throwable e) {
            Throwable error = e;
            String fieldName = ClassLoadEnvironment.getBackupSystemClassLoaderFieldName();
            try {
                Class<ClassLoader> clazz = ClassLoader.class;
                synchronized (ClassLoader.class) {
                    Field sclField = ClassLoader.class.getDeclaredField(fieldName);
                    sclField.setAccessible(true);
                    sclField.set(null, systemLoader);
                    return;
                }
            }
            catch (Throwable e2) {
                error = e2;
            }
            if (error == null) return;
            if (ClassLoadLogger.willLog(Level.FINEST)) {
                String msg = ClassLoadLogger.getText().getText("loader.replace", PolicyClassLoader.class.getName());
                ClassLoadLogger.getLogger().log(Level.FINEST, msg, error);
                return;
            }
            ClassLoadLogger.log(Level.FINE, "loader.replace", PolicyClassLoader.class.getName());
        }
    }

    public static synchronized PolicyClassLoader createInitialLoaders(ClassLoader ourLoader) {
        if (bootLoader != null) {
            throw new IllegalStateException("Attempted to create " + ClassLoadEnvironment.getExtensionLoaderName() + " more than once.");
        }
        if (ourLoader != InitialLoadersFactory.class.getClassLoader()) {
            throw new IllegalStateException("Expected loader " + InitialLoadersFactory.class.getClassLoader() + ", got " + ourLoader);
        }
        String javaHome = ClassLoadEnvironment.getProperty("java.home");
        VersionNumber jreVersion = new VersionNumber(ClassLoadEnvironment.getProperty("java.version"), false, false);
        bootLoader = new PolicyClassLoader(ClassLoadEnvironment.getRootLoaderName(), jreVersion.isValid() ? jreVersion : VersionNumber.ZERO, null, InitialLoadersFactory.createOriginFor(BOOT_CONFIG, javaHome), InitialLoadersFactory.getConfigurationPolicyFor(BOOT_CONFIG), InitialLoadersFactory.createSearchPolicyFor(BOOT_CONFIG), InitialLoadersFactory.createProtectionPolicyFor(BOOT_CONFIG));
        PolicyClassLoader result = extensionLoader = new PolicyClassLoader(ClassLoadEnvironment.getExtensionLoaderName(), VersionNumber.ZERO, bootLoader, InitialLoadersFactory.createOriginFor(EXTENSION_CONFIG, javaHome), InitialLoadersFactory.getConfigurationPolicyFor(EXTENSION_CONFIG), InitialLoadersFactory.createSearchPolicyFor(EXTENSION_CONFIG), InitialLoadersFactory.createProtectionPolicyFor(EXTENSION_CONFIG));
        if (InitialLoadersFactory.configureMainAsSystemLoader()) {
            result = new PolicyClassLoader(ClassLoadEnvironment.getAPILoaderName(), ClassLoadEnvironment.getAPIVersion(), extensionLoader, InitialLoadersFactory.createOriginFor(SYSTEM_CONFIG, InitialLoadersFactory.getConfigurationOrigin()), InitialLoadersFactory.getConfigurationPolicyFor(SYSTEM_CONFIG), InitialLoadersFactory.createSearchPolicyFor(SYSTEM_CONFIG), InitialLoadersFactory.createProtectionPolicyFor(SYSTEM_CONFIG));
        }
        return result;
    }

    private static MainClass populateLoaders(InitialLoadersConfiguration config) throws Exception {
        InitialLoadersFactory.addBootCodeSources(bootLoader);
        InitialLoadersFactory.addJREExtensionCodeSources(extensionLoader);
        inConfiguration = true;
        MainClass result = config.configureLoaders();
        PolicyClassLoader mainLoader = result.getLoader();
        inConfiguration = false;
        InitialLoadersFactory.addExtensionCodeSources(config.getExtensionProperty(), config.getDefaultExtensionDirectory(), mainLoader, config, ConfigurationType.MAIN_EXTENSION_LIBRARY_ELEMENT);
        PolicyClassLoader apiLoader = ClassLoaderQuery.findLatestLoader(ClassLoadEnvironment.getAPILoaderName());
        InitialLoadersFactory.addExtensionCodeSources(config.getApiExtensionProperty(), config.getDefaultApiExtensionDirectory(), apiLoader, config, ConfigurationType.API_EXTENSION_LIBRARY_ELEMENT);
        InitialLoadersFactory.setSystemClassLoader(replaceSystemLoader);
        if (ClassLoadEnvironment.cleanJRELoaders()) {
            InitialLoadersFactory.cleanUpJRELoaders();
        }
        return result;
    }

    public static void transferFrameworkClasses(PolicyClassLoader loader) throws Exception {
        SharedCodeSource ourCodeSource = InitialLoadersFactory.addFrameworkCodeSource(loader);
        if (classTransferMode != 2) {
            InitialLoadersFactory.transferFrameworkClasses(ourCodeSource);
            config.updateFrameworkTransferClasses(fwTransferClasses);
        }
    }

    private static SharedCodeSource addFrameworkCodeSource(PolicyClassLoader loader) throws IOException {
        if (fwCodeSource == null) {
            File file = ClassLoaderQuery.getCodeSourceFileFor(XMLConfiguration.class);
            ConfigurationOrigin origin = new ConfigurationOrigin(ConfigurationType.MAIN_CLASS_PATH_ELEMENT, "java.class.path");
            fwCodeSource = loader.addCodeSource(file, origin);
        }
        return fwCodeSource;
    }

    public static File getHomeDirectory() {
        return homeDirectory;
    }

    public static SharedCodeSource getFrameworkCodeSource() {
        return fwCodeSource;
    }

    private static void addBootCodeSources(PolicyClassLoader loader) throws IOException {
        ConfigurationOrigin o1 = new ConfigurationOrigin(ConfigurationType.JRE_BOOT_SUN_BOOT_CLASS_PATH_PROPERTY, "sun.boot.class.path");
        InitialLoadersFactory.addCodeSourcesForProperty(loader, o1, false);
        ConfigurationOrigin o2 = new ConfigurationOrigin(ConfigurationType.JRE_BOOT_JAVA_LIBRARY_PATH_PROPERTY, "java.library.path");
        InitialLoadersFactory.addCodeSourcesForProperty(loader, o2, true);
    }

    private static void addJREExtensionCodeSources(PolicyClassLoader loader) throws IOException {
        ConfigurationOrigin nativeOrigin = new ConfigurationOrigin(ConfigurationType.JRE_EXTENSION_JRE_EXT_DIRS_NATIVE_PROPERTY, "java.ext.dirs");
        List extensionDirs = InitialLoadersFactory.addCodeSourcesForProperty(loader, nativeOrigin, true);
        List paths = new ArrayList();
        InitialLoadersFactory.addJarAndZipFilePaths(extensionDirs, paths, false);
        paths = ClassLoadEnvironment.filterJREExtensionCodeSource(paths);
        ConfigurationOrigin origin = new ConfigurationOrigin(ConfigurationType.JRE_EXTENSION_JRE_EXT_DIRS_PROPERTY, "java.ext.dirs");
        InitialLoadersFactory.addCodeSources(loader, paths, origin, false, false);
    }

    private static void addExtensionCodeSources(String extensionProperty, String defaultExtensionDir, PolicyClassLoader loader, InitialLoadersConfiguration config, ConfigurationType type) throws IOException {
        List extensionDirs = PropertyUtils.getPathsFromProperty(extensionProperty);
        if (extensionDirs.size() == 0) {
            File extDir = new File(defaultExtensionDir);
            if (!extDir.isAbsolute()) {
                extDir = new File(config.getHomeDirectory(), defaultExtensionDir);
            }
            extensionDirs.add(extDir.getPath());
        }
        ArrayList paths = new ArrayList();
        InitialLoadersFactory.addJarAndZipFilePaths(extensionDirs, paths, true);
        if (paths.size() > 0) {
            ConfigurationOrigin origin = new ConfigurationOrigin(type, extensionProperty);
            InitialLoadersFactory.addCodeSources(loader, paths, origin, false, true);
        }
    }

    private static List addCodeSourcesForProperty(PolicyClassLoader loader, ConfigurationOrigin origin, boolean isNative) throws IOException {
        List paths = PropertyUtils.getPathsFromProperty(origin.getOrigin());
        InitialLoadersFactory.addCodeSources(loader, paths, origin, isNative, false);
        return paths;
    }

    private static void addCodeSources(PolicyClassLoader loader, List paths, ConfigurationOrigin origin, boolean isNative, boolean isBootExtension) throws IOException {
        Iterator iterator = paths.iterator();
        while (iterator.hasNext()) {
            String path = ((String)iterator.next()).replace('\\', '/');
            if (isNative) {
                loader.addNativeCodeSource(path, origin);
                continue;
            }
            SharedCodeSource cs = loader.addCodeSource(path, origin);
            if (cs == null || !isBootExtension) continue;
            InitialLoadersFactory.initExtension(cs, loader);
        }
    }

    private static void initExtension(SharedCodeSource cs, PolicyClassLoader loader) {
        try {
            Attributes attributes;
            String className;
            Manifest manifest = cs.getManifest();
            if (manifest != null && (className = (attributes = manifest.getMainAttributes()).getValue(ClassLoadEnvironment.getExtensionInitAttribute())) != null) {
                Class clz = loader.loadClass(className);
                Method main = clz.getMethod(MAIN_CONFIG, String[].class);
                main.invoke(null, new Object[]{mainArguments});
            }
        }
        catch (Exception e) {
            ClassLoadLogger.log(Level.WARNING, "Unable to initialize extension '" + cs + "'. Caught " + e);
        }
    }

    private static void addJarAndZipFilePaths(List dirs, List paths, boolean includeDirs) {
        Iterator iterator = dirs.iterator();
        while (iterator.hasNext()) {
            String[] files;
            File dir = new File((String)iterator.next());
            if (includeDirs) {
                paths.add(dir.getAbsolutePath());
            }
            if ((files = dir.list()) == null) continue;
            for (int j = 0; j < files.length; ++j) {
                String fileName;
                File file = new File(dir, files[j]);
                if (!file.isFile() || !(fileName = file.getName()).endsWith(".jar") && !fileName.endsWith(".zip")) continue;
                paths.add(file.getAbsolutePath());
            }
        }
    }

    public static boolean inConfig() {
        return inConfiguration;
    }

    public static boolean configureMainAsSystemLoader() {
        if (mainArguments == null) {
            configureMainAsSystemLoader = ClassLoadEnvironment.setMainAsSystemLoader();
        }
        return configureMainAsSystemLoader;
    }

    public static String getSystemLoaderName() {
        if (InitialLoadersFactory.configureMainAsSystemLoader()) {
            return ClassLoadEnvironment.getMainLoaderName();
        }
        return ClassLoadEnvironment.getAPILoaderName();
    }

    public static VersionNumber getSystemLoaderVersionNumber() {
        if (InitialLoadersFactory.configureMainAsSystemLoader()) {
            return ClassLoadEnvironment.getMainVersion();
        }
        return ClassLoadEnvironment.getAPIVersion();
    }

    public static ConfigurationOrigin createSystemLoaderOrigin() {
        String config = InitialLoadersFactory.configureMainAsSystemLoader() ? MAIN_CONFIG : SYSTEM_CONFIG;
        return InitialLoadersFactory.createOriginFor(config, InitialLoadersFactory.getConfigurationOrigin());
    }

    public static ConfigurationPolicy createSystemLoaderConfigurationPolicy() {
        String config = InitialLoadersFactory.configureMainAsSystemLoader() ? MAIN_CONFIG : SYSTEM_CONFIG;
        return InitialLoadersFactory.getConfigurationPolicyFor(config);
    }

    public static SearchPolicy createSystemLoaderSearchPolicy() {
        String config = InitialLoadersFactory.configureMainAsSystemLoader() ? MAIN_CONFIG : SYSTEM_CONFIG;
        return InitialLoadersFactory.createSearchPolicyFor(config);
    }

    public static ProtectionPolicy createSystemLoaderProtectionPolicy() {
        String config = InitialLoadersFactory.configureMainAsSystemLoader() ? MAIN_CONFIG : SYSTEM_CONFIG;
        return InitialLoadersFactory.createProtectionPolicyFor(config);
    }

    public static ConfigurationOrigin createOriginFor(String configurationName, String origin) {
        if (configurationName.equals(BOOT_CONFIG)) {
            return new ConfigurationOrigin(ConfigurationType.JRE_BOOT_LOADER, origin);
        }
        if (configurationName.equals(EXTENSION_CONFIG)) {
            return new ConfigurationOrigin(ConfigurationType.JRE_EXTENSION_LOADER, origin);
        }
        if (configurationName.equals(SYSTEM_CONFIG)) {
            return new ConfigurationOrigin(ConfigurationType.BOOT_SYSTEM_CLASS_LOADER_ELEMENT, origin);
        }
        if (configurationName.equals(SHARED_CONFIG)) {
            return new ConfigurationOrigin(ConfigurationType.BOOT_SHARED_CLASS_LOADER_ELEMENT, origin);
        }
        if (configurationName.equals(MAIN_CONFIG)) {
            return new ConfigurationOrigin(ConfigurationType.BOOT_MAIN_CLASS_LOADER_ELEMENT, origin);
        }
        return null;
    }

    public static SearchPolicy createSearchPolicyFor(String configurationName) {
        if (configurationName.equals(BOOT_CONFIG)) {
            return new JVMSearchPolicy();
        }
        if (configurationName.equals(EXTENSION_CONFIG)) {
            return SearchPolicy.STANDARD;
        }
        if (configurationName.equals(SYSTEM_CONFIG)) {
            if (ClassLoadEnvironment.isJavaSystemClassLoader()) {
                return SearchPolicy.BOOTSTRAP;
            }
            return SearchSequence.STANDARD;
        }
        if (configurationName.equals(SHARED_CONFIG)) {
            return SearchSequence.STANDARD;
        }
        if (configurationName.equals(MAIN_CONFIG)) {
            return new SearchSequence("MAIN", new SearchPolicy[]{SearchPolicy.FIND_LOADED_CLASS, SearchPolicy.ASK_PARENT, SearchPolicy.CHECK_SHARED_LIBRARIES, InitialLoadersFactory.createFrameworkClassesSearchPolicy(), SearchPolicy.FIND_LOCAL});
        }
        return null;
    }

    private static SearchPolicy createFrameworkClassesSearchPolicy() {
        if (classTransferMode == 2) {
            return new DelegatingSearchPolicy("checkJRESystem", JRE_SYSTEM_LOADER);
        }
        return new MappedSearchPolicy(fwTransferClasses);
    }

    public static ConfigurationPolicy getConfigurationPolicyFor(String configurationName) {
        if (configurationName.equals(BOOT_CONFIG)) {
            return ConfigurationPolicy.JRE_BOOT;
        }
        if (configurationName.equals(EXTENSION_CONFIG)) {
            return ConfigurationPolicy.JRE_EXTENSION;
        }
        if (configurationName.equals(SYSTEM_CONFIG)) {
            return ConfigurationPolicy.API;
        }
        if (configurationName.equals(SHARED_CONFIG)) {
            return ConfigurationPolicy.SHARED_BOOT_PUBLIC;
        }
        if (configurationName.equals(SHARED_CONFIG_PRIVATE)) {
            return ConfigurationPolicy.SHARED_BOOT_PRIVATE;
        }
        if (configurationName.equals(MAIN_CONFIG)) {
            return ConfigurationPolicy.MAIN;
        }
        return null;
    }

    public static ProtectionPolicy createProtectionPolicyFor(String configurationName) {
        if (configurationName.equals(BOOT_CONFIG)) {
            return ProtectionPolicy.ALL_PERMISSIONS;
        }
        if (configurationName.equals(EXTENSION_CONFIG)) {
            return ProtectionPolicy.JRE_EXTENSION_PERMISSIONS;
        }
        if (configurationName.equals(SYSTEM_CONFIG)) {
            return ProtectionPolicy.MAIN_PERMISSIONS;
        }
        if (configurationName.equals(SHARED_CONFIG)) {
            return ProtectionPolicy.MAIN_PERMISSIONS;
        }
        if (configurationName.equals(MAIN_CONFIG)) {
            return ProtectionPolicy.MAIN_PERMISSIONS;
        }
        return null;
    }

    private static void transferFrameworkClasses(SharedCodeSource ourCodeSource) throws ClassNotFoundException, IOException {
        List loadedClasses;
        Class<InitialLoadersFactory> ourClass = InitialLoadersFactory.class;
        ClassLoader sourceLoader = ourClass.getClassLoader();
        if (classTransferMode == 1 || (loadedClasses = ClassLoaderQuery.getLoadedClasses(sourceLoader)).isEmpty()) {
            InitialLoadersFactory.populateFrameworkTransferClasses(sourceLoader, ourCodeSource);
        } else {
            InitialLoadersFactory.populateFrameworkTransferClasses(sourceLoader, loadedClasses);
        }
    }

    private static void populateFrameworkTransferClasses(ClassLoader sourceLoader, SharedCodeSource ourCodeSource) throws IOException, ClassNotFoundException {
        String[] paths = ourCodeSource.listFilePaths();
        for (int i = 0; i < paths.length; ++i) {
            String className;
            String path = paths[i];
            if (!path.endsWith(".class") || !config.shouldTransferClass(className = path.substring(0, path.length() - 6).replace('/', '.'))) continue;
            Class<?> clz = sourceLoader.loadClass(className);
            fwTransferClasses.put(className, clz);
        }
    }

    private static void populateFrameworkTransferClasses(ClassLoader sourceLoader, List loadedClasses) throws ClassNotFoundException {
        for (int i = 0; i < ClassLoadEnvironment.FIXED_TRANSFER_CLASSES.length; ++i) {
            String className = ClassLoadEnvironment.FIXED_TRANSFER_CLASSES[i];
            Class clz = sourceLoader.loadClass(className);
            fwTransferClasses.put(className, clz);
        }
        List extras = ClassLoadEnvironment.getExtraTransferClasses();
        if (extras != null) {
            for (String className : extras) {
                Class<?> clz = sourceLoader.loadClass(className);
                fwTransferClasses.put(className, clz);
            }
        }
        for (Class clz : loadedClasses) {
            String className = clz.getName();
            if (!config.shouldTransferClass(className)) continue;
            fwTransferClasses.put(className, clz);
        }
    }

    public static Map getFrameworkTransferClasses() {
        return fwTransferClasses;
    }

    private static void cleanUpJRELoaders() throws IllegalAccessException {
        DateFormat.getAvailableLocales();
        try {
            Field ucpField = URLClassLoader.class.getDeclaredField("ucp");
            ucpField.setAccessible(true);
            ucpField.set(JRE_SYSTEM_LOADER.getParent(), null);
        }
        catch (NoSuchFieldException e) {
            ClassLoadLogger.log(Level.WARNING, "BootStrap: Unable to free 'ucp' field. Ignoring.");
        }
        try {
            Field parentField = ClassLoader.class.getDeclaredField("parent");
            parentField.setAccessible(true);
            parentField.set(JRE_SYSTEM_LOADER, null);
        }
        catch (NoSuchFieldException e) {
            ClassLoadLogger.log(Level.WARNING, "BootStrap: Unable to free 'parent' field. Ignoring.");
        }
    }

    static {
        fwTransferClasses = new HashMap();
    }
}

