/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import oracle.classloader.util.ClassLoadLogger;

public abstract class LoadedClasses {
    private static LoadedClasses accessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getClassesLoadedBy(ClassLoader loader) {
        if (accessor == null) {
            accessor = LoadedClasses.getAccessor();
        }
        try {
            ClassLoader classLoader = loader;
            synchronized (classLoader) {
                return accessor.doGet(loader);
            }
        }
        catch (Throwable e) {
            return Collections.EMPTY_LIST;
        }
    }

    private static LoadedClasses getAccessor() {
        LoadedClasses result = null;
        try {
            Field classes = ClassLoader.class.getDeclaredField("classes");
            classes.setAccessible(true);
            if (List.class.isAssignableFrom(classes.getType())) {
                result = new ListAccessor(classes);
            } else if (classes.getType() == Class.class) {
                Field next = Class.class.getDeclaredField("nextClass");
                next.setAccessible(true);
                result = new LinkedClass(classes, next);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result == null) {
            result = new Empty();
        }
        return result;
    }

    protected abstract List doGet(ClassLoader var1) throws Exception;

    private static class LinkedClass
    extends LoadedClasses {
        private Field classes;
        private Field next;

        LinkedClass(Field classes, Field next) {
            this.classes = classes;
            this.next = next;
        }

        protected List doGet(ClassLoader loader) throws Exception {
            ArrayList<Class> result = new ArrayList<Class>();
            Class clz = (Class)this.classes.get(loader);
            result.add(clz);
            clz = (Class)this.next.get(clz);
            while (clz != null) {
                result.add(clz);
                clz = (Class)this.next.get(clz);
            }
            return result;
        }
    }

    private static class ListAccessor
    extends LoadedClasses {
        private Field field;

        ListAccessor(Field field) {
            this.field = field;
        }

        protected List doGet(ClassLoader loader) throws Exception {
            List list = (List)this.field.get(loader);
            return new ArrayList(list);
        }
    }

    private static class Empty
    extends LoadedClasses {
        private boolean warned;

        private Empty() {
        }

        protected List doGet(ClassLoader loader) {
            if (!this.warned) {
                ClassLoadLogger.log(Level.WARNING, "no.loaded.classes");
                this.warned = true;
            }
            return Collections.EMPTY_LIST;
        }
    }
}

