/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import oracle.classloader.ClosedLoaderReference;
import oracle.classloader.EventDispatcher;
import oracle.classloader.LoaderLifeCycleListener;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.GarbageCollection;
import oracle.classloader.util.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoaderLeakDetector
implements LoaderLifeCycleListener {
    public static boolean ORACLE_DOMAIN = LoaderLeakDetector.isOracleDomain();
    public static boolean LEAK_ASSERTION_ENABLED = LoaderLeakDetector.isLeakAssertionEnabled();
    private static boolean WAIT_ON_LEAK = PropertyUtils.getBooleanProperty("wait.on.leak", false);
    private static final String EOL = ClassLoadLogger.EOL;
    private static final String LINE = "====================================================================================" + EOL;
    private static final String WIKI = EOL + "For details on loader leaks, please visit:" + EOL + EOL + "   http://aseng-wiki.us.oracle.com/asengwiki/display/ASDevJ2EE/ClassLoader+Leaks" + EOL + EOL + "Set -Dwait.on.leak when re-running to pause here and attach profiler." + EOL + LINE;
    private static final String ASSERTION_NOTICE = "In Oracle test environment, checking for loader leaks (set -Dfail.on.leak=false to disable).";
    private static volatile LoaderLeakDetector detector;
    private Set<ClosedLoaderReference> closedLoaders = new HashSet<ClosedLoaderReference>();

    private static boolean isOracleDomain() {
        boolean result = false;
        try {
            result = InetAddress.getLocalHost().getCanonicalHostName().endsWith("oracle.com");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static boolean isLeakAssertionEnabled() {
        String failOnLeak = PropertyUtils.getProperty("fail.on.leak", null);
        if (failOnLeak == null) {
            if (PropertyUtils.getProperty("memory.leak.debug", null) != null) {
                return false;
            }
            return LoaderLeakDetector.isOracleTestEnvironment();
        }
        return "true".equalsIgnoreCase(failOnLeak);
    }

    private LoaderLeakDetector() {
    }

    public static void assertNoLeaksIfEnabled(State state) {
        if (LEAK_ASSERTION_ENABLED) {
            switch (state) {
                case SERVER_RESTARTED: {
                    LoaderLeakDetector.assertNoLoaderLeaks(state);
                    break;
                }
            }
        }
    }

    public static void assertNoLoaderLeaks(State state) {
        ClassLoadLogger.log(Level.INFO, ASSERTION_NOTICE);
        List<ClosedLoaderReference> leaked = LoaderLeakDetector.getClosedButNotCollected(true);
        if (leaked != null && leaked.size() > 0) {
            StringBuilder msg = new StringBuilder(4096);
            msg.append(EOL);
            msg.append(LINE);
            msg.append(EOL);
            msg.append("ClassLoader leaks detected (");
            msg.append((Object)state);
            msg.append("):");
            msg.append(EOL);
            msg.append(EOL);
            for (ClosedLoaderReference ref : leaked) {
                msg.append("    ");
                msg.append(ref);
                msg.append(". Creation stack:");
                msg.append(EOL);
                for (StackTraceElement e : ref.getCreationStack()) {
                    msg.append("    ");
                    msg.append(e);
                    msg.append(EOL);
                }
                msg.append(EOL);
            }
            msg.append(WIKI);
            if (WAIT_ON_LEAK) {
                ClassLoadLogger.log(Level.INFO, msg.toString());
                LoaderLeakDetector.waitForEnterKey("continue");
            }
            throw new IllegalStateException(msg.toString());
        }
        ClassLoadLogger.log(Level.INFO, "No leaked loaders found.");
    }

    public static void waitForEnterKey(String nextAction) {
        ClassLoadLogger.log(Level.INFO, "Press ENTER to " + nextAction + "...");
        try {
            int c = 0;
            while (c != 10) {
                c = System.in.read();
            }
            ClassLoadLogger.log(Level.INFO, "Proceeding with " + nextAction + "...");
        }
        catch (IOException e) {
            ClassLoadLogger.log(Level.INFO, "Caught " + e + " while waiting. Moving on...");
        }
    }

    public static void doPeriodicMaintenance(int currentMaintenanceTick) {
        LoaderLeakDetector.countLeaks(false);
    }

    public static int countLeaks(boolean forceGC) {
        int result = 0;
        LoaderLeakDetector d = detector;
        if (d != null) {
            result = d.doCountLeaks(forceGC);
        }
        return result;
    }

    private static boolean isOracleTestEnvironment() {
        return ORACLE_DOMAIN && System.getenv("T_WORK") != null;
    }

    private synchronized int countClosedButNotCollected() {
        if (this.closedLoaders != null && !this.closedLoaders.isEmpty()) {
            ClosedLoaderReference ref;
            GarbageCollection.log("Closed loaders count before polling queue: " + this.closedLoaders.size());
            while ((ref = ClosedLoaderReference.poll()) != null) {
                GarbageCollection.log("Removing enqueued reference: " + ref);
                this.closedLoaders.remove(ref);
            }
            GarbageCollection.log("Closed loaders count after polling queue: " + this.closedLoaders.size());
            return this.closedLoaders.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ClosedLoaderReference> copyClosedButNotCollected(boolean forceGC) {
        if (this.doCountLeaks(forceGC) > 0 && this.doCountLeaks(forceGC) > 0) {
            LoaderLeakDetector loaderLeakDetector = this;
            synchronized (loaderLeakDetector) {
                if (this.countClosedButNotCollected() > 0) {
                    return new ArrayList<ClosedLoaderReference>(this.closedLoaders);
                }
            }
        }
        return Collections.emptyList();
    }

    private int doCountLeaks(boolean forceGC) {
        int count = this.countClosedButNotCollected();
        if (count > 0 && forceGC) {
            this.forceGC();
            count = this.countClosedButNotCollected();
        }
        return count;
    }

    public static List<ClosedLoaderReference> getClosedButNotCollected(boolean forceCollection) {
        LoaderLeakDetector d = detector;
        if (d != null) {
            return d.copyClosedButNotCollected(forceCollection);
        }
        return null;
    }

    public static boolean activate() {
        if (detector == null) {
            detector = new LoaderLeakDetector();
            EventDispatcher.addListener(detector);
            GarbageCollection.log("Loader leak detection activated.");
            return true;
        }
        return false;
    }

    public static boolean isActive() {
        return detector != null;
    }

    public static boolean deactivate() {
        if (detector != null) {
            EventDispatcher.removeListener(detector);
            detector = null;
            GarbageCollection.log("Loader leak detection deactivated.");
            return true;
        }
        return false;
    }

    public boolean forceGC() {
        return GarbageCollection.forceCollection(new GarbageCollection.Goal(){

            public boolean reached() {
                return LoaderLeakDetector.this.countClosedButNotCollected() == 0;
            }
        });
    }

    @Override
    public void loaderCreated(PolicyClassLoader loader) {
    }

    @Override
    public void loaderCommitted(PolicyClassLoader loader) {
    }

    @Override
    public void loaderClosing(PolicyClassLoader loader) {
    }

    @Override
    public synchronized void loaderDestroyed(PolicyClassLoader loader) {
        ClosedLoaderReference ref = new ClosedLoaderReference(loader);
        this.closedLoaders.add(ref);
    }

    @Override
    public void loaderCollected(String loaderName, String loaderIdentityHashCode) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        SERVER_STARTED,
        SERVER_DESTROYED,
        SERVER_RESTARTED,
        APPLICATION_STOPPED,
        APPLICATION_UNDEPLOYED;

    }
}

