/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import oracle.classloader.util.SimpleLogFormatter;

public class LogStreamHandler
extends StreamHandler {
    private boolean doNotClose;
    private File file;

    public LogStreamHandler() {
        this(System.out);
    }

    public LogStreamHandler(String file) throws Exception {
        this(file == null ? null : new File(file));
    }

    public LogStreamHandler(File file) throws Exception {
        this(file == null ? null : new FileOutputStream(file, true), new SimpleLogFormatter());
        this.file = file.getAbsoluteFile();
    }

    public LogStreamHandler(OutputStream out) {
        this(out, new SimpleLogFormatter());
    }

    public LogStreamHandler(OutputStream out, Formatter formatter) {
        super(LogStreamHandler.getStream(out), formatter);
        this.setLevel(Level.ALL);
        if (out == null || out == System.out || out == System.err) {
            this.doNotClose = true;
        }
    }

    public File getFile() {
        return this.file;
    }

    private static OutputStream getStream(OutputStream out) {
        if (out == null) {
            out = System.out;
        }
        return out;
    }

    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    public void close() {
        if (this.doNotClose) {
            this.flush();
        } else {
            super.close();
        }
    }
}

