/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.DependentClass;
import oracle.classloader.util.ExecutionStack;
import oracle.classloader.util.LocalizedText;

public class MissingClass
extends DependentClass {
    private static ThreadLocal list = new ThreadLocal();
    private String missingClassName;
    private MissingClass next;
    private List candidateCodeSources;

    public MissingClass(String missingClassName, PolicyClassLoader initiatingLoader, ExecutionStack stack) {
        super(initiatingLoader, stack);
        this.missingClassName = missingClassName;
    }

    public MissingClass(NoClassDefFoundError error, String dependentClassName, PolicyClassLoader dependentClassLoader, String dependentClassCodeSource, String dependentClassOrigin, ExecutionStack stack) {
        super(dependentClassName, dependentClassLoader, dependentClassCodeSource, dependentClassOrigin, stack);
        String name = error.getMessage();
        name = name == null ? "unknown!" : name.replace('/', '.');
        this.missingClassName = name;
    }

    protected String createDescription(LocalizedText localizedText, String dependentClassName, String dependentClassLoaderName, String dependentClassCodeSource, String dependentClassOrigin, String initiatingClassLoaderName) {
        String dynamicLoadMethod = null;
        ExecutionStack stack = this.getExecutionStack();
        if (stack != null) {
            if (stack.didCallerInvokeClassForName()) {
                dynamicLoadMethod = "Class.forName()";
            } else if (stack.didCallerInvokeLoadClass()) {
                dynamicLoadMethod = "loadClass()";
            }
        }
        if (dynamicLoadMethod == null) {
            return localizedText.getText("missing.class", new Object[]{this.missingClassName, dependentClassName, dependentClassLoaderName, dependentClassCodeSource, dependentClassOrigin});
        }
        return localizedText.getText("missing.class.dynamic", new Object[]{this.missingClassName, dependentClassName, dependentClassLoaderName, dependentClassCodeSource, dependentClassOrigin, initiatingClassLoaderName, dynamicLoadMethod});
    }

    protected String getAnalysis(LocalizedText localizedText, PolicyClassLoader dependentLoader, PolicyClassLoader initiatingLoader) {
        this.candidateCodeSources = MissingClass.getAvailableElsewhere(this.missingClassName, initiatingLoader);
        if (this.candidateCodeSources.isEmpty()) {
            return localizedText.getText("missing.class.not.available");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(localizedText.getText("missing.class.available"));
        int codeSourceNumber = 1;
        for (SharedCodeSource source : this.candidateCodeSources) {
            buffer.append(localizedText.getText("numbered.code.source", Integer.toString(codeSourceNumber++), source.toString()));
            Object[] subscribers = source.getSubscribers().getSubscribers();
            if (ArrayUtils.countNonNull(subscribers, subscribers.length) == 0) {
                buffer.append(localizedText.getText("code.source.not.used"));
                continue;
            }
            for (int i = 0; i < subscribers.length; ++i) {
                Object subscriber = subscribers[i];
                if (subscriber == null) continue;
                if (subscriber == initiatingLoader && subscriber == ClassLoaderQuery.getMainLoader() && source == ClassLoaderQuery.getFrameworkCodeSource()) {
                    buffer.append(localizedText.getText("code.source.boot"));
                    continue;
                }
                String comment = this.getCommentFor((PolicyClassLoader)subscriber, localizedText, initiatingLoader);
                buffer.append(localizedText.getText("code.source.used.by", ((PolicyClassLoader)subscriber).getUniqueName(), comment));
            }
        }
        return buffer.toString();
    }

    private String getCommentFor(PolicyClassLoader loader, LocalizedText localizedText, PolicyClassLoader initiatingLoader) {
        String result = "";
        if (loader.isSharedLoader()) {
            if (initiatingLoader.isApplicationLoader()) {
                String appName = ClassLoadEnvironment.getApplicationName(initiatingLoader);
                result = localizedText.getText("missing.app.class.shared.loader", appName);
            } else if (initiatingLoader == ClassLoaderQuery.getMainLoader()) {
                result = localizedText.getText("missing.main.class.shared.loader", initiatingLoader.getName());
            }
        } else if (this.getExecutionStack() != null && this.getExecutionStack().didCallerInvokeClassForName() && Thread.currentThread().getContextClassLoader() == loader) {
            result = localizedText.getText("missing.class.for.name.thread.context");
        } else if (ClassLoaderQuery.isAncestor(initiatingLoader, loader)) {
            result = localizedText.getText("missing.class.child.loader", loader.getUniqueName(), initiatingLoader.getUniqueName());
        }
        return result;
    }

    public String getMissingClassName() {
        return this.missingClassName;
    }

    public List getAvailableElsewhere() {
        return MissingClass.getAvailableElsewhere(this.missingClassName, this.getInitiatingLoader());
    }

    public static List getAvailableElsewhere(String className, PolicyClassLoader initialLoader) {
        ArrayList<SharedCodeSource> result = new ArrayList<SharedCodeSource>();
        List visitedLoaders = ClassLoaderQuery.findLoadersVisitedBy(initialLoader);
        SharedCodeSource[] sources = ClassLoaderQuery.findCodeSourcesNotVisitedBy(visitedLoaders);
        String resourceName = className.replace('.', '/') + ".class";
        for (int i = 0; i < sources.length; ++i) {
            SharedCodeSource source = sources[i];
            try {
                if (!source.containsResource(resourceName)) continue;
                result.add(source);
                continue;
            }
            catch (IOException e) {
                Level level = Level.WARNING;
                if (source.getSubscribers().getCount() == 0) {
                    level = Level.FINE;
                }
                ClassLoadLogger.log(level, "IOException " + e.getMessage() + " processing " + source);
            }
        }
        return result;
    }

    public boolean mustThrowClassNotFound() {
        return this.getExecutionStack().mustThrowClassNotFound();
    }

    public void store() {
        MissingClass current = (MissingClass)list.get();
        if (current == null) {
            list.set(this);
        } else {
            while (current.next != null) {
                current = current.next;
            }
            current.next = this;
        }
    }

    public static MissingClass remove(String missingClassName) {
        MissingClass previous = null;
        MissingClass current = (MissingClass)list.get();
        while (current != null) {
            MissingClass next = current.next;
            if (current.missingClassName.equals(missingClassName)) {
                if (previous == null) {
                    list.set(next);
                } else {
                    previous.next = next;
                }
                return current;
            }
            previous = current;
            current = next;
        }
        return null;
    }
}

