/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.classloader.util.ClassLoadLogger;

public class SimpleLogFormatter
extends Formatter {
    private static Date date = new Date();
    private static DateFormat dateFormat = new SimpleDateFormat("yy/MM/dd HH:mm:ss ");

    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        String message = record.getMessage() == null ? "" : this.formatMessage(record);
        date.setTime(record.getMillis());
        sb.append(dateFormat.format(date));
        int level = record.getLevel().intValue();
        if (level > Level.INFO.intValue()) {
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
        }
        sb.append(message);
        sb.append(ClassLoadLogger.EOL);
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                thrown.printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

