/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.classloader.EventDispatcher;
import oracle.classloader.LoaderLifeCycleListener;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.ClassLoadLogger;

public class URLHandlerFactory
implements URLStreamHandlerFactory {
    public static final String PREFIX_PROPERTY = "java.protocol.handler.pkgs";
    private static Hashtable urlCache;
    private static boolean warning;
    private static Map factories;
    private static URLHandlerFactory instance;

    private static URLStreamHandler removeHandlerFromURLCache(String protocol) {
        if (urlCache != null) {
            return (URLStreamHandler)urlCache.remove(protocol);
        }
        return null;
    }

    private static void init() {
        if (instance == null) {
            instance = new URLHandlerFactory();
            URL.setURLStreamHandlerFactory(instance);
        }
    }

    public static synchronized void register(String protocol, URLStreamHandler handler, boolean requiresNewInstance) {
        URLHandlerFactory.register(protocol, handler);
    }

    public static synchronized void register(String protocol, URLStreamHandler handler) {
        URLHandlerFactory.init();
        URLStreamHandler existing = (URLStreamHandler)factories.get(protocol);
        if (existing != null) {
            throw new IllegalStateException("'" + protocol + "' already registered to " + existing);
        }
        factories.put(protocol, handler);
        HandlerCleanup.checkHandler(protocol, handler);
    }

    public static synchronized URLStreamHandler remove(String protocol) {
        URLHandlerFactory.init();
        URLStreamHandler existing = (URLStreamHandler)factories.remove(protocol);
        if (existing != null) {
            URLHandlerFactory.removeHandlerFromURLCache(protocol);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized URLStreamHandler create(String protocol) {
        Class<URLHandlerFactory> clazz = URLHandlerFactory.class;
        synchronized (URLHandlerFactory.class) {
            URLStreamHandler handler = (URLStreamHandler)factories.get(protocol);
            if (handler != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return handler;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return URLHandlerFactory.createFromProperty(protocol);
        }
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        return URLHandlerFactory.create(protocol);
    }

    private static URLStreamHandler createFromProperty(String protocol) {
        URLStreamHandler result = null;
        String packagePrefixes = System.getProperty(PREFIX_PROPERTY);
        if (packagePrefixes != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (packagePrefixes.length() > 0) {
                packagePrefixes = packagePrefixes + "|";
            }
            StringTokenizer t = new StringTokenizer(packagePrefixes, "|");
            while (t.hasMoreTokens()) {
                String prefix = t.nextToken().trim();
                String className = prefix + "." + protocol + ".Handler";
                try {
                    Class<?> c = loader.loadClass(className);
                    result = (URLStreamHandler)c.newInstance();
                    HandlerCleanup.checkHandler(protocol, result);
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        return result;
    }

    static {
        try {
            Field field = URL.class.getDeclaredField("handlers");
            field.setAccessible(true);
            urlCache = (Hashtable)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        factories = new HashMap();
    }

    private static class HandlerCleanup
    implements LoaderLifeCycleListener {
        private static List protocols;

        private HandlerCleanup() {
        }

        static void checkHandler(String protocol, URLStreamHandler handler) {
            if (urlCache != null) {
                PolicyClassLoader pcl;
                ClassLoader loader = handler.getClass().getClassLoader();
                if (loader != null && loader instanceof PolicyClassLoader && (pcl = (PolicyClassLoader)loader).isApplicationLoader()) {
                    if (protocols == null) {
                        protocols = new ArrayList();
                        EventDispatcher.addListener(new HandlerCleanup());
                    }
                    protocols.add(protocol);
                }
            } else if (!warning) {
                ClassLoadLogger.log(Level.WARNING, "Cannot cleanup application URLStreamHandlers.");
                warning = true;
            }
        }

        public void loaderCreated(PolicyClassLoader loader) {
        }

        public void loaderCommitted(PolicyClassLoader loader) {
        }

        public void loaderClosing(PolicyClassLoader loader) {
        }

        public void loaderDestroyed(PolicyClassLoader loader) {
            for (int i = protocols.size() - 1; i >= 0; --i) {
                String protocol = (String)protocols.get(i);
                URLStreamHandler handler = (URLStreamHandler)urlCache.get(protocol);
                if (handler.getClass().getClassLoader() != loader) continue;
                protocols.remove(i);
                URLHandlerFactory.removeHandlerFromURLCache(protocol);
            }
        }

        public void loaderCollected(String loaderName, String loaderIdentityHashCode) {
        }
    }
}

