/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.LocalizedText;

public class VersionNumber
implements Comparable {
    public static final VersionNumber ZERO = new VersionNumber(false);
    public static final VersionNumber MAX = new VersionNumber(true);
    public static final int PRE_RELEASE_VERSION = 0;
    public static final int RELEASE_VERSION = 1;
    public static final int PATCH_RELEASE_VERSION = 2;
    public static final int INVALID_VERSION_TOO_MANY_DIGITS = -1;
    public static final int INVALID_VERSION_NON_DIGIT = -2;
    public static final int INVALID_VERSION_PRE_AND_PATCH = -3;
    public static final int NO_MILESTONE = 0;
    public static final int NO_PATCH = 0;
    public static final int MAX_COMPONENT_VALUE = 99999999;
    public static final int WILD_COMPONENT_VALUE = -1;
    private static final int MAX_DIGITS = 8;
    public static final int UNKNOWN_MILESTONE = -6;
    public static final int EA_MILESTONE = -5;
    public static final int ALPHA_MILESTONE = -4;
    public static final int BETA_MILESTONE = -3;
    public static final int RC_MILESTONE = -2;
    public static final int WILD_MILESTONE = -1;
    static final int MAX_DOT_VALUES = 8;
    private static final String EA_PREFIX = "ea";
    private static final String ALPHA_PREFIX = "alpha";
    private static final String BETA_PREFIX = "beta";
    private static final String RC_PREFIX = "rc";
    private static final String WILD_VALUE = "*";
    private static final String[] ERROR_KEYS = new String[]{"version.too.long", "version.non.digit", "version.both"};
    private static final String VERSION_FORMAT_KEY = "version.format";
    private String versionStr;
    private boolean wild;
    private int[] values = new int[8];
    private int milestone;
    private int milestoneNumber;
    private int patch;
    private int type;

    private VersionNumber(boolean maxValue) {
        if (maxValue) {
            this.type = 2;
            StringBuffer buffer = new StringBuffer();
            String maxValueStr = Integer.toString(99999999);
            for (int i = 0; i < 8; ++i) {
                this.values[i] = 99999999;
                if (i > 0) {
                    buffer.append('.');
                }
                buffer.append(maxValueStr);
            }
            buffer.append('_');
            buffer.append(maxValueStr);
            this.versionStr = buffer.toString();
            this.patch = 99999999;
        } else {
            this.versionStr = "0.0.0";
        }
    }

    public VersionNumber(String version) {
        this(version, false, true);
    }

    public VersionNumber(int n0, int n1, int n2) {
        this(n0, n1, n2, 0, 0);
    }

    public VersionNumber(int n0, int n1, int n2, int n3, int n4) {
        if (n0 > 99999999 || n1 > 99999999 || n2 > 99999999 || n3 > 99999999 || n4 > 99999999) {
            this.fail(-1, true);
        }
        this.type = 1;
        this.values[0] = n0;
        this.values[1] = n1;
        this.values[2] = n2;
        this.values[3] = n3;
        this.values[4] = n4;
        StringBuffer buffer = new StringBuffer();
        buffer.append(n0);
        buffer.append('.');
        buffer.append(n1);
        buffer.append('.');
        buffer.append(n2);
        if (n3 != 0 || n4 != 0) {
            buffer.append('.');
            buffer.append(n3);
            if (n4 != 0) {
                buffer.append('.');
                buffer.append(n4);
            }
        }
        this.versionStr = buffer.toString();
    }

    public VersionNumber(String version, boolean allowWild, boolean failHard) {
        this.versionStr = version.trim();
        this.type = 1;
        if (failHard) {
            this.parse(allowWild, true);
        } else {
            try {
                this.parse(allowWild, false);
            }
            catch (NumberFormatException e) {
                for (int i = 0; i < 8; ++i) {
                    this.values[i] = 0;
                }
                this.milestone = 0;
                this.milestoneNumber = 0;
                this.patch = 0;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean isValid() {
        return this.type >= 0;
    }

    public boolean hasWild() {
        return this.wild;
    }

    public int getVersionAt(int index) {
        return this.values[index];
    }

    public int getMilestone() {
        return this.milestone;
    }

    public int getMilestoneNumber() {
        return this.milestoneNumber;
    }

    public int getPatchNumber() {
        return this.patch;
    }

    public String toString() {
        return this.versionStr;
    }

    public boolean equals(Object other) {
        try {
            VersionNumber target = (VersionNumber)other;
            return this.typeEquals(target) && this.arraysEqual(target) && VersionNumber.componentEquals(this.milestone, target.milestone) && VersionNumber.componentEquals(this.milestoneNumber, target.milestoneNumber) && VersionNumber.componentEquals(this.patch, target.patch);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private boolean typeEquals(VersionNumber other) {
        if (this.type == other.type) {
            return true;
        }
        if (this.type == 0) {
            return false;
        }
        if (other.type == 0) {
            return false;
        }
        if (this.patch == -1) {
            return true;
        }
        return other.patch == -1;
    }

    private boolean arraysEqual(VersionNumber other) {
        int[] left = this.values;
        int[] right = other.values;
        for (int i = 0; i < 8; ++i) {
            if (VersionNumber.componentEquals(left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean componentEquals(int c1, int c2) {
        return c1 == -1 || c2 == -1 || c1 == c2;
    }

    public int compare(VersionNumber other) {
        int result;
        if (this.type < 0) {
            return -1;
        }
        if (other.type < 0) {
            return 1;
        }
        int[] left = this.values;
        int[] right = other.values;
        for (int i = 0; i < 8; ++i) {
            result = VersionNumber.compare(left[i], right[i]);
            if (result == 2) continue;
            return result;
        }
        result = VersionNumber.compare(this.milestone, other.milestone);
        if (result != 2) {
            return result;
        }
        result = VersionNumber.compare(this.milestoneNumber, other.milestoneNumber);
        if (result != 2) {
            return result;
        }
        result = VersionNumber.compare(this.patch, other.patch);
        if (result != 2) {
            return result;
        }
        return 0;
    }

    private static int compare(int left, int right) {
        if (left == -1) {
            return 0;
        }
        if (right == -1) {
            return 0;
        }
        if (left < right) {
            return -1;
        }
        if (left > right) {
            return 1;
        }
        return 2;
    }

    public int compareTo(Object other) {
        return this.compare((VersionNumber)other);
    }

    public boolean inRange(VersionNumber min, VersionNumber max) {
        return !(min != null && this.compare(min) < 0 || max != null && this.compare(max) > 0);
    }

    private void parse(boolean allowWild, boolean addMessageOnFail) {
        String version = this.versionStr;
        int startIndex = 0;
        int length = version.length();
        int space = version.indexOf(32);
        if (space >= 0) {
            length = space;
        }
        if (length == 0 || !Character.isDigit(version.charAt(0))) {
            this.fail(-2, addMessageOnFail);
        }
        if (version.charAt(length - 1) == '*') {
            if (!allowWild) {
                this.fail(-2, addMessageOnFail);
            }
            this.wild = true;
            for (int i = 0; i < 8; ++i) {
                this.values[i] = -1;
            }
            this.patch = -1;
        }
        boolean done = false;
        for (int i = 0; i < 8; ++i) {
            int dotIndex = version.indexOf(46, startIndex);
            this.values[i] = this.getVersionComponent(startIndex, dotIndex, length, allowWild, addMessageOnFail);
            startIndex = dotIndex + 1;
            if (dotIndex >= 0) continue;
            done = true;
            break;
        }
        if (!done) {
            this.fail(-1, addMessageOnFail);
        }
        if (this.wild && this.type == 1) {
            this.type = 2;
        }
    }

    private int getVersionComponent(int startIndex, int endIndex, int maxIndex, boolean allowWild, boolean addMessageOnFail) {
        boolean hasMoreComponents;
        int version = 0;
        boolean bl = hasMoreComponents = endIndex >= 0;
        if (!hasMoreComponents) {
            endIndex = maxIndex;
        }
        String value = this.versionStr.substring(startIndex, endIndex);
        int preReleaseIndex = value.indexOf(45);
        int patchReleaseIndex = value.indexOf(95);
        if (preReleaseIndex >= 0) {
            if (hasMoreComponents) {
                this.fail(-2, addMessageOnFail);
            }
            if (patchReleaseIndex >= 0) {
                this.fail(-3, addMessageOnFail);
            }
            this.type = 0;
            this.patch = 0;
            version = this.parseInt(value.substring(0, preReleaseIndex), allowWild, addMessageOnFail);
            String milestoneName = value.substring(preReleaseIndex + 1).toLowerCase();
            int milestoneNumberLength = milestoneName.length();
            int milestoneNumberOffset = 0;
            if (milestoneName.startsWith(EA_PREFIX)) {
                this.milestone = -5;
                milestoneNumberOffset = EA_PREFIX.length();
            } else if (milestoneName.startsWith(ALPHA_PREFIX)) {
                this.milestone = -4;
                milestoneNumberOffset = ALPHA_PREFIX.length();
            } else if (milestoneName.startsWith(BETA_PREFIX)) {
                this.milestone = -3;
                milestoneNumberOffset = BETA_PREFIX.length();
            } else if (milestoneName.startsWith(RC_PREFIX)) {
                this.milestone = -2;
                milestoneNumberOffset = RC_PREFIX.length();
            } else if (milestoneName.equals(WILD_VALUE)) {
                this.milestone = -1;
                this.milestoneNumber = -1;
                milestoneNumberOffset = milestoneNumberLength;
            } else {
                this.milestone = -6;
                milestoneNumberOffset = milestoneNumberLength;
                for (int i = 0; i < milestoneNumberLength; ++i) {
                    char c = milestoneName.charAt(i);
                    if (c < '0' || c > '9') continue;
                    milestoneNumberOffset = i;
                    break;
                }
            }
            if (milestoneNumberOffset < milestoneNumberLength) {
                this.milestoneNumber = this.parseInt(milestoneName.substring(milestoneNumberOffset), allowWild, addMessageOnFail);
            }
        } else if (patchReleaseIndex >= 0) {
            if (hasMoreComponents) {
                this.fail(-2, addMessageOnFail);
            }
            if (preReleaseIndex >= 0) {
                this.fail(-3, addMessageOnFail);
            }
            this.type = 2;
            version = this.parseInt(value.substring(0, patchReleaseIndex), allowWild, addMessageOnFail);
            this.patch = this.parseInt(value.substring(patchReleaseIndex + 1), allowWild, addMessageOnFail);
        } else {
            version = this.parseInt(value, allowWild, addMessageOnFail);
        }
        return version;
    }

    private int parseInt(String value, boolean allowWild, boolean addMessageOnFail) {
        int result = 0;
        int length = value.length();
        if (length > 8) {
            this.fail(-1, addMessageOnFail);
        } else if (length == 1 && value.charAt(0) == '*') {
            if (allowWild) {
                result = -1;
            } else {
                this.fail(-2, addMessageOnFail);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                if (c >= '0' && c <= '9') {
                    int digit = c - 48;
                    if (i > 0) {
                        result *= 10;
                    }
                    result += digit;
                    continue;
                }
                this.fail(-2, addMessageOnFail);
            }
        }
        return result;
    }

    private void fail(int type, boolean addMessageOnFail) {
        this.type = type;
        if (addMessageOnFail) {
            int index = -type - 1;
            String key = ERROR_KEYS[index];
            LocalizedText text = ClassLoadLogger.getText();
            String message = text.getText(key, this.versionStr);
            message = message + text.getText(VERSION_FORMAT_KEY);
            throw new NumberFormatException(message);
        }
        throw new NumberFormatException();
    }
}

