/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceSet;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.InitialLoadersConfiguration;
import oracle.classloader.util.InitialLoadersFactory;
import oracle.classloader.util.MainClass;
import oracle.classloader.util.VersionNumber;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration
extends DefaultHandler
implements InitialLoadersConfiguration {
    private static final String DEFAULT_EXTENSION_PROPERTY = ClassLoadEnvironment.getDefaultExtensionKey();
    private static final String DEFAULT_EXTENSION_DIRECTORY = ClassLoadEnvironment.getDefaultExtensionDirectory();
    private static final String DEFAULT_API_EXTENSION_PROPERTY = ClassLoadEnvironment.getDefaultApiExtensionKey();
    private static final String DEFAULT_API_EXTENSION_DIRECTORY = ClassLoadEnvironment.getDefaultApiExtensionDirectory();
    private static final String EXTERNAL_CLASSES_FILE_NAME = "external.classes";
    private static final String NULL_STRING = "null";
    private static final String[] ATTRIBUTES = new String[]{"name", "path", "manifest-dependencies", "defaults", "parent", "main-class", "code-source-equality", "extension-property", "default-extension-directory", "external-classes", "version", "alias", "if", "system-private", "root-dir"};
    private static final int NAME_ATTRIBUTE = 0;
    private static final int PATH_ATTRIBUTE = 1;
    private static final int MANIFEST_DEPENDENCIES_ATTRIBUTE = 2;
    private static final int DEFAULTS_ATTRIBUTE = 3;
    private static final int PARENT_ATTRIBUTE = 4;
    private static final int MAIN_CLASS_ATTRIBUTE = 5;
    private static final int CODE_SOURCE_EQUALITY_ATTRIBUTE = 6;
    private static final int EXTENSION_PROPERTY_ATTRIBUTE = 7;
    private static final int EXTENSION_DIRECTORY_ATTRIBUTE = 8;
    private static final int EXTERNAL_CLASSES_ATTRIBUTE = 9;
    private static final int VERSION_ATTRIBUTE = 10;
    private static final int ALIAS_ATTRIBUTE = 11;
    private static final int IF_ATTRIBUTE = 12;
    private static final int SYSTEM_PRIVATE_ATTRIBUTE = 13;
    private static final int ROOT_DIR_ATTRIBUTE = 14;
    private static final int EMPTY_MASK = 0;
    private static final int NAME_MASK = 1;
    private static final int PATH_MASK = 2;
    private static final int MANIFEST_DEPENDENCIES_MASK = 4;
    private static final int DEFAULTS_MASK = 8;
    private static final int PARENT_MASK = 16;
    private static final int MAIN_CLASS_MASK = 32;
    private static final int CODE_SOURCE_EQUALITY_MASK = 64;
    private static final int EXTENSION_PROPERTY_MASK = 128;
    private static final int EXTENSION_DIRECTORY_MASK = 256;
    private static final int EXTERNAL_CLASSES_MASK = 512;
    private static final int VERSION_MASK = 1024;
    private static final int ALIAS_MASK = 2048;
    private static final int IF_MASK = 4096;
    private static final int SYSTEM_PRIVATE_MASK = 8192;
    private static final int ROOT_DIR_MASK = 16384;
    private static final int[] MASKS = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
    private static final String[] ELEMENTS = new String[]{"boot", "directory-property", "shared-library", "system-class-loader", "main-class-loader", "code-source", "import-shared-library", "external-classes", "class"};
    protected static final int UNKNOWN_ELEMENT = -1;
    protected static final int BOOT_ELEMENT = 0;
    protected static final int DIRECTORY_PROPERTY_ELEMENT = 1;
    protected static final int SHARED_LIBRARY_ELEMENT = 2;
    protected static final int SYSTEM_CLASS_LOADER_ELEMENT = 3;
    protected static final int MAIN_CLASS_LOADER_ELEMENT = 4;
    protected static final int CODE_SOURCE_ELEMENT = 5;
    protected static final int IMPORT_SHARED_LIBRARY_ELEMENT = 6;
    protected static final int EXTERNAL_CLASSES_ELEMENT = 7;
    protected static final int CLASS_ELEMENT = 8;
    private static final int BOOT_ATTRIBUTES = 0;
    private static final int DIRECTORY_PROPERTY_ATTRIBUTES = 9;
    private static final int SHARED_LIBRARY_ATTRIBUTES = 25617;
    private static final int SYSTEM_CLASS_LOADER_ATTRIBUTES = 17809;
    private static final int MAIN_CLASS_LOADER_ATTRIBUTES = 17905;
    private static final int CODE_SOURCE_ATTRIBUTES = 6662;
    private static final int IMPORT_SHARED_LIBRARY_ATTRIBUTES = 1025;
    private static final int CLASS_ATTRIBUTES = 1;
    private static final String[] OPERATORS = new String[]{"==", "!="};
    private static final int EXISTS_OP = -1;
    private static final int EQUAL_OP = 0;
    private static final int NOT_EQUAL_OP = 1;
    private static final int PATTERN_EQUAL_OP = 2;
    private static final int PATTERN_NOT_EQUAL_OP = 3;
    private int attributeFlags;
    private String[] attributes = new String[ATTRIBUTES.length];
    private String[] commandLineArgs;
    private boolean replaceSystemLoader;
    private InputStream configFile;
    private String configFileOrigin;
    private File homeDirectory;
    private Class[] transferClasses;
    private String[] excludedTransferPackages;
    private int enclosingElementType;
    private XMLReader parser;
    private String mainClassName;
    private PolicyClassLoader mainClassLoader;
    private File codeSourceRootDir;
    private boolean haveSystemLoader;
    private boolean haveMainLoader;
    private PolicyClassLoader currentLoader;
    private boolean matchFullPathCodeSources;
    private String extensionProperty;
    private String defaultExtensionDirectory;
    private String apiExtensionProperty;
    private String defaultApiExtensionDirectory;
    private Locator locator;
    private boolean inCodeSourceElement;
    private boolean includeCodeSource;
    private boolean inExternalsElement;
    private boolean containsExternals;
    private SharedCodeSource currentCodeSource;
    private RecoverableByteBuffer buffer;
    private List externalClassNames = new ArrayList();
    private List externalPackagePaths = new ArrayList();
    private ConfigurationOrigin systemCodeSource;
    private ConfigurationOrigin mainCodeSource;
    private ConfigurationOrigin sharedCodeSource;
    private ConfigurationOrigin systemCodeSourceNoManifest;
    private ConfigurationOrigin mainCodeSourceNoManifest;
    private ConfigurationOrigin sharedCodeSourceNoManifest;
    private ConfigurationOrigin systemImportShared;
    private ConfigurationOrigin mainImportShared;
    private ConfigurationOrigin sharedImportShared;
    private String lastDirPropertyName;
    private String lastDirPropertyValue;
    private List deferredImports = new ArrayList();

    @Override
    public String[] getCommandLineArguments() {
        return this.commandLineArgs;
    }

    @Override
    public boolean shouldTransferClass(String className) {
        if (this.excludedTransferPackages != null) {
            for (int j = 0; j < this.excludedTransferPackages.length; ++j) {
                if (!className.startsWith(this.excludedTransferPackages[j])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void updateFrameworkTransferClasses(Map frameworkTransferClasses) {
        if (this.transferClasses != null) {
            for (int i = 0; i < this.transferClasses.length; ++i) {
                Class clz = this.transferClasses[i];
                frameworkTransferClasses.put(clz.getName(), clz);
            }
        }
    }

    @Override
    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MainClass configureLoaders() throws Exception {
        try {
            this.enclosingElementType = -1;
            InputSource source = new InputSource(this.configFile);
            this.parser.parse(source);
        }
        finally {
            this.configFile.close();
        }
        if (this.mainClassLoader == null) {
            this.fail("Did not find required <main-class-loader> element.");
        }
        this.doPostProcessing();
        return new MainClass(this.commandLineArgs, this.mainClassName, this.mainClassLoader);
    }

    @Override
    public String getOrigin() {
        return this.configFileOrigin;
    }

    @Override
    public boolean shouldReplaceSystemLoader() {
        return this.replaceSystemLoader;
    }

    @Override
    public String getExtensionProperty() {
        return this.extensionProperty;
    }

    @Override
    public String getApiExtensionProperty() {
        return this.apiExtensionProperty;
    }

    @Override
    public String getDefaultExtensionDirectory() {
        return this.defaultExtensionDirectory;
    }

    @Override
    public String getDefaultApiExtensionDirectory() {
        return this.defaultApiExtensionDirectory;
    }

    public XMLConfiguration(String[] commandLineArgs, InputStream stream, File homeDirectory, String origin, boolean replaceSystemLoader, Class[] transferClasses, String[] excludedTransferPackages) throws Exception {
        this.commandLineArgs = commandLineArgs;
        this.configFile = stream;
        this.homeDirectory = homeDirectory;
        this.configFileOrigin = origin;
        this.replaceSystemLoader = replaceSystemLoader;
        this.transferClasses = transferClasses;
        this.excludedTransferPackages = excludedTransferPackages;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = spf.newSAXParser();
        this.parser = sp.getXMLReader();
        this.parser.setContentHandler(this);
        this.parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                throw new Error("resolveEntity(" + publicId + ", " + systemId + ") called unexpectedly in " + XMLConfiguration.this.configFileOrigin);
            }
        });
        this.sharedCodeSource = new ConfigurationOrigin(ConfigurationType.BOOT_SHARED_CODE_SOURCE_ELEMENT, this.configFileOrigin);
        this.systemCodeSource = new ConfigurationOrigin(ConfigurationType.API_CODE_SOURCE_ELEMENT, this.configFileOrigin);
        this.mainCodeSource = new ConfigurationOrigin(ConfigurationType.MAIN_CODE_SOURCE_ELEMENT, this.configFileOrigin);
        this.sharedCodeSourceNoManifest = new ConfigurationOrigin(ConfigurationType.BOOT_SHARED_CODE_SOURCE_ELEMENT_NO_MANIFEST, this.configFileOrigin);
        this.systemCodeSourceNoManifest = new ConfigurationOrigin(ConfigurationType.API_CODE_SOURCE_ELEMENT_NO_MANIFEST, this.configFileOrigin);
        this.mainCodeSourceNoManifest = new ConfigurationOrigin(ConfigurationType.MAIN_CODE_SOURCE_ELEMENT_NO_MANIFEST, this.configFileOrigin);
        this.sharedImportShared = new ConfigurationOrigin(ConfigurationType.BOOT_SHARED_IMPORT_SHARED_LIBRARY_ELEMENT, this.configFileOrigin);
        this.systemImportShared = new ConfigurationOrigin(ConfigurationType.API_IMPORT_SHARED_LIBRARY_ELEMENT, this.configFileOrigin);
        this.mainImportShared = new ConfigurationOrigin(ConfigurationType.MAIN_IMPORT_SHARED_LIBRARY_ELEMENT, this.configFileOrigin);
    }

    private int getElementIndex(String elementName) throws SAXException {
        for (int i = 0; i < ELEMENTS.length; ++i) {
            if (!elementName.equals(ELEMENTS[i])) continue;
            return i;
        }
        this.fail("Unknown element '" + elementName + "'.");
        return -1;
    }

    private int getAttributeIndex(String attributeName) throws SAXException {
        for (int i = 0; i < ATTRIBUTES.length; ++i) {
            if (!attributeName.equals(ATTRIBUTES[i])) continue;
            return i;
        }
        this.fail("Unknown attribute '" + attributeName + "'.");
        return -1;
    }

    private void initAttributes(Attributes attrs) throws SAXException {
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = null;
        }
        int mask = 0;
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attributeValue;
                String attributeName = attrs.getLocalName(i);
                if (attributeName.equals("")) {
                    attributeName = attrs.getQName(i);
                }
                int index = this.getAttributeIndex(attributeName);
                this.attributes[index] = attributeValue = this.doReplacement(attrs.getValue(i));
                mask |= 1 << index;
            }
        }
        this.attributeFlags = mask;
    }

    private void setDefaultAttribute(int attributeIndex, String defaultValue) {
        if ((this.attributeFlags & MASKS[attributeIndex]) == 0) {
            this.attributeFlags |= MASKS[attributeIndex];
            this.attributes[attributeIndex] = defaultValue;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.initAttributes(attrs);
        String elementName = sName.equals("") ? qName : sName;
        int elementIndex = this.getElementIndex(elementName);
        try {
            switch (elementIndex) {
                case 0: {
                    this.assertScope(elementName, this.enclosingElementType == -1);
                    this.assertExpectedAttributes(0, elementName);
                    this.enclosingElementType = 0;
                    break;
                }
                case 1: {
                    this.assertScope(elementName, this.enclosingElementType == 0);
                    this.assertExpectedAttributes(9, elementName);
                    this.setDirectoryProperty(this.attributes[0], this.attributes[3]);
                    break;
                }
                case 2: {
                    this.assertScope(elementName, this.enclosingElementType == 0);
                    this.setDefaultAttribute(13, "false");
                    this.setDefaultAttribute(14, null);
                    this.assertExpectedAttributes(25617, elementName);
                    this.setCurrentLoader(elementIndex, this.attributes[0], this.attributes[4], this.attributes[10], this.attributes[13], this.attributes[14]);
                    this.enclosingElementType = 2;
                    break;
                }
                case 3: {
                    this.assertScope(elementName, this.enclosingElementType == 0);
                    this.setDefaultAttribute(7, DEFAULT_API_EXTENSION_PROPERTY);
                    this.setDefaultAttribute(8, DEFAULT_API_EXTENSION_DIRECTORY);
                    this.setDefaultAttribute(14, null);
                    this.assertExpectedAttributes(17809, elementName);
                    this.apiExtensionProperty = this.attributes[7];
                    this.defaultApiExtensionDirectory = this.attributes[8];
                    this.setCurrentLoader(elementIndex, this.attributes[0], this.attributes[4], this.attributes[10], "false", this.attributes[14]);
                    this.enclosingElementType = 3;
                    break;
                }
                case 4: {
                    this.assertScope(elementName, this.enclosingElementType == 0);
                    this.setDefaultAttribute(6, "full-path");
                    this.setDefaultAttribute(7, DEFAULT_EXTENSION_PROPERTY);
                    this.setDefaultAttribute(8, DEFAULT_EXTENSION_DIRECTORY);
                    this.setDefaultAttribute(14, null);
                    this.assertExpectedAttributes(17905, elementName);
                    this.matchFullPathCodeSources = !this.attributes[6].equals("filename");
                    this.extensionProperty = this.attributes[7];
                    this.defaultExtensionDirectory = this.attributes[8];
                    this.setCurrentLoader(elementIndex, this.attributes[0], this.attributes[4], this.attributes[10], "false", this.attributes[14]);
                    this.mainClassLoader = this.currentLoader;
                    this.mainClassName = this.attributes[5];
                    this.enclosingElementType = 4;
                    break;
                }
                case 5: {
                    this.assertScope(elementName, this.enclosingElementType == 2 || this.enclosingElementType == 3 || this.enclosingElementType == 4);
                    this.inCodeSourceElement = true;
                    if ((this.attributeFlags & 0x200) == 1) {
                        this.assertAttributeScope(ATTRIBUTES[9], this.enclosingElementType != 3);
                    }
                    this.setDefaultAttribute(2, "exclude");
                    this.setDefaultAttribute(9, "false");
                    this.setDefaultAttribute(11, null);
                    this.setDefaultAttribute(12, null);
                    this.assertExpectedAttributes(6662, elementName);
                    this.addCodeSource(this.enclosingElementType, this.attributes[1], this.attributes[2], this.attributes[9], this.attributes[11], this.attributes[12]);
                    break;
                }
                case 6: {
                    this.assertScope(elementName, this.enclosingElementType == 2 || this.enclosingElementType == 4);
                    this.setDefaultAttribute(10, null);
                    this.assertExpectedAttributes(1025, elementName);
                    this.addImport(this.enclosingElementType, this.attributes[0], this.attributes[10]);
                    break;
                }
                case 7: {
                    this.assertScope(elementName, this.enclosingElementType != 3);
                    this.assertScope(elementName, this.inCodeSourceElement);
                    this.inExternalsElement = true;
                    break;
                }
                case 8: {
                    this.assertScope(elementName, this.inExternalsElement);
                    this.assertExpectedAttributes(1, elementName);
                    if (this.includeCodeSource) {
                        this.registerExternal(this.attributes[0]);
                    }
                    break;
                }
                default: {
                    this.fail("Unknown element");
                    break;
                }
            }
        }
        catch (IOException io) {
            throw new SAXException(io);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String elementName = localName.equals("") ? qName : localName;
        int elementType = this.getElementIndex(elementName);
        switch (elementType) {
            case 0: {
                this.enclosingElementType = 0;
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.enclosingElementType = 0;
                this.currentLoader = null;
                this.matchFullPathCodeSources = true;
                break;
            }
            case 5: {
                this.registerExternalsForPostProcessing(this.currentCodeSource);
                this.currentCodeSource = null;
                this.inCodeSourceElement = false;
                this.containsExternals = false;
                this.externalClassNames.clear();
                this.externalPackagePaths.clear();
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.inExternalsElement = false;
                break;
            }
            case 8: {
                break;
            }
            default: {
                this.fail("Unknown element");
            }
        }
    }

    private void registerExternal(String name) {
        if (name.length() > 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
            if (name.endsWith(".*")) {
                name = name.substring(0, name.length() - 1);
                this.externalPackagePaths.add(name.replace('.', '/'));
            } else if (name != null) {
                this.externalClassNames.add(name.trim());
            }
        }
    }

    private void registerExternal(byte[] data, int start, int end) {
        int length = end - start;
        if (length > 0) {
            this.registerExternal(new String(data, start, length));
        }
    }

    private int skipEOL(byte[] data, int start, int length) {
        while (start < length) {
            char c = (char)data[start];
            if (c == '\r' || c == '\n') {
                ++start;
                continue;
            }
            return start;
        }
        return length;
    }

    private int findEOL(byte[] data, int start, int length) {
        while (start < length) {
            char c = (char)data[start];
            if (c != '\r' && c != '\n') {
                ++start;
                continue;
            }
            return start;
        }
        return length;
    }

    private void registerExternals(SharedCodeSource source) throws SAXException {
        try {
            RecoverableByteBuffer buf = source.getResourceBytes(EXTERNAL_CLASSES_FILE_NAME, this.buffer);
            if (buf == null) {
                this.fail("Could not process 'external-classes' for " + source + ": not found.");
            }
            this.buffer = buf;
            int count = buf.getBytesUsed();
            byte[] data = buf.getArray();
            int start = 0;
            int end = 0;
            while (start < count) {
                if ((start = this.skipEOL(data, start, count)) >= count) continue;
                end = this.findEOL(data, start + 1, count);
                this.registerExternal(data, start, end);
                start = end + 1;
            }
        }
        catch (Exception e) {
            this.fail("Could not process 'external-classes' for " + source + ": caught " + e + ".");
        }
    }

    protected void registerExternalsFromPackageNames(SharedCodeSource source) throws SAXException {
        try {
            int count = this.externalPackagePaths.size();
            if (count > 0) {
                String[] packages = new String[count];
                this.externalPackagePaths.toArray(packages);
                String[] resources = source.listFilePaths();
                for (int i = 0; i < resources.length; ++i) {
                    String resource = resources[i];
                    for (int j = 0; j < packages.length; ++j) {
                        if (!resource.startsWith(packages[j]) || !resource.endsWith(".class")) continue;
                        String className = resource.substring(0, resource.length() - 6).replace('/', '.');
                        this.externalClassNames.add(className);
                    }
                }
            }
        }
        catch (Exception e) {
            this.fail("Could not process 'external-classes' for " + source + ": caught " + e + ".");
        }
    }

    private void registerExternalsForPostProcessing(SharedCodeSource source) throws SAXException {
        int count;
        if (source != null) {
            if (this.containsExternals) {
                this.registerExternals(source);
            }
            this.registerExternalsFromPackageNames(source);
        }
        if ((count = this.externalClassNames.size()) > 0) {
            String[] classNames = new String[count];
            this.externalClassNames.toArray(classNames);
            Externals.register(this.currentLoader, source, classNames);
        }
    }

    public void doPostProcessing() throws Exception {
        this.resolveDeferredImports();
        HashMap<String, Class> externalClasses = new HashMap<String, Class>();
        Externals.load(externalClasses);
        String[] externalClassNames = ClassLoadEnvironment.getExternalClassNames();
        if (externalClassNames != null) {
            this.mainClassLoader.bulkLoadClasses(externalClassNames, null, externalClasses);
        }
        for (int i = 0; i < ClassLoadEnvironment.FRAMEWORK_EXTERNAL_CLASSES.length; ++i) {
            Class c = ClassLoadEnvironment.FRAMEWORK_EXTERNAL_CLASSES[i];
            externalClasses.put(c.getName(), c);
        }
        if (!externalClasses.isEmpty()) {
            this.updateAPISearchPolicy(externalClasses);
            this.populateInternalClassPaths(externalClasses);
        }
    }

    private void updateAPISearchPolicy(Map<String, Class> externalClasses) throws SAXException {
        PolicyClassLoader apiLoader = ClassLoaderQuery.findLatestLoader(ClassLoadEnvironment.getAPILoaderName());
        if (apiLoader == null) {
            this.fail("<system-class-loader> must be created before " + this.getOrigin() + " is processed.");
        }
        SearchPolicy externals = SearchPolicy.createExternalsSearchPolicy(externalClasses);
        SearchPolicy policy = apiLoader.getSearchPolicy().insert("externals", externals, SearchPolicy.FIND_LOCAL);
        ConfigurationOrigin origin = new ConfigurationOrigin(ConfigurationType.API_SET_POLICY_ELEMENT, this.configFileOrigin);
        apiLoader.setSearchPolicy(policy, origin);
    }

    private void populateInternalClassPaths(Map externalClasses) {
        for (Map.Entry entry : externalClasses.entrySet()) {
            String path;
            Class externalClass;
            if (entry == null || (externalClass = (Class)entry.getValue()) == null || externalClass.getProtectionDomain() == null || (path = externalClass.getProtectionDomain().getCodeSource().getLocation().getPath()) == null || ClassLoaderQuery.getInternalClassPath().contains(path)) continue;
            ClassLoaderQuery.getInternalClassPath().add(path);
        }
    }

    private void setDirectoryProperty(String propertyName, String defaults) throws SAXException {
        File dir = this.getDirectory(ClassLoadEnvironment.getProperty(propertyName), propertyName, false);
        if (dir == null) {
            StringTokenizer st = new StringTokenizer(defaults, ",");
            while (st.hasMoreTokens()) {
                dir = this.getDirectory(st.nextToken().trim(), this.configFileOrigin, true);
                if (dir == null) continue;
                System.setProperty(propertyName, dir.getPath());
                break;
            }
            if (dir == null) {
                this.fail("Could not find valid directory for '" + propertyName + "'.");
            }
        }
        this.lastDirPropertyName = propertyName;
        this.lastDirPropertyValue = dir.getAbsolutePath();
    }

    private String doReplacement(String value) throws SAXException {
        int end;
        int start = value.indexOf("${");
        if (start >= 0 && (end = value.indexOf(125, start + 1)) > start) {
            StringBuffer buf = new StringBuffer();
            if (start > 0) {
                buf.append(value.substring(0, start));
            }
            String propertyName = value.substring(start + 2, end);
            String replacement = this.lastDirPropertyName != null && propertyName.equals(this.lastDirPropertyName) ? this.lastDirPropertyValue : ClassLoadEnvironment.getProperty(propertyName);
            if (replacement == null) {
                this.fail("Property '" + propertyName + "' not set.");
            }
            buf.append(replacement);
            buf.append(value.substring(end + 1));
            return this.doReplacement(buf.toString());
        }
        return value;
    }

    private File getDirectory(String path, String origin, boolean homeRelative) {
        if (path != null) {
            try {
                File dir = new File(path);
                if (!dir.isAbsolute() && homeRelative) {
                    dir = new File(this.getHomeDirectory(), path);
                }
                if (dir.exists()) {
                    if (dir.isDirectory()) {
                        return dir.getCanonicalFile();
                    }
                    ClassLoadLogger.log(Level.WARNING, "'" + path + "' exists but is not a directory. Origin: " + origin);
                }
            }
            catch (IOException e) {
                ClassLoadLogger.log(Level.WARNING, "'" + path + "' could not be made canonical. Caught" + e + ". Origin: " + origin);
            }
        }
        return null;
    }

    private void setCurrentLoader(int elementType, String loaderName, String parentName, String version, String systemPrivate, String rootDir) throws SAXException {
        PolicyClassLoader parent = ClassLoaderQuery.findLatestLoader(parentName);
        if (parent == null) {
            this.fail("Unable to create class loader '" + loaderName + "'; its parent '" + parentName + "' does not exist.");
        }
        VersionNumber versionNum = VersionNumber.ZERO;
        if (version != null) {
            versionNum = new VersionNumber(version);
        }
        this.setCodeSourceRootDirectory(rootDir, loaderName, versionNum);
        switch (elementType) {
            case 2: {
                PolicyClassLoader existing = ClassLoaderQuery.findLoader(loaderName, versionNum, versionNum);
                if (existing != null) {
                    this.fail("Class loader '" + existing.getDisplayName() + "' already exists.");
                }
                String configName = "shared";
                if (systemPrivate.equals("true")) {
                    configName = "shared-private";
                }
                this.currentLoader = new PolicyClassLoader(loaderName, versionNum, parent, InitialLoadersFactory.createOriginFor("shared", this.configFileOrigin), InitialLoadersFactory.getConfigurationPolicyFor(configName), InitialLoadersFactory.createSearchPolicyFor("shared"), ProtectionPolicy.sharedLibraryPolicy(loaderName));
                break;
            }
            case 3: {
                if (this.haveSystemLoader) {
                    this.fail("<system-class-loader> has already been defined.");
                }
                this.currentLoader = this.getSystemLoader(loaderName, versionNum);
                this.haveSystemLoader = true;
                break;
            }
            case 4: {
                if (this.haveMainLoader) {
                    this.fail("<main-class-loader> has already been defined.");
                }
                this.currentLoader = this.getMainLoader(loaderName, versionNum, parent);
                this.haveMainLoader = true;
                break;
            }
            default: {
                this.fail("Unknown element");
            }
        }
    }

    private void setCodeSourceRootDirectory(String rootDirAttribute, String loaderName, VersionNumber version) throws SAXException {
        if (rootDirAttribute != null) {
            File sharedLibRoot = new File(rootDirAttribute);
            String sharedLibDir = loaderName + File.separatorChar + version.toString();
            this.codeSourceRootDir = new File(sharedLibRoot, sharedLibDir);
            if (!this.codeSourceRootDir.exists()) {
                this.fail("root-dir '" + this.codeSourceRootDir + "' does not exist.");
            }
        } else {
            this.codeSourceRootDir = this.getHomeDirectory();
        }
    }

    private PolicyClassLoader getSystemLoader(String loaderName, VersionNumber version) throws SAXException {
        PolicyClassLoader result = ClassLoaderQuery.getAPILoader();
        if (result == null) {
            this.fail("<system-class-loader> must be created before " + this.getOrigin() + " is processed.");
        }
        if (!loaderName.equals(result.getName()) || !version.equals(result.getVersionNumber())) {
            result.resetConfiguration(loaderName, version, result.getConfigurationPolicy());
        }
        return result;
    }

    private PolicyClassLoader getMainLoader(String loaderName, VersionNumber version, PolicyClassLoader parent) throws SAXException {
        String mainLoaderName = ClassLoadEnvironment.getMainLoaderName();
        if (loaderName.equals(mainLoaderName)) {
            loaderName = mainLoaderName;
        }
        PolicyClassLoader result = ClassLoaderQuery.getMainLoader();
        ConfigurationOrigin origin = InitialLoadersFactory.createOriginFor("main", this.configFileOrigin);
        SearchPolicy searchPolicy = InitialLoadersFactory.createSearchPolicyFor("main");
        ProtectionPolicy protectionPolicy = InitialLoadersFactory.createProtectionPolicyFor("main");
        ConfigurationPolicy configurationPolicy = null;
        configurationPolicy = this.matchFullPathCodeSources ? ConfigurationPolicy.MAIN : ConfigurationPolicy.MAIN_MATCH_FILE_NAMES;
        if (InitialLoadersFactory.configureMainAsSystemLoader()) {
            if (result == null) {
                this.fail("The main loader does not already exist!");
            }
            result.resetConfiguration(loaderName, version, configurationPolicy);
        } else if (ClassLoaderQuery.findLatestLoader(loaderName) != null) {
            this.fail("Class loader '" + loaderName + "' already exists.");
        } else {
            result = new PolicyClassLoader(loaderName, version, parent, origin, configurationPolicy, searchPolicy, protectionPolicy);
        }
        try {
            InitialLoadersFactory.transferFrameworkClasses(result);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        return result;
    }

    private boolean isPropertyConditionTrue(String condition) throws SAXException {
        if (condition != null) {
            String value;
            String key = condition;
            String operand = null;
            int operator = -1;
            for (int i = 0; i < OPERATORS.length; ++i) {
                int index = condition.indexOf(OPERATORS[i]);
                if (index < 0) continue;
                operator = i;
                key = condition.substring(0, index).trim();
                operand = condition.substring(index + OPERATORS[i].length()).trim();
                if (!operand.startsWith("/") || !operand.endsWith("/")) break;
                operand = operand.substring(1, operand.length() - 1);
                operator += 2;
                break;
            }
            if ((value = ClassLoadEnvironment.getProperty(key)) == null) {
                value = NULL_STRING;
            }
            switch (operator) {
                case -1: {
                    return value != NULL_STRING;
                }
                case 0: {
                    return value.equals(operand);
                }
                case 1: {
                    return !value.equals(operand);
                }
                case 2: {
                    return Pattern.matches(operand, value);
                }
                case 3: {
                    return !Pattern.matches(operand, value);
                }
            }
            this.fail("Unknown operator");
        }
        return true;
    }

    private void addCodeSource(int elementType, String path, String manifestDependencies, String externalClasses, String alias, String ifProperty) throws IOException, SAXException {
        if (this.isPropertyConditionTrue(ifProperty)) {
            this.includeCodeSource = true;
            boolean manifest = false;
            this.containsExternals = false;
            if (manifestDependencies != null && manifestDependencies.equals("include")) {
                manifest = true;
            }
            if (externalClasses != null && externalClasses.equals("true")) {
                this.containsExternals = true;
            }
            this.currentCodeSource = this.addCodeSource(elementType, path, manifest, this.containsExternals);
            if (this.currentCodeSource != null && alias != null) {
                StringTokenizer tok = new StringTokenizer(alias, ", ");
                while (tok.hasMoreTokens()) {
                    String fileNameAlias = tok.nextToken();
                    SharedCodeSourceSet.addFileNameAliasFor(this.currentCodeSource, fileNameAlias);
                }
            }
        } else {
            this.includeCodeSource = false;
        }
    }

    protected SharedCodeSource addCodeSource(int elementType, String path, boolean includeManifest, boolean containsExternals) throws IOException, SAXException {
        File codeSource = new File(path);
        if (!codeSource.isAbsolute()) {
            codeSource = new File(this.codeSourceRootDir, path);
        }
        SharedCodeSource result = null;
        switch (elementType) {
            case 2: {
                result = this.currentLoader.addCodeSource(codeSource, includeManifest ? this.sharedCodeSource : this.sharedCodeSourceNoManifest);
                break;
            }
            case 3: {
                result = this.currentLoader.addCodeSource(codeSource, includeManifest ? this.systemCodeSource : this.systemCodeSourceNoManifest);
                break;
            }
            case 4: {
                result = this.currentLoader.addCodeSource(codeSource, includeManifest ? this.mainCodeSource : this.mainCodeSourceNoManifest);
                break;
            }
            default: {
                this.fail("Unknown element");
            }
        }
        return result;
    }

    private void addImport(int elementType, String loaderName, String versionStr) throws SAXException {
        Import anImport;
        VersionNumber version = null;
        if (versionStr != null) {
            version = new VersionNumber(versionStr);
        }
        ConfigurationOrigin origin = null;
        switch (elementType) {
            case 2: {
                origin = this.sharedImportShared;
                break;
            }
            case 3: {
                origin = this.systemImportShared;
                break;
            }
            case 4: {
                origin = this.mainImportShared;
                break;
            }
            default: {
                this.fail("Unknown element");
            }
        }
        int lineNumber = -1;
        if (this.locator != null) {
            lineNumber = this.locator.getLineNumber();
        }
        if (!(anImport = new Import(this.currentLoader, loaderName, version, origin, lineNumber)).resolve()) {
            this.deferredImports.add(anImport);
        }
    }

    private void resolveDeferredImports() throws SAXException {
        for (Import anImport : this.deferredImports) {
            if (anImport.resolve()) continue;
            String importName = anImport.getImportName();
            int lineNumber = anImport.getLineNumber();
            this.fail("Shared loader '" + importName + "' cannot be found.", lineNumber);
        }
    }

    private void fail(String message) throws SAXException {
        int lineNumber = -1;
        if (this.locator != null) {
            lineNumber = this.locator.getLineNumber();
        }
        this.fail(message, lineNumber);
    }

    private void fail(String message, int lineNumber) throws SAXException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.configFileOrigin);
        if (lineNumber >= 0) {
            buf.append(", line ");
            buf.append(lineNumber);
        }
        buf.append(": ");
        buf.append(message);
        throw new SAXException(buf.toString());
    }

    private void assertScope(String elementName, boolean expected) throws SAXException {
        if (!expected) {
            this.fail("Element <" + elementName + "> is not in expected scope.");
        }
    }

    private void assertAttributeScope(String attributeName, boolean expected) throws SAXException {
        if (!expected) {
            this.fail("Attribute '" + attributeName + "' is not in expected scope.");
        }
    }

    private void assertExpectedAttributes(int expectedAttributesMask, String elementName) throws SAXException {
        if (this.attributeFlags != expectedAttributesMask) {
            StringBuffer missing = null;
            StringBuffer unexpected = null;
            for (int i = 0; i < this.attributes.length; ++i) {
                boolean present;
                int bit = 1 << i;
                boolean expected = (expectedAttributesMask & bit) > 0;
                boolean bl = present = (this.attributeFlags & bit) > 0;
                if (expected) {
                    if (present) continue;
                    if (missing == null) {
                        missing = new StringBuffer("Missing ");
                    } else {
                        missing.append(", ");
                    }
                    missing.append("'");
                    missing.append(ATTRIBUTES[i]);
                    missing.append("'");
                    continue;
                }
                if (!present) continue;
                if (unexpected == null) {
                    unexpected = new StringBuffer("Expected ");
                } else {
                    unexpected.append(", ");
                }
                unexpected.append("'");
                unexpected.append(ATTRIBUTES[i]);
                unexpected.append("'");
            }
            StringBuffer buf = new StringBuffer();
            buf.append("Invalid attributes for <");
            buf.append(elementName);
            buf.append(">: ");
            if (missing != null) {
                buf.append(missing);
                buf.append(". ");
            }
            if (unexpected != null) {
                buf.append(unexpected);
                buf.append(".");
            }
            this.fail(buf.toString());
        }
    }

    private static class Import {
        private PolicyClassLoader importer;
        private String importName;
        private VersionNumber importVersion;
        private ConfigurationOrigin origin;
        private int lineNumber;

        public Import(PolicyClassLoader importer, String importName, VersionNumber importVersion, ConfigurationOrigin origin, int lineNumber) {
            this.importer = importer;
            this.importName = importName;
            this.importVersion = importVersion;
            this.origin = origin;
            this.lineNumber = lineNumber;
        }

        public boolean resolve() {
            PolicyClassLoader importLoader = ClassLoaderQuery.findSharedLoader(this.importName, this.importVersion, this.importVersion);
            if (importLoader == null) {
                return false;
            }
            this.importer.importLoader(importLoader, this.origin);
            return true;
        }

        public String getImportName() {
            return this.importName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    private static class Externals {
        private PolicyClassLoader loader;
        private SharedCodeSource codeSource;
        private String[] classes;
        private Externals next;
        private static Externals first;

        private Externals(PolicyClassLoader loader, SharedCodeSource codeSource, String[] classes) {
            this.loader = loader;
            this.codeSource = codeSource;
            this.classes = classes;
        }

        public static void register(PolicyClassLoader loader, SharedCodeSource codeSource, String[] classes) {
            Externals ex = new Externals(loader, codeSource, classes);
            if (first != null) {
                ex.next = first;
            }
            first = ex;
        }

        public static void load(Map map) throws Exception {
            Externals current = first;
            while (current != null) {
                current.loader.bulkLoadClasses(current.classes, current.codeSource, map);
                current = current.next;
            }
            first = null;
        }
    }
}

