/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.expressionbuilder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import oracle.ide.Ide;
import oracle.ide.expressionbuilder.ExpressionBuilderArb;
import oracle.ide.expressionbuilder.ExpressionBuilderPicker;
import oracle.ide.expressionbuilder.ExpressionBuilderPickerListener;
import oracle.ide.expressionbuilder.ExpressionValidator;
import oracle.ide.expressionbuilder.PickerEvent;
import oracle.ide.expressionbuilder.ToolBar;
import oracle.ide.expressionbuilder.UIHelper;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.icons.OracleIcons;

public class ExpressionBuilderPanel
extends JPanel
implements ActionListener,
DocumentListener,
UndoableEditListener,
ExpressionBuilderPickerListener {
    static Font BOLD_FONT;
    protected JTextComponent m_textPane;
    protected JTextPane m_errorPane;
    protected JTextArea m_descArea;
    protected JTextArea m_previewArea;
    protected JButton m_shuttleBtn;
    protected JButton m_clearBtn;
    protected JButton m_undoBtn;
    protected JButton m_redoBtn;
    protected JButton m_validateBtn;
    protected JPanel m_expressionPnl;
    protected JPanel m_descriptionPnl;
    protected JSplitPane m_splitter1;
    protected JSplitPane m_splitter2;
    protected ExpressionBuilderPicker[] m_pickers;
    protected UndoManager m_undoManager;
    protected ExpressionValidator m_validator;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final String UNDO_ACTION_NAME = "undo";
    private static final String REDO_ACTION_NAME = "redo";
    private final UndoAction m_UndoAction;
    private final RedoAction m_RedoAction;
    protected boolean m_Initialized;

    static {
        $assertionsDisabled = ExpressionBuilderPanel.class.desiredAssertionStatus() ^ true;
        BOLD_FONT = null;
        Font font = UIManager.getFont("Tree.font");
        BOLD_FONT = new Font(font.getFontName(), 1, font.getSize());
    }

    private void $init$() {
        this.m_undoManager = new UndoManager();
        this.m_UndoAction = new UndoAction();
        this.m_RedoAction = new RedoAction();
    }

    public ExpressionBuilderPanel(JTextComponent editorPane, ExpressionBuilderPicker[] pickers) {
        this.$init$();
        this.m_textPane = editorPane;
        this.m_pickers = pickers;
    }

    public final void initialize() {
        if (!$assertionsDisabled && this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_Initialized = true;
        this.createControls();
        this.layoutControls();
        this.setValidator(null);
        this.loadNupdateControls();
        this.bindUndoRedo(this.m_textPane);
    }

    public ExpressionValidator getValidator() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        return this.m_validator;
    }

    public void setValidator(ExpressionValidator validator) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_validator = validator;
        this.m_validateBtn.setVisible(validator != null);
    }

    void loadNupdateControls() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        1 r = new 1();
        new Thread(r).start();
    }

    public String getExpressionText() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        return this.m_textPane.getText();
    }

    public void setExpressionText(String exp) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_textPane.setText(exp);
    }

    public Component getInitialFocus() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        return this.m_textPane;
    }

    protected void loadControls() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_textPane.getDocument().addDocumentListener(this);
        this.m_textPane.getDocument().addUndoableEditListener(this);
        int i = 0;
        while (i < this.m_pickers.length) {
            ExpressionBuilderPicker p = this.m_pickers[i];
            p.addExpressionBuilderPickerListener(this);
            p.load();
            ++i;
        }
    }

    protected void createControls() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_descriptionPnl = this.createDescriptionPanel();
        this.m_expressionPnl = this.createExpressionPanel();
        this.m_shuttleBtn = new JButton(ExpressionBuilderArb.getIcon(6));
        ResourceUtils.resButton((AbstractButton)this.m_shuttleBtn, (String)ExpressionBuilderArb.getString(0));
        this.m_shuttleBtn.addActionListener(this);
        this.m_shuttleBtn.setEnabled(false);
    }

    protected JPanel createTitlePanel(ExpressionBuilderPicker picker) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        JPanel panel = new JPanel(new GridBagLayout());
        String title = picker.getTitle();
        if (title != null) {
            JLabel titleLabel = new JLabel(picker.getTitle());
            UIHelper.addComponent(panel, titleLabel, 0, 0, 1, 1, 17, 2, new Insets(10, 5, 5, 5), 0, 0, 1.0, 0.0);
        }
        UIHelper.addComponent(panel, picker.getComponent(), 0, 2, 1, 1, 17, 1, new Insets(0, 5, 0, 5), 0, 0, 1.0, 1.0);
        return panel;
    }

    protected JPanel createExpressionPanel() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        JPanel p = new JPanel(new GridBagLayout());
        UIHelper.addComponent(p, new JScrollPane(this.m_textPane), 0, 0, 1, 1, 17, 1, new Insets(0, 0, 0, 0), 0, 0, 1.0, 1.0);
        return p;
    }

    protected JPanel createErrorPanel() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_errorPane = new JTextPane();
        this.m_errorPane.setEditable(false);
        JButton m_closeErrorBtn = UIHelper.createModelerButton(ExpressionBuilderArb.getIcon(9));
        JPanel p = new JPanel(new GridBagLayout());
        UIHelper.addComponent(p, new JScrollPane(this.m_errorPane), 0, 0, 1, 1, 17, 1, new Insets(2, 0, 0, 0), 0, 0, 1.0, 1.0);
        UIHelper.addComponent(p, m_closeErrorBtn, 1, 0, 1, 1, 18, 0, new Insets(0, 0, 0, 0), 0, 0, 0.0, 1.0);
        return p;
    }

    protected JPanel createToolBar() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_clearBtn = UIHelper.createModelerButton(OracleIcons.getIcon((String)"clear.png"));
        this.m_clearBtn.setEnabled(false);
        this.m_clearBtn.addActionListener(this);
        this.m_clearBtn.setToolTipText(ExpressionBuilderArb.getString(8));
        this.m_undoBtn = UIHelper.createModelerButton(OracleIcons.getIcon((String)"undo.png"));
        this.m_undoBtn.setEnabled(false);
        this.m_undoBtn.addActionListener(this);
        this.m_undoBtn.setToolTipText(ExpressionBuilderArb.getString(5));
        this.m_redoBtn = UIHelper.createModelerButton(OracleIcons.getIcon((String)"redo.png"));
        this.m_redoBtn.setEnabled(false);
        this.m_redoBtn.addActionListener(this);
        this.m_redoBtn.setToolTipText(ExpressionBuilderArb.getString(4));
        this.m_validateBtn = UIHelper.createModelerButton(OracleIcons.getIcon((String)"check.png"));
        this.m_validateBtn.addActionListener(this);
        this.m_validateBtn.setToolTipText(ExpressionBuilderArb.getString(3));
        this.m_validateBtn.setVisible(this.getValidator() != null);
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        tb.add(this.m_validateBtn);
        tb.add(this.m_undoBtn);
        tb.add(this.m_redoBtn);
        tb.add(this.m_clearBtn);
        JPanel p = new JPanel(new GridBagLayout());
        UIHelper.addComponent(p, tb, 0, 1, 1, 1, 18, 0, new Insets(0, 0, 0, 0), 0, 0, 0.0, 1.0);
        return p;
    }

    protected JPanel createDescriptionPanel() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_descArea = new JTextArea();
        this.m_descArea.setWrapStyleWord(true);
        this.m_descArea.setLineWrap(true);
        this.m_descArea.setEditable(false);
        this.m_descArea.setOpaque(false);
        this.m_previewArea = new JTextArea();
        this.m_previewArea.setEditable(false);
        this.m_previewArea.setOpaque(false);
        JLabel previewLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)previewLbl, (Component)this.m_previewArea, (String)ExpressionBuilderArb.getString(1));
        JLabel descLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)descLbl, (Component)this.m_descArea, (String)ExpressionBuilderArb.getString(2));
        JPanel left = new JPanel(new GridBagLayout());
        UIHelper.addComponent(left, previewLbl, 0, 0, 1, 1, 17, 2, new Insets(5, 10, 0, 0), 0, 0, 1.0, 0.0);
        UIHelper.addComponent(left, new JScrollPane(this.m_previewArea), 0, 1, 1, 1, 17, 1, new Insets(2, 10, 5, 5), 0, 0, 1.0, 1.0);
        JPanel right = new JPanel(new GridBagLayout());
        UIHelper.addComponent(right, descLbl, 0, 0, 1, 1, 17, 2, new Insets(5, 0, 0, 10), 0, 0, 1.0, 0.0);
        UIHelper.addComponent(right, new JScrollPane(this.m_descArea), 0, 1, 1, 1, 17, 1, new Insets(2, 0, 5, 10), 0, 0, 1.0, 1.0);
        JPanel p = new JPanel(new GridLayout(1, 2, 5, 0));
        p.add(left);
        p.add(right);
        p.setPreferredSize(new Dimension(100, 180));
        return p;
    }

    protected Component createHeaderComponent() {
        return null;
    }

    protected void layoutControls() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.setLayout(new GridBagLayout());
        JPanel pickersPnl = new JPanel(new GridLayout(1, this.m_pickers.length, 0, 0));
        int i = 0;
        while (i < this.m_pickers.length) {
            pickersPnl.add(this.createTitlePanel(this.m_pickers[i]));
            ++i;
        }
        pickersPnl.setPreferredSize(new Dimension(300, 200));
        JPanel top = new JPanel(new GridBagLayout());
        JLabel expLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)expLbl, (Component)this.m_expressionPnl, (String)ExpressionBuilderArb.getString(7));
        Component headerComponent = this.createHeaderComponent();
        if (headerComponent != null) {
            UIHelper.addComponent(top, headerComponent, 0, 0, 1, 1, 16, 0, new Insets(0, 10, 0, 0), 0, 0, 1.0, 0.0);
        }
        UIHelper.addComponent(top, expLbl, 0, 1, 1, 1, 16, 0, new Insets(2, 10, 2, 0), 0, 0, 1.0, 0.0);
        UIHelper.addComponent(top, this.createToolBar(), 1, 1, 1, 1, 13, 0, new Insets(2, 0, 0, 10), 0, 0, 0.0, 0.0);
        UIHelper.addComponent(top, this.m_expressionPnl, 0, 2, 2, 1, 17, 1, new Insets(0, 10, 0, 10), 0, 0, 1.0, 1.0);
        UIHelper.addComponent(top, this.m_shuttleBtn, 0, 3, 2, 1, 17, 2, new Insets(10, 10, 3, 10), 0, 0, 1.0, 0.0);
        this.m_splitter1 = new JSplitPane(0);
        this.m_splitter1.setBorder(null);
        this.m_splitter1.add(top);
        this.m_splitter1.add(pickersPnl);
        JPanel splitter1Container = new JPanel(new GridBagLayout());
        UIHelper.addComponent(splitter1Container, this.m_splitter1, 0, 0, 2, 1, 17, 1, new Insets(0, 0, 3, 0), 0, 0, 1.0, 1.0);
        this.m_splitter2 = new JSplitPane(0);
        this.m_splitter2.setBorder(null);
        this.m_splitter2.add(splitter1Container);
        this.m_splitter2.add(this.m_descriptionPnl);
        UIHelper.addComponent(this, this.m_splitter2, 0, 0, 2, 1, 17, 1, new Insets(0, 0, 0, 0), 0, 0, 1.0, 1.0);
        this.setSize(750, 600);
        this.m_splitter1.setDividerLocation(200);
        this.m_splitter2.setDividerLocation(400);
    }

    protected void setDescriptionText(String s) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_descArea.setText(s);
        this.m_descArea.setCaretPosition(0);
        String tipText = null;
        if (s != null && s.length() > 0) {
            tipText = "<html><body><table border=0 width=\"400\" ><tr><td>" + s + "</td></tr></body></html>";
        }
        this.m_descArea.setToolTipText(tipText);
    }

    protected void setPreviewText(String s) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_previewArea.setText(s);
        this.m_previewArea.setCaretPosition(0);
        String tipText = null;
        if (s != null && s.length() > 0) {
            tipText = "<html><body><table border=0 width=\"400\" ><tr><td>" + s + "</td></tr></body></html>";
        }
        this.m_previewArea.setToolTipText(tipText);
    }

    protected void updateControls() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        String preview = this.m_previewArea.getText();
        this.m_shuttleBtn.setEnabled(preview != null && preview.length() > 0);
        String expression = this.getExpressionText();
        this.m_clearBtn.setEnabled(expression != null && expression.length() > 0);
        this.m_undoBtn.setEnabled(this.m_undoManager.canUndo());
        this.m_redoBtn.setEnabled(this.m_undoManager.canRedo());
        this.m_UndoAction.setEnabled(this.m_undoManager.canUndo());
        this.m_RedoAction.setEnabled(this.m_undoManager.canRedo());
    }

    protected void handleShuttleClick() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.insertString(this.m_previewArea.getText());
    }

    protected void insertString(String s) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_textPane.requestFocus(true);
        int selStart = this.m_textPane.getSelectionStart();
        int selEnd = this.m_textPane.getSelectionEnd();
        if (selStart >= 0 && selEnd >= selStart) {
            this.m_textPane.replaceSelection(s);
            return;
        }
        Document doc = this.m_textPane.getDocument();
        if (doc instanceof BasicDocument) {
            BasicDocument bdoc = (BasicDocument)doc;
            bdoc.writeLock();
            try {
                bdoc.insertString(this.m_textPane.getCaretPosition(), s, null);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
            bdoc.writeUnlock();
        } else {
            try {
                doc.insertString(this.m_textPane.getCaretPosition(), s, null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private void validateExpression() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        ExpressionValidator validator = this.getValidator();
        if (validator != null) {
            validator.validate(this.getExpressionText());
        }
    }

    protected void handleClear() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_textPane.setText("");
    }

    protected void handleUndo() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        if (this.m_undoManager.canUndo()) {
            this.m_undoManager.undo();
        }
        this.updateControls();
    }

    protected void handleRedo() {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        if (this.m_undoManager.canRedo()) {
            this.m_undoManager.redo();
        }
        this.updateControls();
    }

    public void actionPerformed(ActionEvent e) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        Object src = e.getSource();
        if (src == this.m_shuttleBtn) {
            this.handleShuttleClick();
        } else if (src == this.m_clearBtn) {
            this.handleClear();
        } else if (src == this.m_undoBtn) {
            this.handleUndo();
        } else if (src == this.m_redoBtn) {
            this.handleRedo();
        } else if (src == this.m_validateBtn) {
            this.validateExpression();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.updateControls();
        this.m_textPane.requestFocus();
    }

    public void removeUpdate(DocumentEvent e) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.updateControls();
        this.m_textPane.requestFocus();
    }

    public void changedUpdate(DocumentEvent e) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.updateControls();
    }

    public void pickerEventOccurred(PickerEvent evt) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        switch (evt.getID()) {
            case 0: {
                this.setPreviewText(evt.getPreview());
                this.setDescriptionText(evt.getDescription());
                this.updateControls();
                break;
            }
            case 1: {
                String val = evt.getPreview();
                if (val == null || val.length() <= 0) break;
                this.insertString(val);
                break;
            }
        }
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        this.m_undoManager.addEdit(e.getEdit());
        this.updateControls();
    }

    private void bindUndoRedo(JTextComponent textComponent) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        ArrayList bindings = new ArrayList();
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        this.getBindings(keyStrokeMap, 5, UNDO_ACTION_NAME, bindings);
        this.getBindings(keyStrokeMap, 6, REDO_ACTION_NAME, bindings);
        JTextComponent.loadKeymap(textComponent.getKeymap(), bindings.toArray(new JTextComponent.KeyBinding[bindings.size()]), new Action[]{this.m_UndoAction, this.m_RedoAction});
    }

    private void getBindings(KeyStrokeMap keyStrokeMap, int cmdID, String actionName, ArrayList bindings) {
        if (!$assertionsDisabled && !this.m_Initialized) {
            throw new AssertionError();
        }
        List list = keyStrokeMap.getKeyStrokesFor(cmdID);
        if (!list.isEmpty()) {
            for (KeyStrokes kss : list) {
                KeyStroke accelerator;
                if (kss.getLength() != 1 || (accelerator = kss.getKeyStroke(0)) == null) continue;
                bindings.add(new JTextComponent.KeyBinding(accelerator, actionName));
            }
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            ExpressionBuilderPanel.this.loadControls();
            ExpressionBuilderPanel.this.updateControls();
        }
    }

    private final class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(ExpressionBuilderPanel.UNDO_ACTION_NAME);
        }

        public void actionPerformed(ActionEvent e) {
            ExpressionBuilderPanel.this.handleUndo();
        }
    }

    private final class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(ExpressionBuilderPanel.REDO_ACTION_NAME);
        }

        public void actionPerformed(ActionEvent e) {
            ExpressionBuilderPanel.this.handleRedo();
        }
    }
}

