/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.expressionbuilder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JSeparator;

class ToolBar
extends JPanel {
    private int m_spacing;
    private Insets m_insets;

    private void $init$() {
        this.m_spacing = 1;
        this.m_insets = new Insets(0, 0, 0, 0);
    }

    public ToolBar() {
        this.$init$();
        this.setLayout(null);
    }

    public Insets getBorderInsets() {
        return this.m_insets;
    }

    public void setBorderInsets(Insets insets) {
        this.m_insets = insets;
    }

    public void addSeparator() {
        this.add(new JSeparator());
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Component[] comps = this.getComponents();
        int w = 0;
        int h = 0;
        int i = 0;
        while (i < comps.length) {
            Component comp = comps[i];
            if (comp.isVisible()) {
                if (i > 0) {
                    w += this.m_spacing;
                }
                int prefWidth = comp.getPreferredSize().width;
                int prefHeight = comp.getPreferredSize().height;
                w += prefWidth;
                h = Math.max(prefHeight, h);
            }
            ++i;
        }
        return new Dimension(w, h += this.m_insets.top + this.m_insets.bottom);
    }

    protected int getMaxHeight(Component[] comps) {
        if (comps == null) {
            return 0;
        }
        int maxHeight = 0;
        int i = 0;
        while (i < comps.length) {
            Component comp = comps[i];
            if (comp.isVisible()) {
                maxHeight = Math.max(maxHeight, comp.getPreferredSize().height);
            }
            ++i;
        }
        return maxHeight;
    }

    public void doLayout() {
        Component[] comps = this.getComponents();
        int x = 0;
        int y = this.m_insets.top;
        int offset = this.getMaxHeight(comps) / 2;
        int i = 0;
        while (i < comps.length) {
            y = this.m_insets.top;
            Component comp = comps[i];
            if (comp.isVisible()) {
                Dimension prefDim = comp.getPreferredSize();
                if (i > 0) {
                    x += this.m_spacing;
                }
                comp.setBounds(x, y -= prefDim.height / 2 - offset, prefDim.width, prefDim.height);
                x += prefDim.width;
            }
            ++i;
        }
    }
}

