/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.PropertiesConnectionStore;
import oracle.jdeveloper.cm.WritableConnectionStore;
import oracle.security.misc.Checksum;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class DefaultConnectionStore
extends DefaultHandler
implements WritableConnectionStore,
LexicalHandler {
    public static final String DEFAULT_FILE = "connections.xml";
    public static final String CONNECTION_TAG = "connection";
    public static final String ROOT_TAG = "connections";
    private static final String PWD_PROP = "PWD";
    private static final String ORMI_PWD_PROP = "ORMI-PWD";
    private final String fName;
    private final boolean isAbsolutePath;
    private List _list;
    private ConnectionDescriptor _curDesc;
    private String _curKey;
    private StringBuffer _curValue;
    private String _cdata;

    private void $init$() {
        this._list = null;
        this._curDesc = null;
    }

    public DefaultConnectionStore() {
        this("/connections.xml", false);
    }

    public DefaultConnectionStore(String fName, boolean isAbsolutePath) {
        this.$init$();
        this.fName = fName;
        this.isAbsolutePath = isAbsolutePath;
    }

    public final void write(String outputFile, List descriptors, boolean stripPasswords) throws CMException {
        try {
            File dir;
            XMLDocument doc = new XMLDocument();
            doc.setVersion("1.0");
            doc.setDoctype(ROOT_TAG, null, null);
            Element root = doc.createElement(ROOT_TAG);
            File file = new File(outputFile);
            if (file != null && (dir = file.getParentFile()) != null) {
                dir.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(outputFile);
            Iterator iter = descriptors.iterator();
            while (iter.hasNext()) {
                Element connection = doc.createElement(CONNECTION_TAG);
                ConnectionDescriptor desc = (ConnectionDescriptor)((ConnectionDescriptor)iter.next()).clone();
                if (stripPasswords && !desc.isDeployPassword()) {
                    desc.remove("password");
                }
                Enumeration<Object> piEnum = desc.keys();
                while (piEnum.hasMoreElements()) {
                    Object key = piEnum.nextElement();
                    Object value = desc.get(key);
                    Text text = null;
                    if (key == null) continue;
                    if ("password".equals(key) || "ormi-password".equals(key)) {
                        Object object = key = "password".equals(key) ? PWD_PROP : ORMI_PWD_PROP;
                        if (value != null) {
                            try {
                                byte[] b = value.toString().getBytes();
                                byte[] b1 = Checksum.MD5((byte[])b, null);
                                text = doc.createCDATASection(RepConversion.bArray2String(b1));
                            }
                            catch (Exception ex) {}
                        }
                    } else if (value != null) {
                        text = doc.createTextNode(value.toString());
                    }
                    Element element = doc.createElement(key.toString());
                    if (text != null) {
                        element.appendChild(text);
                    }
                    connection.appendChild(element);
                }
                root.appendChild(connection);
            }
            doc.appendChild((Node)root);
            doc.print((OutputStream)fos);
            fos.close();
        }
        catch (FileNotFoundException fnfEx) {
            throw new CMException(fnfEx);
        }
        catch (IOException ioEx) {
            throw new CMException(ioEx);
        }
    }

    public final List read() {
        SAXParser parser = null;
        try {
            this._list = null;
            InputStream is = null;
            try {
                is = this.isAbsolutePath ? new FileInputStream(this.fName) : ConnectionManager.getInputStream(this.getClass(), this.fName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (is != null) {
                try {
                    try {
                        parser = new SAXParser();
                        parser.setContentHandler((ContentHandler)this);
                        parser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)this);
                        parser.parse(is);
                    }
                    catch (SAXException saxEx) {}
                }
                finally {
                    if (parser != null) {
                        parser.reset();
                        parser = null;
                    }
                }
            }
            if (this._list == null || this._list.size() == 0) {
                this._list = this._readPCS();
            } else {
                List listPCS = this._readPCS();
                Iterator iterPCS = listPCS != null ? listPCS.iterator() : Collections.EMPTY_LIST.iterator();
                while (iterPCS.hasNext()) {
                    ConnectionDescriptor cDesc = (ConnectionDescriptor)iterPCS.next();
                    if (this._listContains(cDesc.getConnectionName())) continue;
                    this._list.add(cDesc);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this._list;
    }

    private final List _readPCS() {
        List list = null;
        PropertiesConnectionStore pcs = new PropertiesConnectionStore(this.fName, this.isAbsolutePath);
        list = pcs.read();
        if (!(list != null && list.size() != 0 || this.isAbsolutePath)) {
            pcs = new PropertiesConnectionStore();
            list = pcs.read();
        }
        return list;
    }

    private final boolean _listContains(String connName) {
        for (ConnectionDescriptor c : this._list) {
            if (!c.getConnectionName().equals(connName)) continue;
            return true;
        }
        return false;
    }

    public void startDocument() {
        if (this._list == null) {
            this._list = new ArrayList(10);
        } else {
            this._list.clear();
        }
    }

    public void endDocument() {
        this._curKey = null;
        this._curValue = null;
        this._curDesc = null;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (name.equals(CONNECTION_TAG)) {
            this._curDesc = new ConnectionDescriptor();
            this._curKey = null;
            this._curValue = null;
            this._cdata = null;
        } else if (this._curDesc != null) {
            this._curKey = name;
            this._curValue = new StringBuffer();
            this._cdata = null;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (name.equals(CONNECTION_TAG)) {
            if (this._curDesc != null && this._curDesc.getConnectionName() != null) {
                this._list.add(this._curDesc);
            }
            this._curDesc = null;
        } else if (this._curDesc != null && this._curKey != null) {
            String value = this._curValue.toString();
            if ("ConnectionType".equals(this._curKey) && "IAS".equals(this._curValue.toString())) {
                value = "OC4J";
            } else if ("IAS_HOME".equals(this._curKey)) {
                this._curKey = "OC4J_HOME";
            } else if ("password".equals(this._curKey)) {
                if (this._curDesc.getPassword() != null) {
                    this._curKey = null;
                }
            } else if (PWD_PROP.equals(this._curKey) || ORMI_PWD_PROP.equals(this._curKey)) {
                value = null;
                String string = this._curKey = PWD_PROP.equals(this._curKey) ? "password" : "ormi-password";
                if (this._cdata != null) {
                    try {
                        byte[] enc = RepConversion.convertHexStringToByte(this._cdata);
                        byte[] decPwd = Checksum.SHA((byte[])enc, null);
                        value = new String(decPwd);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if (this._curKey != null) {
                this._curDesc.put(this._curKey, value);
            }
        }
        this._curKey = null;
        this._curValue = null;
    }

    public void characters(char[] ch, int start, int length) {
        if (this._curKey != null) {
            this._curValue.append(ch, start, length);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        this._cdata = this._curValue.toString();
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this._curValue.setLength(0);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    private static class RepConversion {
        public static byte nibbleToHex(byte nibble) {
            return (byte)((nibble = (byte)(nibble & 0xF)) < 10 ? nibble + 48 : nibble - 10 + 65);
        }

        public static String bArray2String(byte[] array) {
            StringBuffer result = new StringBuffer(array.length * 2);
            int i = 0;
            while (i < array.length) {
                result.append((char)RepConversion.nibbleToHex((byte)((array[i] & 0xF0) >> 4)));
                result.append((char)RepConversion.nibbleToHex((byte)(array[i] & 0xF)));
                ++i;
            }
            return result.toString();
        }

        static int convertCharToInt(char charVal) {
            switch (charVal) {
                case '0': {
                    return 0;
                }
                case '1': {
                    return 1;
                }
                case '2': {
                    return 2;
                }
                case '3': {
                    return 3;
                }
                case '4': {
                    return 4;
                }
                case '5': {
                    return 5;
                }
                case '6': {
                    return 6;
                }
                case '7': {
                    return 7;
                }
                case '8': {
                    return 8;
                }
                case '9': {
                    return 9;
                }
                case 'A': 
                case 'a': {
                    return 10;
                }
                case 'B': 
                case 'b': {
                    return 11;
                }
                case 'C': 
                case 'c': {
                    return 12;
                }
                case 'D': 
                case 'd': {
                    return 13;
                }
                case 'E': 
                case 'e': {
                    return 14;
                }
                case 'F': 
                case 'f': {
                    return 15;
                }
            }
            return 48;
        }

        public static byte[] convertHexStringToByte(String refString) {
            byte[] byteArray = new byte[refString.length() / 2];
            int i = 0;
            while (i < refString.length()) {
                int intVal = RepConversion.convertCharToInt(refString.charAt(i));
                Integer newInt = new Integer(0xF0 & intVal << 4);
                byteArray[i / 2] = newInt.byteValue();
                intVal = RepConversion.convertCharToInt(refString.charAt(i + 1));
                newInt = new Integer(0xF & intVal);
                int n = i / 2;
                byteArray[n] = (byte)(byteArray[n] | newInt.byteValue());
                i += 2;
            }
            return byteArray;
        }

        private RepConversion() {
        }
    }
}

