/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.javatools.controls.FileField;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ResourcePicker;

public abstract class ConnectionImportExportPanel
extends JPanel {
    private GridBagLayout m_layout;
    private JLabel m_hintText;
    private JLabel m_fileNameLabel;
    private FileField m_fileNameField;
    private JButton m_browseButton;
    private JLabel m_connectionsLabel;
    private JScrollPane m_connectionsPane;
    private JList m_connectionsList;
    private boolean m_isImportMode;
    private JEWTDialog m_dialog;

    private void $init$() {
        this.m_layout = new GridBagLayout();
        this.m_hintText = new JLabel();
        this.m_fileNameLabel = new JLabel();
        this.m_fileNameField = new FileField();
        this.m_browseButton = new JButton();
        this.m_connectionsLabel = new JLabel();
        this.m_connectionsPane = new JScrollPane();
        this.m_connectionsList = new JList();
        this.m_isImportMode = true;
        this.m_dialog = null;
    }

    public ConnectionImportExportPanel() {
        this.$init$();
        try {
            this.jbInit();
            this.m_browseButton.addActionListener(new 1());
            2 dl = new 2();
            this.m_fileNameField.getDocument().addDocumentListener(dl);
            this.m_connectionsList.getSelectionModel().addListSelectionListener(new 3());
            ResourcePicker.getPicker(ConnectionImportExportPanel.class).start((Container)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setConnectionsCellRenderer(ListCellRenderer cellRenderer) {
        this.m_connectionsList.setCellRenderer(cellRenderer);
    }

    public void setImportMode(boolean isImportMode) {
        this.m_isImportMode = isImportMode;
        this.m_fileNameField.setValidateExistingFile(this.m_isImportMode);
        if (!isImportMode) {
            this.setConnections(this.getExportableConnections());
        }
    }

    public boolean isImportMode() {
        return this.m_isImportMode;
    }

    public void setExplanatoryText(String text) {
        this.m_hintText.setText(text);
    }

    public void setConnections(Object[] connections) {
        this.m_connectionsList.setModel(new ArrayListModel(connections));
        int count = this.m_connectionsList.getModel().getSize();
        if (count > 0) {
            this.m_connectionsList.setSelectionInterval(0, count - 1);
        }
    }

    public Object[] getSelectedConnections() {
        return this.m_connectionsList.getSelectedValues();
    }

    private void filenameChangedImpl() {
        try {
            if (this.isImportMode()) {
                this.filenameChanged(this.m_fileNameField.getText());
            }
            this.checkDialogOKButton();
        }
        catch (RuntimeException re) {
            Assert.printStackTrace((Throwable)re);
        }
    }

    protected abstract void filenameChanged(String var1);

    protected abstract Object[] getExportableConnections();

    protected Object getRenderedConnectionValue(Object connection) {
        return connection;
    }

    protected void browseClicked() {
        int result;
        URLChooser urc = DialogUtil.newURLChooser();
        urc.setSelectionMode(0);
        this.setURLChooserFilter(urc, null);
        String currentValue = this.m_fileNameField.getText();
        if (currentValue.trim().length() > 0) {
            URL u = URLFactory.newURL((String)currentValue);
            urc.setSelectedURL(u);
        }
        if ((result = this.isImportMode() ? urc.showOpenDialog((Component)this) : urc.showSaveDialog((Component)this)) == 0) {
            this.m_fileNameField.setText(URLFileSystem.getPlatformPathName((URL)urc.getSelectedURL()));
        }
    }

    protected void setURLChooserFilter(URLChooser urc, URLFilter filter) {
        if (filter != null) {
            urc.setURLFilter(filter);
        }
    }

    protected abstract boolean importConnections();

    protected abstract boolean exportConnections(String var1);

    public boolean runDialog(Component parent, String title, String helpID) {
        int buttonMask;
        if (helpID == null) {
            buttonMask = 3;
        } else {
            buttonMask = 7;
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, helpID);
        }
        JEWTDialog jd = null;
        try {
            this.m_dialog = jd = JEWTDialog.createDialog((Component)parent, (String)title, (int)buttonMask);
            jd.setContent((Component)this);
            jd.setInitialFocus((Component)this.m_fileNameField);
            jd.setOKButtonEnabled(false);
            jd.setPreferredSize(new Dimension(588, 401));
            jd.setResizable(true);
            jd.addVetoableChangeListener((VetoableChangeListener)new 4());
            boolean bl = jd.runDialog();
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (jd != null) {
                jd.dispose();
            }
            this.m_dialog = null;
        }
    }

    protected boolean checkCanWrite(String filename) {
        URL u = URLFactory.newURL((String)filename);
        if (URLFileSystem.exists((URL)u)) {
            ResourcePicker rp = ResourcePicker.getPicker(ConnectionImportExportPanel.class);
            return MessageDialog.confirm((Component)this, (Object)rp.getString("ConfirmOverwrite.text", (Object)filename), (String)rp.getString("ConfirmOverwrite.title"), null, (boolean)true);
        }
        return true;
    }

    private void dialogCommitImpl(PropertyChangeEvent pce) throws PropertyVetoException {
        try {
            boolean ok = false;
            if (this.isImportMode()) {
                ok = this.importConnections();
            } else {
                String filename = this.m_fileNameField.getText();
                if (this.checkCanWrite(filename)) {
                    ok = this.exportConnections(this.m_fileNameField.getText());
                }
            }
            if (!ok) {
                throw new PropertyVetoException("", pce);
            }
        }
        catch (RuntimeException re) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)re);
            throw new PropertyVetoException("", pce);
        }
    }

    private void checkDialogOKButton() {
        try {
            if (this.m_dialog != null) {
                Object[] sel = this.getSelectedConnections();
                String fname = this.m_fileNameField.getText();
                this.m_dialog.setOKButtonEnabled(sel != null && sel.length > 0 && (this.isImportMode() || fname.trim().length() > 0));
            }
        }
        catch (RuntimeException re) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)re);
        }
    }

    private void jbInit() throws Exception {
        this.setName("ConnectionImportExportPanel");
        this.setLayout(this.m_layout);
        this.m_hintText.setName("ExplanatoryText");
        this.m_fileNameLabel.setName("FileNameLabel");
        this.m_fileNameLabel.setLabelFor((Component)this.m_fileNameField);
        this.m_browseButton.setName("BrowseButton");
        this.m_connectionsLabel.setName("ConnectionsLabel");
        this.m_connectionsLabel.setLabelFor(this.m_connectionsList);
        this.add((Component)this.m_hintText, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.m_fileNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add((Component)this.m_fileNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.m_connectionsLabel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.m_connectionsPane.getViewport().add((Component)this.m_connectionsList, null);
        this.add((Component)this.m_connectionsPane, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    static void mav$dialogCommitImpl(ConnectionImportExportPanel connectionImportExportPanel, PropertyChangeEvent propertyChangeEvent) {
        connectionImportExportPanel.dialogCommitImpl(propertyChangeEvent);
    }

    static void mav$filenameChangedImpl(ConnectionImportExportPanel connectionImportExportPanel) {
        connectionImportExportPanel.filenameChangedImpl();
    }

    static void mav$checkDialogOKButton(ConnectionImportExportPanel connectionImportExportPanel) {
        connectionImportExportPanel.checkDialogOKButton();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            try {
                ConnectionImportExportPanel.this.browseClicked();
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)ConnectionImportExportPanel.this, (Throwable)re);
            }
        }
    }

    final class 2
    implements DocumentListener {
        public void insertUpdate(DocumentEvent de) {
            ConnectionImportExportPanel.mav$filenameChangedImpl(ConnectionImportExportPanel.this);
        }

        public void changedUpdate(DocumentEvent de) {
            ConnectionImportExportPanel.mav$filenameChangedImpl(ConnectionImportExportPanel.this);
        }

        public void removeUpdate(DocumentEvent de) {
            ConnectionImportExportPanel.mav$filenameChangedImpl(ConnectionImportExportPanel.this);
        }
    }

    final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent lse) {
            ConnectionImportExportPanel.mav$checkDialogOKButton(ConnectionImportExportPanel.this);
        }
    }

    final class 4
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                ConnectionImportExportPanel.mav$dialogCommitImpl(ConnectionImportExportPanel.this, pce);
            }
        }
    }

    private class ArrayListModel
    extends AbstractListModel {
        private Object[] m_items;

        ArrayListModel(Object[] array) {
            this.m_items = array;
        }

        public int getSize() {
            return this.m_items.length;
        }

        public Object getElementAt(int i) {
            return this.m_items[i];
        }
    }
}

