/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.panels.Navigable;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.MenuSpec;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.merge.AbstractMergeEditor;
import oracle.jdeveloper.merge.MergeURLFileSystemHelper;
import oracle.jdeveloper.merge.RestartMergeCommand;
import oracle.jdeveloper.merge.SaveMergeCommand;
import oracle.jdeveloper.resource.MergeArb;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.SearchNavigable;
import oracle.jdevimpl.merge.MergeCloseNodeCommand;
import oracle.jdevimpl.merge.MergeExitCommand;
import oracle.jdevimpl.merge.MergeOptions;
import oracle.jdevimpl.merge.MergePreferencesPanel;
import oracle.jdevimpl.resource.CompareArb;

public abstract class AbstractMergeAddin
extends EditorAddin {
    private static boolean _initialized;
    private final Class _editorClass;

    public AbstractMergeAddin(Class editorClass) {
        if (!AbstractMergeEditor.class.isAssignableFrom(editorClass)) {
            throw new IllegalArgumentException();
        }
        this._editorClass = editorClass;
        AbstractMergeAddin.init();
    }

    private static final synchronized void init() {
        if (_initialized) {
            return;
        }
        _initialized = true;
        AbstractMergeAddin.initializeSettings();
        CompareAddin compareAddin = (CompareAddin)AddinManager.getAddinManager().getAddin(CompareAddin.class);
        if (compareAddin != null) {
            IdeSettings.deregisterUI((Navigable)compareAddin.getCompareNavigable());
            IdeSettings.registerUI((Navigable)new SearchNavigable(MergeArb.getString(5), MergePreferencesPanel.class, new String[]{CompareArb.getString((int)47), CompareArb.getString((int)20)}));
        }
        IdeAction goFirstAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"merge.navigateFirstConflict"), null, (String)StringUtils.stripMnemonic((String)MergeArb.getString(9)), (String)MergeArb.getString(25), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)MergeArb.getString(9))), (Icon)OracleIcons.getIcon((String)"first_conflict.png"), null, (boolean)false);
        IdeAction goPreviousAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"merge.navigatePreviousConflict"), null, (String)StringUtils.stripMnemonic((String)MergeArb.getString(23)), (String)MergeArb.getString(25), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)MergeArb.getString(23))), (Icon)OracleIcons.getIcon((String)"previous_conflict.png"), null, (boolean)false);
        IdeAction goNextAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"merge.navigateNextConflict"), null, (String)StringUtils.stripMnemonic((String)MergeArb.getString(32)), (String)MergeArb.getString(25), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)MergeArb.getString(32))), (Icon)OracleIcons.getIcon((String)"next_conflict.png"), null, (boolean)false);
        IdeAction goLastAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"merge.navigateLastConflict"), null, (String)StringUtils.stripMnemonic((String)MergeArb.getString(22)), (String)MergeArb.getString(25), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)MergeArb.getString(22))), (Icon)OracleIcons.getIcon((String)"last_conflict.png"), null, (boolean)false);
        URLFileSystem.registerHelper((String)"ide.merge", (URLFileSystemHelper)new MergeURLFileSystemHelper());
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)new 1());
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)new 2());
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(AbstractMergeAddin.class.getClassLoader(), "oracle/jdeveloper/merge/accelerators.xml");
        IdeAction.get((int)Ide.findOrCreateCmdID((String)RestartMergeCommand.RESTART_MERGE_CMD), (String)RestartMergeCommand.RESTART_MERGE_CMD, (String)StringUtils.stripMnemonic((String)MergeArb.getString(17)), (String)MergeArb.getString(25), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)MergeArb.getString(17))), null, (int)-1, null, (boolean)false);
        IdeAction.get((int)Ide.findOrCreateCmdID((String)SaveMergeCommand.SAVE_MERGE_CMD), (String)SaveMergeCommand.SAVE_MERGE_CMD, (String)StringUtils.stripMnemonic((String)MergeArb.getString(18)), (String)MergeArb.getString(25), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)MergeArb.getString(18))), (ArrayResourceBundle)MergeArb.getInstance(), (int)7, null, (boolean)false);
        IdeAction closeNodeAction = IdeActions.getFileCloseAction();
        String closeNodeCommand = closeNodeAction.getCommand();
        closeNodeAction.setCommand("oracle.jdevimpl.merge.MergeCloseNodeCommand");
        MergeCloseNodeCommand.setDelegateCommand(closeNodeCommand);
        IdeAction exitAction = IdeActions.getFileExitAction();
        String exitCommand = exitAction.getCommand();
        exitAction.setCommand("oracle.jdevimpl.merge.MergeExitCommand");
        MergeExitCommand.setDelegateCommand(exitCommand);
        Preferences prefs = Preferences.getPreferences();
        IdeSettings ideSettings = Ide.getSettings();
        ideSettings.putLegacyData("oracle.jdevimpl.merge.MergeOptions", (Copyable)MergeOptions.getInstance((PropertyStorage)prefs));
    }

    private static final void initializeSettings() {
        MergeOptions.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    public Class getEditorClass() {
        return this._editorClass;
    }

    public boolean isEditorAvailable(Context context) {
        return this.isEditorAvailable(context.getElement());
    }

    public void closeEditors() {
        ArrayList<Editor> editorsToClose = new ArrayList<Editor>();
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            if (!this._editorClass.isInstance(editor)) continue;
            editorsToClose.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(editorsToClose);
    }

    public float getEditorWeight(Element element) {
        return this.isEditorAvailable(element) ? -1.0f : Float.NaN;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isDuplicable() {
        return false;
    }

    public boolean restoreAtStartup() {
        return false;
    }

    public MenuSpec getMenuSpecification() {
        return new MenuSpec(MergeArb.getString(16), null, null, null);
    }

    protected boolean isEditorAvailable(Element element) {
        URL url = element instanceof Locatable ? ((Locatable)element).getURL() : null;
        return url != null ? this.isEditorAvailable(url) : false;
    }

    protected boolean isEditorAvailable(URL url) {
        return false;
    }

    static final class 1
    implements DynamicMenuListener {
        public JComponent[] gatherDynamicActions(Context context) {
            if (context.getView() instanceof AbstractMergeEditor) {
                return new JComponent[]{Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"compare.navigateFirst")), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"compare.navigatePrevious")), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"compare.navigateNext")), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"compare.navigateLast")), 0.0f), new JSeparator(), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"merge.navigateFirstConflict")), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"merge.navigatePreviousConflict")), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"merge.navigateNextConflict")), 0.0f), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"merge.navigateLastConflict")), 0.0f), new JSeparator(), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)SaveMergeCommand.SAVE_MERGE_CMD)), 0.0f), new JSeparator(), Ide.getMenubar().createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)RestartMergeCommand.RESTART_MERGE_CMD)), 0.0f)};
            }
            return new JComponent[0];
        }
    }

    static final class 2
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu menu) {
            if (menu.getContext().getView() instanceof AbstractMergeEditor) {
                Action[] editActions;
                CompareView compareView = ((AbstractMergeEditor)menu.getContext().getView()).getCompareView();
                float sectionId = 1.0f;
                Action[] actionArray = editActions = compareView instanceof EditorPaneView ? ((EditorPaneView)compareView).getEditActions() : null;
                if (editActions != null) {
                    int i = 0;
                    while (i < editActions.length) {
                        if (editActions[i] == null) {
                            sectionId += 0.01f;
                        } else {
                            menu.add((Component)new JMenuItem(editActions[i]), sectionId, false);
                        }
                        ++i;
                    }
                }
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"compare.navigateFirst"))), sectionId += 0.01f);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"compare.navigatePrevious"))), sectionId);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"compare.navigateNext"))), sectionId);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"compare.navigateLast"))), sectionId);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"merge.navigateFirstConflict"))), sectionId += 0.01f);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"merge.navigatePreviousConflict"))), sectionId);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"merge.navigateNextConflict"))), sectionId);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)"merge.navigateLastConflict"))), sectionId);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)SaveMergeCommand.SAVE_MERGE_CMD))), sectionId += 0.01f);
                menu.add((Component)menu.createMenuItem((ToggleAction)IdeAction.find((int)Ide.findOrCreateCmdID((String)RestartMergeCommand.RESTART_MERGE_CMD))), sectionId += 0.01f);
            }
        }

        public void menuWillHide(ContextMenu menu) {
        }

        public boolean handleDefaultAction(Context ctx) {
            return false;
        }
    }
}

