/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.UndoWrapperCommand;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.icons.IdeIcons;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.view.ActionMenuView;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.EditableView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.NavigableConflictsView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.compare.view.StatusView;
import oracle.javatools.compare.view.ViewEdit;
import oracle.javatools.compare.view.ViewEditEvent;
import oracle.javatools.compare.view.ViewEditListener;
import oracle.javatools.controls.ProgressPanel;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeController;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdeveloper.merge.MergeURLFileSystemHelper;
import oracle.jdeveloper.merge.RestartMergeCommand;
import oracle.jdeveloper.merge.SaveMergeCommand;
import oracle.jdeveloper.resource.MergeArb;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdevimpl.compare.CompareViewOwner;
import oracle.jdevimpl.merge.MergeOptions;

public abstract class AbstractMergeEditor
extends Editor
implements ViewEditListener,
DynamicStatusProvider,
FindableEditor,
ComparePopupManager,
CompareViewOwner {
    static final int ATTRIBUTE_MERGE_SAVEABLE = ElementAttributes.nextMutableAttribute();
    static final int ATTRIBUTE_MERGE_DIRTY = ElementAttributes.nextMutableAttribute();
    private JPanel _gui;
    private JLabel _statusLabel;
    private Toolbar _toolbar;
    private JPanel _horizontalScrollContainer;
    private Component _northComponent;
    private CompareView _view;
    private boolean _completeState;
    private Collection _statusChangeListeners;
    private NodeWatcher _nodeWatcher;
    private ProgressPanel _progressPanel;
    private URL _saveUrl;
    private final ChangeListener _viewStatusListener;
    private final ChangeListener _positionChangeListener;
    private Context _context;
    private TextBuffer _textBuffer;
    private JLabel _nodeChangeLabel;

    private void $init$() {
        this._gui = new JPanel(new BorderLayout());
        this._statusLabel = null;
        this._toolbar = new Toolbar();
        this._horizontalScrollContainer = new JPanel();
        this._statusChangeListeners = new ArrayList();
        this._viewStatusListener = new 1();
        this._positionChangeListener = new 2();
        this._context = null;
        this._gui.setLayout(new BorderLayout());
        this._horizontalScrollContainer.setLayout(new BorderLayout());
        this._gui.setBackground(UIManager.getColor("EditorPane.background"));
        this._gui.setOpaque(true);
    }

    public void setContext(Context context) {
        super.setContext(context);
        this._context = context;
        if (context != null && context.getNode() instanceof TextNode) {
            this._textBuffer = ((TextNode)context.getNode()).acquireTextBuffer();
        }
    }

    private Context _getContext() {
        return this._context != null ? this._context : this.getContext();
    }

    public CompareView getCompareView() {
        return this._view;
    }

    private void merge(CompareModel model) {
        this._completeState = false;
        if (this._view instanceof ActionMenuView) {
            ((ActionMenuView)this._view).removePopupManager((ComparePopupManager)this);
        }
        this.removeGUI(true);
        this._northComponent = this.layoutNorthComponent(this._toolbar);
        this._gui.add(this._northComponent, "North");
        this._view = CompareViewFactory.createMergeView((CompareModel)model);
        this.installUndoableEditListener();
        if (this._view instanceof NavigableView) {
            ((NavigableView)this._view).goToFirstDifference();
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigateFirst")));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigatePrevious")));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigateNext")));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigateLast")));
        }
        if (this._view instanceof NavigableConflictsView) {
            if (this._view instanceof NavigableView) {
                this._toolbar.addSeparator();
            }
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"merge.navigateFirstConflict")));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"merge.navigatePreviousConflict")));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"merge.navigateNextConflict")));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"merge.navigateLastConflict")));
        }
        this.initializeToolbar(this._toolbar);
        if (this._view instanceof StatusView) {
            ((StatusView)this._view).addStatusListener(this._viewStatusListener);
        }
        if (this._view instanceof NavigableView) {
            ((NavigableView)this._view).addPositionListener(this._positionChangeListener);
        }
        if (this._view instanceof ActionMenuView) {
            ((ActionMenuView)this._view).removePopupManager((ComparePopupManager)this);
            ((ActionMenuView)this._view).addPopupManager((ComparePopupManager)this);
        }
        this.initializeMergeView(this._view);
        this._gui.add(this._view.getGUI(), "Center");
        this.updateStatusLabel();
        if (this._view instanceof CustomHorizontalScrollView) {
            this._horizontalScrollContainer.add(((CustomHorizontalScrollView)this._view).getHorizontalScrollComponent(), "Center");
        }
        this.validateGUI();
        if (this._view instanceof EditorPaneView) {
            GraphicsUtils.focusComponentOrChild((Component)((EditorPaneView)this._view).getCurrentEditorPane());
        } else {
            GraphicsUtils.focusComponentOrChild((Component)this._view.getGUI());
        }
    }

    protected IdeAction createLocalAction(int cmdId) {
        IdeAction globalAction = IdeAction.find((int)cmdId);
        return globalAction.newLocalAction((View)this);
    }

    public void viewEditHappened(ViewEditEvent vee) {
        if (vee.getContributorKind() != ContributorKind.ANCESTOR) {
            return;
        }
        this.updateMergeAttributes(null);
        Command command = this.createEditCommand(vee.getViewEdit());
        command.setContext(this._getContext());
        try {
            CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateStatusLabel();
        IdeAction.find((int)SaveMergeCommand.SAVE_MERGE_CMD_ID).updateAction();
    }

    protected Command createEditCommand(ViewEdit viewEdit) {
        return new UndoWrapperCommand((UndoableEdit)viewEdit, null);
    }

    protected void updateStatusLabel() {
        this.setStatusText("");
        if (this._view == null) {
            return;
        }
        if (this._completeState) {
            this.setStatusText(MergeArb.getString(34));
            return;
        }
        int conflicts = this._view.getModel().getConflictCount();
        int resolved = this._view.getModel().getResolvedCount();
        if (conflicts == 0) {
            this.setStatusText(MergeArb.getString(33));
            return;
        }
        this.setStatusText(MessageFormat.format(MergeArb.getString(10), String.valueOf(conflicts), String.valueOf(resolved), String.valueOf(conflicts - resolved)));
    }

    private void setStatusText(String text) {
        this._statusLabel = null;
        this.fireStatusStateChanged();
        this._statusLabel = new JLabel(text);
        this.fireStatusStateChanged();
    }

    private void fireStatusStateChanged() {
        ChangeEvent ce = new ChangeEvent((Object)this);
        Iterator itr = this._statusChangeListeners.iterator();
        while (itr.hasNext()) {
            ((ChangeListener)itr.next()).stateChanged(ce);
        }
    }

    public boolean restartMerge() throws IOException {
        if (!MessageDialog.confirm((Component)this.owner().getGUI(), (Object)MergeArb.getString(0), (String)MergeArb.getString(13), null, (boolean)true)) {
            return false;
        }
        return this.restartMergeImpl();
    }

    public boolean restartMergeImpl() throws IOException {
        try {
            boolean bl = this.restartMergeImpl(this._getContext());
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this._nodeWatcher.resetNodeDirty();
        }
    }

    public boolean saveMerge() throws IOException {
        URL url = this._getContext().getNode().getURL();
        if (this.isValidateMerge() && !this.validateContent(this._view.getModel())) {
            return false;
        }
        if (url.getProtocol().startsWith("ide.merge")) {
            if ((url = MergeURLFileSystemHelper.getSaveURL(url)) == null) {
                url = this.chooseSaveURL(MergeArb.getString(1));
            }
            if (url == null) {
                return false;
            }
        }
        if (!this.isNodeDirty() ? !MessageDialog.confirm((Component)this.owner().getGUI(), (Object)MergeArb.format(30, URLFileSystem.getPlatformPathName((URL)url)), (String)MergeArb.getString(8), null, (boolean)true) : !MessageDialog.confirm((Component)this.owner().getGUI(), (Object)MergeArb.format(4, URLFileSystem.getPlatformPathName((URL)url)), (String)MergeArb.getString(8), null, (boolean)true)) {
            return false;
        }
        this._saveUrl = url;
        if (URLFileSystem.isReadOnly((URL)url)) {
            MessageDialog.error((Component)this.owner().getGUI(), (Object)MergeArb.format(11, URLFileSystem.getFileName((URL)url)), (String)MergeArb.getString(19), null);
            return false;
        }
        return this.saveMergeImpl();
    }

    private URL chooseSaveURL(String title) {
        URLChooser chooser = DialogUtil.newURLChooser();
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(0);
        chooser.setShowJarsAsDirs(false);
        String type = this.getCompareView().getModel().getContributor(ContributorKind.ANCESTOR).getType();
        if (!type.equals("")) {
            type = "." + type;
        }
        chooser.setSelectedURL(URLFactory.newURL((URL)URLFactory.newFileURL((String)Ide.getWorkDirectory()), (String)(MergeArb.getString(12) + type)));
        return chooser.showSaveDialog((Component)IdeUtil.getMainWindow(), title) == 0 ? chooser.getSelectedURL() : null;
    }

    protected URL getSaveURL(Context context) {
        return this._saveUrl != null ? this._saveUrl : context.getNode().getURL();
    }

    protected boolean isMergeModelBasedOnFile() {
        return this.getClientSideMergeSetting() ^ true;
    }

    public boolean saveMergeImpl() throws IOException {
        if (!this.saveMergeImpl(this._getContext(), this._view.getModel())) {
            return false;
        }
        this.clearMergeAttributes();
        return true;
    }

    public void moveToCompleteState() {
        this.closeGUI(true);
        FocusableLabel mergeCompleteLabel = new FocusableLabel(MergeArb.getString(36));
        mergeCompleteLabel.setOpaque(true);
        mergeCompleteLabel.setBackground(UIManager.getColor("window"));
        this._gui.add((Component)mergeCompleteLabel, "Center");
        this.repaintGUI();
        this._completeState = true;
        this.updateStatusLabel();
    }

    public boolean isCompleteState() {
        return this._completeState;
    }

    private void removeGUI(boolean repaintImmediately) {
        this._gui.removeAll();
        this._toolbar.removeAll();
        this._horizontalScrollContainer.removeAll();
        if (repaintImmediately) {
            this._gui.setSize(0, 0);
            this._gui.setPreferredSize(new Dimension(0, 0));
        }
        this._validateGUI();
        this._northComponent = null;
    }

    private void validateGUI() {
        if (this._gui == null || !this._gui.isVisible()) {
            return;
        }
        EventQueue.invokeLater(new 3());
    }

    private void _validateGUI() {
        this._gui.invalidate();
        this._gui.validate();
        this._horizontalScrollContainer.invalidate();
        this._horizontalScrollContainer.validate();
    }

    private void repaintGUI() {
        if (this._gui == null || !this._gui.isVisible()) {
            return;
        }
        EventQueue.invokeLater(new 4());
    }

    private void _repaintGUI() {
        this._gui.repaint();
        this._horizontalScrollContainer.repaint();
    }

    public Component getBottomComponent() {
        return this._horizontalScrollContainer;
    }

    public Object getEditorAttribute(String attribute) {
        if ("scrollable".equals(attribute)) {
            return Boolean.FALSE;
        }
        if (attribute == "horizontal_scrollbar_policy") {
            return new Integer(31);
        }
        if (attribute == "vertical_scrollbar_policy") {
            return new Integer(21);
        }
        if ("menu_id".equals(attribute)) {
            return MergeArb.getString(35);
        }
        return super.getEditorAttribute(attribute);
    }

    public void open() {
        Node node;
        Context context = this._getContext();
        this.setContext(context);
        Node node2 = node = context != null ? context.getNode() : null;
        if (node != null) {
            node.detach((Observer)this);
            node.attach((Observer)this);
        }
        this._nodeWatcher = new TimestampNodeWatcher(context.getNode());
        this._nodeWatcher.attach();
        EditorProperties properties = EditorProperties.getProperties();
        StyleRegistry styleRegistry = properties.getStyleRegistry();
        BaseStyle plainStyle = styleRegistry.lookupStyle("base-plain-style");
        if (plainStyle != null && plainStyle.getBackgroundColor() != null) {
            this._gui.setBackground(plainStyle.getBackgroundColor());
        }
        try {
            context.getNode().open();
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
        }
        MergeContext.setModel(context, null);
        MergeContext.setMergeEngine(context, null);
        if (MergeContext.getModel(context) == null && this.getClientSideMergeSetting()) {
            this._progressPanel = new ProgressPanel();
            this._progressPanel.setCancelEnabled(false);
            this._progressPanel.setCancelingText(MergeArb.getString(21));
            this._progressPanel.setLabelText(MergeArb.getString(15));
            this._progressPanel.addCancelActionListener((ActionListener)new 5(this, context));
            this._gui.removeAll();
            this._gui.add((Component)this._progressPanel, "Center");
            this._gui.invalidate();
            this._repaintGUI();
        }
        6 swingWorker = new 6(this, context);
        swingWorker.start();
        this._nodeWatcher.addChangeListener(new 7());
        this._nodeWatcher.resetNodeDirty();
        IdeAction.find((int)RestartMergeCommand.RESTART_MERGE_CMD_ID).updateAction();
    }

    private void initializeMergeContext(Context context) {
        if (this.getClientSideMergeSetting()) {
            MergeContext.setClientSideMerge(context, true);
            try {
                this.initializeMergeContextCS(context);
                if (MergeContext.isClientSideMerge(context)) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MergeContext.setClientSideMerge(context, false);
        this.initializeMergeContextSS(context);
    }

    private void initializeUIFromModel(CompareModel model) {
        if (model == null) {
            return;
        }
        this.merge(model);
        if (this._gui != null) {
            this._gui.invalidate();
        }
        this.repaintGUI();
    }

    protected void setProgressCancelable(boolean cancelable) {
        EventQueue.invokeLater(new 8(this, cancelable));
    }

    protected boolean getClientSideMergeSetting() {
        return false;
    }

    protected void initializeMergeContextCS(Context context) throws Exception {
    }

    private void initializeMergeContextSS(Context context) {
    }

    protected String getSuffixAsType(URL url) {
        String type = URLFileSystem.getSuffix((URL)url);
        if (type.length() > 1) {
            type = type.substring(1);
        }
        return type;
    }

    public void close() {
        this._close(true);
    }

    private void _close(boolean repaintImmediately) {
        super.close();
        EventQueue.invokeLater(new 9());
        this.closeGUI(repaintImmediately);
        this.setNodeChangedWarningVisible(false);
        this._nodeWatcher.detach();
        this._nodeWatcher = null;
    }

    private void closeGUI(boolean repaintImmediately) {
        this.deinstallUndoableEditListener();
        this.removeGUI(repaintImmediately);
        if (repaintImmediately) {
            this._repaintGUI();
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_scsmergewindow_html");
    }

    public Component getGUI() {
        return this._gui;
    }

    public Controller getController() {
        return MergeController.getDefaultMergeController();
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public void addChangeListener(ChangeListener l) {
        this._statusChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._statusChangeListeners.remove(l);
    }

    public JComponent[] getCustomCells() {
        JComponent[] jComponentArray;
        if (this._statusLabel != null) {
            JComponent[] jComponentArray2 = new JComponent[1];
            jComponentArray = jComponentArray2;
            jComponentArray2[0] = this._statusLabel;
        } else {
            jComponentArray = new JComponent[]{};
        }
        return jComponentArray;
    }

    public boolean isExpandable(JComponent cell) {
        return true;
    }

    public BasicEditorPane getFocusedEditorPane() {
        if (this._view instanceof EditorPaneView) {
            return ((EditorPaneView)this._view).getCurrentEditorPane();
        }
        return null;
    }

    public void showPopup(MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu == null) {
            return;
        }
        Context context = new Context(this.getContext());
        Node element = context.getNode();
        context.setSelection(new Element[]{element});
        context.setElement((Element)element);
        context.setEvent((EventObject)mouseEvent);
        contextMenu.show(context);
    }

    public void hidePopup() {
    }

    protected void installUndoableEditListener() {
        if (this.getCompareView() instanceof EditableView) {
            ((EditableView)this.getCompareView()).addViewEditListener((ViewEditListener)this);
        }
    }

    protected void deinstallUndoableEditListener() {
        if (this.getCompareView() instanceof EditableView) {
            ((EditableView)this.getCompareView()).removeViewEditListener((ViewEditListener)this);
        }
    }

    protected Component layoutNorthComponent(Toolbar toolbar) {
        return toolbar;
    }

    protected void initializeToolbar(Toolbar toolbar) {
        toolbar.addSeparator();
        toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)SaveMergeCommand.SAVE_MERGE_CMD)));
        this.initializeToolbarImpl(toolbar);
        toolbar.addSeparator();
        this._nodeChangeLabel = new JLabel();
        this._nodeChangeLabel.setAlignmentX(0.5f);
        this._nodeChangeLabel.setAlignmentY(0.5f);
        this._nodeChangeLabel.setText(" ");
        this._nodeChangeLabel.setIcon((Icon)new NullIcon(16, 16));
        this._nodeChangeLabel.setToolTipText(null);
        toolbar.add((Component)this._nodeChangeLabel);
    }

    protected void initializeToolbarImpl(Toolbar toolbar) {
    }

    protected void initializeMergeView(CompareView mergeView) {
    }

    protected CompareModel createMergeModel(Context context) {
        this.clearMergeAttributes();
        return this.createMergeModelImpl(context);
    }

    protected abstract CompareModel createMergeModelImpl(Context var1);

    protected abstract boolean restartMergeImpl(Context var1) throws IOException;

    protected void reopen() {
        this.clearMergeAttributes();
        this._close(false);
        this.open();
    }

    protected abstract boolean saveMergeImpl(Context var1, CompareModel var2) throws IOException;

    protected boolean isNodeDirty() {
        return this._nodeWatcher.isNodeDirty();
    }

    protected Reader createReader() throws IOException {
        return this._nodeWatcher.createReader();
    }

    boolean isSaveEnabled() {
        CompareView compareView = this.getCompareView();
        if (compareView == null) {
            return false;
        }
        int conflicts = compareView.getModel().getConflictCount();
        return conflicts <= compareView.getModel().getResolvedCount();
    }

    boolean isRestartEnabled() {
        return this.getCompareView() != null && MergeContext.getModel(this._getContext()) == null;
    }

    private void setNodeChangedWarningVisible(boolean visible) {
        if (this._nodeChangeLabel == null) {
            return;
        }
        if (visible) {
            this._nodeChangeLabel.setText(MergeArb.getString(6).trim());
            this._nodeChangeLabel.setIcon(IdeIcons.getIcon((int)2));
            this._nodeChangeLabel.setToolTipText(this._nodeChangeLabel.getText());
        } else {
            this._nodeChangeLabel.setText(" ");
            this._nodeChangeLabel.setIcon((Icon)new NullIcon(16, 16));
            this._nodeChangeLabel.setToolTipText(null);
        }
        this.getToolbar().validate();
        this.getToolbar().invalidate();
        this.getToolbar().repaint();
    }

    protected abstract boolean validateContent(CompareModel var1) throws IOException;

    protected void updateMergeAttributes(TextBuffer mergeTextBuffer) {
        if (this.getCompareView() == null || this.getCompareView().getModel() == null) {
            return;
        }
        Attributes attributes = this._getContext().getNode().getAttributes();
        if (mergeTextBuffer != null) {
            if (mergeTextBuffer.isModified()) {
                attributes.set(ATTRIBUTE_MERGE_DIRTY);
            } else {
                attributes.unset(ATTRIBUTE_MERGE_DIRTY);
            }
        }
        if (this.getCompareView() == null || this.getCompareView().getModel() == null) {
            return;
        }
        int resolved = this.getCompareView().getModel().getResolvedCount();
        if (resolved > 0) {
            attributes.set(ATTRIBUTE_MERGE_DIRTY);
        }
        if (this.getCompareView().getModel().getConflictCount() - resolved <= 0) {
            attributes.set(ATTRIBUTE_MERGE_SAVEABLE);
        } else {
            attributes.unset(ATTRIBUTE_MERGE_SAVEABLE);
        }
    }

    private void clearMergeAttributes() {
        Attributes attributes = this._getContext().getNode().getAttributes();
        attributes.unset(ATTRIBUTE_MERGE_DIRTY);
        attributes.unset(ATTRIBUTE_MERGE_SAVEABLE);
    }

    private boolean isValidateMerge() {
        MergeOptions mo = MergeOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        return mo.isValidateResult();
    }

    public AbstractMergeEditor() {
        this.$init$();
    }

    static void mav$clearMergeAttributes(AbstractMergeEditor abstractMergeEditor) {
        abstractMergeEditor.clearMergeAttributes();
    }

    static ProgressPanel ra$_progressPanel(AbstractMergeEditor abstractMergeEditor) {
        return abstractMergeEditor._progressPanel;
    }

    static void mav$initializeUIFromModel(AbstractMergeEditor abstractMergeEditor, CompareModel compareModel) {
        abstractMergeEditor.initializeUIFromModel(compareModel);
    }

    static void wa$_progressPanel(AbstractMergeEditor abstractMergeEditor, ProgressPanel progressPanel) {
        abstractMergeEditor._progressPanel = progressPanel;
    }

    static void mav$initializeMergeContext(AbstractMergeEditor abstractMergeEditor, Context context) {
        abstractMergeEditor.initializeMergeContext(context);
    }

    static void mav$setNodeChangedWarningVisible(AbstractMergeEditor abstractMergeEditor, boolean bl) {
        abstractMergeEditor.setNodeChangedWarningVisible(bl);
    }

    static void mav$_repaintGUI(AbstractMergeEditor abstractMergeEditor) {
        abstractMergeEditor._repaintGUI();
    }

    static void mav$_validateGUI(AbstractMergeEditor abstractMergeEditor) {
        abstractMergeEditor._validateGUI();
    }

    final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent ce) {
            AbstractMergeEditor.this.updateStatusLabel();
        }
    }

    final class 2
    implements ChangeListener {
        public void stateChanged(ChangeEvent ce) {
            AbstractMergeEditor.this.updateVisibleActions();
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            AbstractMergeEditor.mav$_validateGUI(AbstractMergeEditor.this);
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            AbstractMergeEditor.mav$_repaintGUI(AbstractMergeEditor.this);
        }
    }

    final class 5
    implements ActionListener {
        private final /* synthetic */ Context v$context;
        final /* synthetic */ AbstractMergeEditor this$0;

        public void actionPerformed(ActionEvent ae) {
            MergeContext.getMergeEngine(this.v$context).cancel();
        }

        public 5(AbstractMergeEditor abstractMergeEditor, Context context) {
            this.v$context = context;
            this.this$0 = abstractMergeEditor;
        }
    }

    final class 6
    extends SwingWorker {
        private final /* synthetic */ Context v$context;
        final /* synthetic */ AbstractMergeEditor this$0;

        public Object construct() {
            AbstractMergeEditor.mav$initializeMergeContext(this.this$0, this.v$context);
            CompareModel compareModel = this.this$0.createMergeModel(this.v$context);
            try {
                return compareModel;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (this.v$context.getNode() instanceof TextNode) {
                        ((TextNode)this.v$context.getNode()).acquireTextBuffer().writeUnlock();
                    }
                }
                catch (Exception exception) {}
            }
        }

        public void finished() {
            MergeEngine mergeEngine = MergeContext.getMergeEngine(this.v$context);
            if (this.getValue() == null || mergeEngine != null && mergeEngine.isCanceled()) {
                EditorManager.getEditorManager().closeEditors(Collections.singletonList(this.this$0));
                return;
            }
            CompareModel compareModel = (CompareModel)this.getValue();
            AbstractMergeEditor.mav$initializeUIFromModel(this.this$0, compareModel);
            AbstractMergeEditor.wa$_progressPanel(this.this$0, null);
            if (this.this$0.getSaveURL(this.v$context).getProtocol().startsWith("ide.")) {
                return;
            }
            if (compareModel.getConflictCount() <= compareModel.getResolvedCount()) {
                try {
                    if (this.this$0.saveMergeImpl()) {
                        this.this$0.moveToCompleteState();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                MessageDialog.information((Component)this.this$0.owner().getGUI(), (Object)MergeArb.getString(26), (String)MergeArb.getString(2), null);
            }
        }

        public 6(AbstractMergeEditor abstractMergeEditor, Context context) {
            this.v$context = context;
            this.this$0 = abstractMergeEditor;
        }
    }

    final class 7
    implements ChangeListener {
        public void stateChanged(ChangeEvent ce) {
            AbstractMergeEditor.mav$setNodeChangedWarningVisible(AbstractMergeEditor.this, ((NodeWatcher)((Object)ce.getSource())).isNodeDirty() && AbstractMergeEditor.this.isMergeModelBasedOnFile());
        }
    }

    final class 8
    implements Runnable {
        private final /* synthetic */ boolean v$cancelable;
        final /* synthetic */ AbstractMergeEditor this$0;

        public void run() {
            if (AbstractMergeEditor.ra$_progressPanel(this.this$0) != null) {
                AbstractMergeEditor.ra$_progressPanel(this.this$0).setCancelEnabled(this.v$cancelable);
            }
        }

        public 8(AbstractMergeEditor abstractMergeEditor, boolean bl) {
            this.v$cancelable = bl;
            this.this$0 = abstractMergeEditor;
        }
    }

    final class 9
    implements Runnable {
        public void run() {
            AbstractMergeEditor.mav$clearMergeAttributes(AbstractMergeEditor.this);
        }
    }

    private abstract class NodeWatcher
    extends ChangeEventSource {
        protected boolean _dirty;
        protected Node _node;

        NodeWatcher(Node node) {
            this._node = node;
        }

        void resetNodeDirty() {
            this._dirty = false;
            this.fireChangeEvent();
        }

        boolean isNodeDirty() {
            return this._dirty;
        }

        abstract void attach();

        abstract void detach();

        abstract Reader createReader() throws IOException;
    }

    private class TimestampNodeWatcher
    extends NodeWatcher
    implements VCSEBComponent {
        private final long _initialTimestamp;

        TimestampNodeWatcher(Node node) {
            super(node);
            this._initialTimestamp = URLFileSystem.lastModified((URL)node.getURL());
        }

        public void handleMessage(VCSEBMessage message) {
            if (!(message instanceof VCSNodeUpdate)) {
                return;
            }
            VCSNodeUpdate nodeUpdate = (VCSNodeUpdate)message;
            if (nodeUpdate.getWhat() == VCSNodeUpdate.RELOADED || nodeUpdate.getWhat() == VCSNodeUpdate.SAVED) {
                this._dirty = URLFileSystem.lastModified((URL)this._node.getURL()) != this._initialTimestamp;
                this.fireChangeEvent();
            }
        }

        void attach() {
            VCSEventBus.addToBus(this);
        }

        void detach() {
            VCSEventBus.removeFromBus(this);
        }

        Reader createReader() throws IOException {
            if (this._node instanceof TextNode) {
                return ((TextNode)this._node).getReader();
            }
            return new FileReader(URLFileSystem.getPlatformPathName((URL)this._node.getURL()));
        }
    }
}

